package com.mapr.cli;

import java.io.IOException;
import java.util.List;

import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;

public class NodesZKCleanup {

	private static ZooKeeper s_zk;
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		String zkConnectString = args[0];
		
	    try {
    		s_zk = new ZooKeeper(zkConnectString, NodeRemoveCommand.TIMEOUT_SERVER, null);
    		if ( s_zk.exists(NodeServicesManagementCommand.NODES_SERVICES_MNGMNT_TOP_PATH, false) != null ) {
    			deleteZKHierarchyRecursive(NodeServicesManagementCommand.NODES_SERVICES_MNGMNT_TOP_PATH);
    		}
		} catch (IOException e) {
		} catch (KeeperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}


	}

	private static void deleteZKHierarchyRecursive(String parentPath) throws KeeperException, InterruptedException {
		List<String> children = s_zk.getChildren(parentPath, false);
		for ( String child : children ) {
			deleteZKHierarchyRecursive(parentPath + "/" + child);
		}
		s_zk.delete(parentPath, -1);
	}
}
