package com.mapr.cli;


import static org.junit.Assert.*;

import java.io.IOException;
import java.util.List;

import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.ZooDefs.Ids;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.mapr.baseutils.ServiceManagingOperation;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cliframework.base.CLICommandFactory;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;

public class NodeServicesManagementTest {

	private static ZooKeeper s_zk;
	private static String zookeeperAddresses;
	
	private static final Logger LOG = Logger.getLogger(RemoveNodeTest.class);
	
	static {
		MapRCLIRegistry.getInstance().register();
	}

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		ZookeeperServerSetup.setUpZKServer();

	     // get zk addresses, ports
	     zookeeperAddresses = "localhost:" + ZookeeperServerSetup.testZKPort;
		    try {
	    		s_zk = new ZooKeeper(zookeeperAddresses, NodeRemoveCommand.TIMEOUT_SERVER, null);
			} catch (IOException e) {
			}

	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		ZookeeperServerSetup.tearDownZKServer();
	}

	@Before
	public void setUp() throws Exception {
		try {
			s_zk.create("/servers", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
			s_zk.create("/servers/server_", "10.10.10.11".getBytes(), Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
			s_zk.create("/servers/server_", "10.10.10.10".getBytes(), Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
			s_zk.create("/servers/server_", "127.0.0.1".getBytes(), Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
			s_zk.create("/servers/server_", "10.10.10.12".getBytes(), Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
			s_zk.create("/servers/server_", "10.10.10.13".getBytes(), Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
			s_zk.create("/servers/server_", "10.10.10.14".getBytes(), Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
		} catch (KeeperException.NodeExistsException e) {
			// ignore
		}

	}

	@After
	public void tearDown() throws Exception {
		List<String> znodes = s_zk.getChildren("/servers", false);
		for ( String node : znodes ) {
			s_zk.delete("/servers/" + node, -1);
		}
		s_zk.delete("/servers", -1);

	}

	@Test
	public void createZKStructTest() throws Exception {
		String [] args = new String [] {"node", "services", "-"+NodeRemoveCommand.ZK_CONNECTSTRING, zookeeperAddresses, "-filter", "[ hn == mapr-spitfire1* ]", "-cldb", "start", "-nfs", "stop", "-tasktracker", "resume"};

		ProcessedInput input = new ProcessedInput(args);
		CLIInterface commandIFace = CLICommandFactory.getInstance().getCLI(input);

		if ( commandIFace == null ) {
			LOG.error("Could not find Interface for a command: " + input.getCommandName());
			// print usage
			System.out.print(CLICommandFactory.getInstance().getUsage(false));
			return;
		}
		
		if ( !commandIFace.validateInput()) {
			System.out.print(commandIFace.getCLICommand().getUsageFromParametersOfCommandsTree());
			return;
		}
		
		CommandOutput output = commandIFace.executeCommand();

		Stat stats = s_zk.exists(NodeServicesManagementCommand.NODES_SERVICES_MNGMNT_TOP_PATH, false);
		
		assertNotNull(stats);
		
		stats = s_zk.exists(NodeServicesManagementCommand.NODES_SERVICES_MNGMNT_TOP_PATH + "/10.10.10.11" 
				+ NodeServicesManagementCommand.NODES_SERVICES_MNGMNT_SERVICE_PATH + "/" + ServicesEnum.cldb + "/" + ServiceManagingOperation.start, false);

		assertNotNull(stats);

		stats = s_zk.exists(NodeServicesManagementCommand.NODES_SERVICES_MNGMNT_TOP_PATH + "/10.10.10.11" 
				+ NodeServicesManagementCommand.NODES_SERVICES_MNGMNT_SERVICE_PATH + "/" + ServicesEnum.nfs + "/" + ServiceManagingOperation.stop, false);

		assertNotNull(stats);

		stats = s_zk.exists(NodeServicesManagementCommand.NODES_SERVICES_MNGMNT_TOP_PATH + "/10.10.10.11" 
				+ NodeServicesManagementCommand.NODES_SERVICES_MNGMNT_SERVICE_PATH + "/" + ServicesEnum.tasktracker + "/" + ServiceManagingOperation.resume, false);

		assertNotNull(stats);

		System.out.print(output.toPrettyString());
	}
	
	@Test
	public void createData() throws Exception {
	    String localzookeeperAddresses = "localhost:5181";
   		//ZooKeeper zk = new ZooKeeper(localzookeeperAddresses, NodeRemoveCommand.TIMEOUT_SERVER, null);

		String [] args = new String [] {"node", "services", "-"+NodeRemoveCommand.ZK_CONNECTSTRING, localzookeeperAddresses, "-filter", "[ip==10*11]", "-tasktracker", "start"};

		ProcessedInput input = new ProcessedInput(args);
		CLIInterface commandIFace = CLICommandFactory.getInstance().getCLI(input);

		if ( commandIFace == null ) {
			LOG.error("Could not find Interface for a command: " + input.getCommandName());
			// print usage
			System.out.print(CLICommandFactory.getInstance().getUsage(false));
			return;
		}
		
		if ( !commandIFace.validateInput()) {
			System.out.print(commandIFace.getCLICommand().getUsageFromParametersOfCommandsTree());
			return;
		}
		
		CommandOutput output = commandIFace.executeCommand();

	}
}
