package com.mapr.cli;

import static org.junit.Assert.*;

import java.io.IOException;
import java.util.List;

import org.junit.Test;
import org.ojai.FieldPath;

import com.mapr.db.Admin;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.TableDescriptor;
import com.mapr.fs.proto.Dbserver.ColumnFamilyAttr;;

public class JsonFieldPathTest {
  @Test
  public void testCfFieldPathInterconversion() throws IOException, Exception {
  TableDescriptor ts = MapRDB.newTableDescriptor();
  final String tableName = "/multiCFGet-TestMapRDBWithCluster";
  ts.setPath(tableName)
    .addFamily(MapRDB.newDefaultFamilyDescriptor())
    .addFamily(MapRDB.newFamilyDescriptor().setName("f1").setJsonFieldPath("a.b"))
    .addFamily(MapRDB.newFamilyDescriptor().setName("f2").setJsonFieldPath("a.b.c.d"))
    .addFamily(MapRDB.newFamilyDescriptor().setName("f3").setJsonFieldPath("a.b.c"))
    .addFamily(MapRDB.newFamilyDescriptor().setName("f4").setJsonFieldPath("x.a.b.c"));

  Admin admin = MapRDB.newAdmin();
      if (admin.tableExists(tableName)) {
      admin.deleteTable(tableName);
      }
  Table multiCFTable = admin.createTable(ts);
  final String userName = System.getProperty("user.name");
    List<ColumnFamilyAttr> cfList =
        DbReplicaCommands.getAllFamilies(multiCFTable.getPath().toString(),
                                     userName);
    //Test jsonPathToCfQualifier
    String jsonPath = "a.b.c[10].d";
    String cfCol = MapRDBTableImplHelper.jsonPathToCfQualifier(jsonPath, cfList);
    String[] cfQual = cfCol.split(":");
    assertEquals("f3", cfQual[0]);
    assertEquals("v[10].d", cfQual[1]);

    jsonPath = "a.b.c.d";
    cfCol = MapRDBTableImplHelper.jsonPathToCfQualifier(jsonPath,  cfList);
    cfQual = cfCol.split(":");
    assertEquals("f2", cfQual[0]);
    assertEquals(1, cfQual.length);

    jsonPath = "a.bb.c";
    cfCol = MapRDBTableImplHelper.jsonPathToCfQualifier(jsonPath,  cfList);
    cfQual = cfCol.split(":");
    assertEquals("default", cfQual[0]);
    assertEquals("a.bb.c", cfQual[1]);

    jsonPath = "a.b.c.dd";
    cfCol = MapRDBTableImplHelper.jsonPathToCfQualifier(jsonPath,  cfList);
    cfQual = cfCol.split(":");
    assertEquals("f3", cfQual[0]);
    assertEquals("v.dd", cfQual[1]);

    jsonPath = "";
    cfCol = MapRDBTableImplHelper.jsonPathToCfQualifier(jsonPath,  cfList);
    cfQual = cfCol.split(":");
    assertEquals("default", cfQual[0]);
    assertEquals(1, cfQual.length);

    jsonPath = "x.a.b.c[9]";
    cfCol = MapRDBTableImplHelper.jsonPathToCfQualifier(jsonPath,  cfList);
    cfQual = cfCol.split(":");
    assertEquals("f4", cfQual[0]);
    assertEquals("v[9]", cfQual[1]);

    //Test cfQualifierTojsonPath
    String cf = "f1";
    String qual = "v.c.d[10]";
    FieldPath path = MapRDBTableImplHelper.cfQualifierToJsonPath(cf, qual, cfList);
    assertEquals(FieldPath.parseFrom("a.b.c.d[10]"), path);

    cf = "default";
    qual = "v.a.c.d";
    path = MapRDBTableImplHelper.cfQualifierToJsonPath(cf, qual, cfList);
    assertEquals(FieldPath.parseFrom("v.a.c.d"), path);

    cf = "f3";
    qual = "v[10].d.e.f";
    path = MapRDBTableImplHelper.cfQualifierToJsonPath(cf, qual, cfList);
    assertEquals(FieldPath.parseFrom("a.b.c[10].d.e.f"), path);
  }
}
