package com.mapr.cli;


import static org.junit.Assert.*;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.AsyncCallback.ChildrenCallback;
import org.apache.zookeeper.ZooDefs.Ids;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.mapr.cli.common.NodesCommonUtils;

public class GetAllServicesTest {

	private static ZooKeeper s_zk;
	private static String zookeeperAddresses;
	
	private static final Logger LOG = Logger.getLogger(RemoveNodeTest.class);
	
	static {
		MapRCLIRegistry.getInstance().register();
	}

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		ZookeeperServerSetup.setUpZKServer();

	     // get zk addresses, ports
	     zookeeperAddresses = "localhost:" + ZookeeperServerSetup.testZKPort;
		    try {
	    		s_zk = new ZooKeeper(zookeeperAddresses, NodeRemoveCommand.TIMEOUT_SERVER, null);
			} catch (IOException e) {
			}
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		ZookeeperServerSetup.tearDownZKServer();
	}

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void getAllServicesNodesTest() throws Exception {
		s_zk.create("/services", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
		s_zk.create("/services/tasktracker", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
		s_zk.create("/services/jobtracker", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
		s_zk.create("/services/nfs", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
		s_zk.create("/services/cldb", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
		
		s_zk.create("/services/tasktracker/10.10.10.11", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
		s_zk.create("/services/tasktracker/10.10.10.12", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
		s_zk.create("/services/tasktracker/10.10.10.13", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
		s_zk.create("/services/tasktracker/10.10.10.14", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
		
		s_zk.create("/services/jobtracker/10.10.10.11", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
		s_zk.create("/services/jobtracker/10.10.10.12", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
		s_zk.create("/services/cldb/10.10.10.13", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
		s_zk.create("/services/cldb/10.10.10.14", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);

		s_zk.create("/services/nfs/10.10.10.12", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
		s_zk.create("/services/nfs/10.10.10.13", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);

		Map<String, List<String>> runningServices = NodesCommonUtils.findServicesRunningHierarchy(zookeeperAddresses);
		
		assertEquals(4, runningServices.size());
	}
	
}
