package com.mapr.cli;

import static org.junit.Assert.*;

import org.junit.Test;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.proto.CLDBProto.Policy;
import com.mapr.fs.cldb.proto.CLDBProto.SchedulePolicyProcRequest;
import com.mapr.fs.cldb.proto.CLDBProto.SchedulePolicyProcResponse;
import com.mapr.fs.cldb.proto.CLDBProto.isCLDBMasterRequest;
import com.mapr.fs.cldb.proto.CLDBProto.isCLDBMasterResponse;
import com.mapr.fs.cldb.proto.CLDBProto.SchedulePolicyProcRequest.SchedulePolicyOP;
import com.mapr.fs.proto.Common;


public class CldbFailoverHandlingTest {

	@Test
	public void cldbFailoverTest() throws Exception {
		isCLDBMasterRequest request = isCLDBMasterRequest.newBuilder().build();
		
		byte[] retBytes = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(),
                CLDBProto.CLDBProg.IsCLDBMasterProc.getNumber(), request, isCLDBMasterResponse.class);
		
		if ( retBytes != null ) {
			isCLDBMasterResponse response = isCLDBMasterResponse.parseFrom(retBytes);
			boolean isMaster = response.getIsMaster();
		}
		
		SchedulePolicyProcRequest.Builder scheduleRequestBuilder = SchedulePolicyProcRequest.newBuilder();
		scheduleRequestBuilder.setPolicyOp(SchedulePolicyOP.LIST);
		Policy.Builder policyBuilder = Policy.newBuilder();
		scheduleRequestBuilder.setPolicy(policyBuilder.build());

		retBytes = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId
                .CldbProgramId.getNumber(),
                CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), 
                scheduleRequestBuilder.build(), SchedulePolicyProcResponse.class);

		if ( retBytes != null ) {
			SchedulePolicyProcResponse resp = SchedulePolicyProcResponse.parseFrom(retBytes);
		}
	}
	
	@Test
	public void regexTest() throws Exception {
		String line = "  ## dfgadfgd ##";
		boolean isStartsWithComment = line.matches("^\\s*#.*");
		assertTrue(isStartsWithComment);
	}
	
	
}
