import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.CombineMessageRequest;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.Counters;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.JobMetric;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.Metric;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.MetricAttributes;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.TaskAttemptMetric;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.TaskMetric;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.TimedMetric;
import com.mapr.util.MapRFSUtil;

public class TestReadingHistoryTransactionDataNew {
  private static final Logger LOG = Logger.getLogger(TestReadingHistoryTransactionDataNew.class);
  /**
   * @param args
   */
  public static void main(String[] args) {
    if ( args.length < 1 ) {
      System.out.println("Usage: <fileName>");
      System.exit(0);
    }
    String metricsFile = args[0];
    FSDataInputStream fsdis = null;
    long now = System.currentTimeMillis();
    int readMetrcisCount =0;
    int readRequestsCount = 0;
    long readBytesCount = 0;
    System.out.println("Start reading file: " + new Date(now));
    try {
      fsdis = MapRFSUtil.getMapRFileSystem().open(new Path(metricsFile));
      
      long jobSubmitTime = fsdis.readLong();
      System.out.println("Job submitTime: " + jobSubmitTime);
      int indexPosition = 8;
      TreeMap<Long, Long> hourlyMap = new TreeMap<Long, Long>(); 
      while (indexPosition < 1008) {
        short hour = fsdis.readShort();
        indexPosition += 2;
        if ( hour == 0 ) {
          // there is nothing after prevHour
          // read to the end
          if ( hourlyMap.isEmpty() ) {
            hourlyMap.put(1l, Long.MAX_VALUE);
          } else {
            Map.Entry<Long, Long> lastEntry = hourlyMap.lastEntry();
            hourlyMap.put(lastEntry.getKey()+1, Long.MAX_VALUE);
          }
          break;
        } else {
          // might be an hour
          System.out.println("Next time interval: " + hour);
          long newHourPosition = fsdis.readLong();
          indexPosition +=8;
          System.out.println("Next position: " + newHourPosition);
          if ( newHourPosition < 1008) {
            System.out.println("Bad position: " + newHourPosition);
            // read from previous hour till the end
          } else {
            hourlyMap.put((long)hour, newHourPosition);
          }
        }
      }
      fsdis.seek(1008);
      //hourlyMap.remove(hour);
      long position = 1008;
      
      for (Map.Entry<Long, Long> entry : hourlyMap.entrySet()) {
        long hour = entry.getKey();
        long hourPosition = entry.getValue();
        System.out.println("Hour data: (" + hour + ", " + hourPosition + ")");
        
      while (position < hourPosition ) {
         int nexRecordbytesCount = fsdis.readInt();
        LOG.info("written bytes: " +  nexRecordbytesCount);
        byte [] buf = new byte[nexRecordbytesCount];
        int readBytes = fsdis.read(buf, 0, nexRecordbytesCount);
       // LOG.info("Number of read bytes : " + readBytes + ", written bytes: " +  nexRecordbytesCount);
        if ( readBytes != nexRecordbytesCount ) {
          LOG.info("Number of read bytes : " + readBytes + " != written bytes: " +  nexRecordbytesCount);
        }
        position += (4 + readBytes);
        readBytesCount += readBytes;
        CombineMessageRequest.Builder requestBuilder = CombineMessageRequest.newBuilder();
        requestBuilder.mergeFrom(buf);
        readRequestsCount++;
        int timedMetricsCount = requestBuilder.getTimedMetricCount();
        long time = requestBuilder.getTimedMetric(0).getTimestamp();
        System.out.println("Time: " + time + ", as Date: " + new Date(time));
        
        for ( TimedMetric tMetric : requestBuilder.getTimedMetricList()) {
          for ( Metric metric : tMetric.getMetricList()) {
            if ( metric.hasJobMetric()) {
              JobMetric jMetric = metric.getJobMetric();
              if ( jMetric.hasFinalMetric() ) {
                // problem ?
              } 
              if ( jMetric.hasEventMetric() ) {
                JobMetric.EventMetric jEvent = jMetric.getEventMetric();
                if ( jEvent.hasPriority() ) {
                  System.out.println("Priority : " + jEvent.getPriority());
                }
                if ( jEvent.hasFailureInfo() ) {
                  System.out.println("FailInfo : " + jEvent.getFailureInfo());
                }
                if ( jEvent.hasSchedulingInfo() ) {
                  System.out.println("ScheduleInfo : " + jEvent.getSchedulingInfo());
                }
                if ( jEvent.hasStatus() ) {
                  System.out.println("Status : " + jEvent.getStatus());
                }
              }
              if ( jMetric.hasAttributes() ) {
                MetricAttributes mAttr = jMetric.getAttributes();
                if ( mAttr.hasJobId() ) {
                  System.out.println("Job ID : " + mAttr.getJobId());
                }
                if ( mAttr.hasTaskId() ) {
                  System.out.println("Task ID : " + mAttr.getTaskId());
                }
                if ( mAttr.hasTaskAttemptId() ) {
                  System.out.println("TAID : " + mAttr.getTaskAttemptId());
                }
              }
              for ( Counters counter : jMetric.getTimeBasedCountersList() ) {
                System.out.println(counter.getCounterName() + " : " + counter.getCounterValue());
              }
            }
            if ( metric.hasTaskMetric()) {
              TaskMetric taskMetric = metric.getTaskMetric();
              if ( taskMetric.hasFinalMetric() ) {
                TaskMetric.FinalMetric tFinal = taskMetric.getFinalMetric();
                if ( tFinal.hasId() ) {
                  System.out.println("TASK ID : " + tFinal.getId());
                }
                if ( tFinal.hasJobId() ) {
                  System.out.println("JOB ID : " + tFinal.getJobId());
                }
                if ( tFinal.hasEndTime()) {
                  System.out.println("Task End Time : " + tFinal.getEndTime());
                }
                if ( tFinal.hasInputSplitInfo()) {
                  System.out.println("InputSplit : " + tFinal.getInputSplitInfo());
                }
                if ( tFinal.hasInputSplitLocations() ) {
                  System.out.println("InputSplitLoc : " + tFinal.getInputSplitLocations());
                }
                if ( tFinal.hasStartTime()) {
                  System.out.println("Task Start Time : " + tFinal.getStartTime());
                }
                if ( tFinal.hasStatus()) {
                  System.out.println("Task Status : " + tFinal.getStatus());
                }
                if ( tFinal.hasSuccessTaskAttemptId()) {
                  System.out.println("Success TA ID : " + tFinal.getSuccessTaskAttemptId());
                }
                if ( tFinal.hasType() ) {
                  System.out.println("Task Type : " + tFinal.getType());
                }
              }
              if ( taskMetric.hasEventMetric() ) {
                TaskMetric.EventMetric tEvent = taskMetric.getEventMetric();
                if ( tEvent.hasStatus() ) {
                  System.out.println("Task Status : " + tEvent.getStatus());
                }
              }
            }
            if ( metric.hasTAttemptMetric()) {
              TaskAttemptMetric taskAtMetric = metric.getTAttemptMetric();
              if ( taskAtMetric.hasAttributes() ) {
                MetricAttributes mAttr = taskAtMetric.getAttributes();
                if ( mAttr.hasTaskAttemptId() ) {
                  System.out.println("Task Attempt ID: " + mAttr.getTaskAttemptId());
                }
              }
              if ( taskAtMetric.hasProgressPercent()) {
                System.out.println("TA Progress : " + taskAtMetric.getProgressPercent());
              }
              for ( Counters counter : taskAtMetric.getCountersList() ) {
                System.out.println(counter.getCounterName() + " : " + counter.getCounterValue());
              }
              if ( taskAtMetric.hasEventMetric() ) {
                TaskAttemptMetric.EventMetric tAEvent = taskAtMetric.getEventMetric();
                if ( tAEvent.hasState() ) {
                  System.out.println("Task Attempt State : " + tAEvent.getState());
                }
                if ( tAEvent.hasStateString()) {
                  System.out.println("Task Attempt State String : " + tAEvent.getStateString());
                }
                for ( String diagn : tAEvent.getDiagnosticInfoList()) {
                  System.out.println("DIAGNOSTIC : " + diagn);
                }
              }
              if ( taskAtMetric.hasFinalMetric() ) {
                TaskAttemptMetric.FinalMetric taFinal = taskAtMetric.getFinalMetric();
                System.out.println("Task Attempt ID : " + taFinal.getId());
                System.out.println("Task ID : " + taFinal.getTaskId());
                if ( taFinal.hasHost()) {
                  System.out.println("HOST : " + taFinal.getHost());
                }
                if ( taFinal.hasFinishTime()) {
                  System.out.println("TA Finish : " + taFinal.getFinishTime());
                }
                if ( taFinal.hasLogLocation()) {
                  System.out.println("Log Location : " + taFinal.getLogLocation());
                }
                if ( taFinal.hasShuffleFinished()) {
                  System.out.println("Shuffle : " + taFinal.getShuffleFinished());
                }
                if ( taFinal.hasSortFinished()) {
                  System.out.println("Sort : " + taFinal.getSortFinished()); 
                }
                if ( taFinal.hasStartTime()) {
                  System.out.println("Start Time : " + taFinal.getStartTime());
                }
                if ( taFinal.hasState()) {
                  System.out.println("Task Attempt State : " + taFinal.getState()); 
                }
                if ( taFinal.hasType()) {
                  System.out.println("Type : " + taFinal.getType());
                }
                for ( Counters counter : taFinal.getCountersList() ) {
                  System.out.println(counter.getCounterName() + " : " + counter.getCounterValue());
                }
              }
            }
          }
        }
        
        readMetrcisCount += timedMetricsCount;
        LOG.info("MetricsCount: " + timedMetricsCount + ", at Time: " + new Date(time));
      }
      //fsdis.seek(hourPosition);
      }
     } catch (FileNotFoundException e) {
      LOG.error("Metrics file not found. Path: " + metricsFile, e);
    } catch (EOFException e) {
      try {
        if ( fsdis != null ) {
          fsdis.close();
        }
      } catch (IOException e1) {
        // TODO Auto-generated catch block
        e1.printStackTrace();
      }      
    } catch (IOException e) {
      LOG.error("I/O Exception while reading metrics file. Path: " + metricsFile, e);
    } catch (Throwable t) {
      LOG.error("Exception", t);
    }
    long after = System.currentTimeMillis();
    System.out.println("Time took to read file: " + (after - now) + 
        " ms. for : " + readMetrcisCount + 
        " of metrics" + ", requestsCount: " + readRequestsCount
        + ", readBytes: " + readBytesCount);
  }


}
