import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;

import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.CombineMessageRequest;
import com.mapr.util.MapRFSUtil;

public class TestReadingDataFromMaprFs {

    private static final Logger LOG = Logger.getLogger(TestReadingDataFromMaprFs.class);
    /**
     * @param argsnexRecordbytesCount
     */
    public static void main(String[] args) {
      if ( args.length < 1 ) {
        System.out.println("Usage: <fileName>");
        System.exit(0);
      }
      String metricsFile = args[0];
      FSDataInputStream fsdis = null;
      long now = System.currentTimeMillis();
      int readMetrcisCount =0;
      int readRequestsCount = 0;
      long readBytesCount = 0;
      System.out.println("Start reading file: " + new Date(now));
      try {
        fsdis = MapRFSUtil.getMapRFileSystem().open(new Path(metricsFile));
        // first 4 bytes should be file length
        int fileLength = fsdis.readInt();
        while (true ) {
          int nexRecordbytesCount = fsdis.readInt();
          LOG.info("written bytes: " +  nexRecordbytesCount);
          byte [] buf = new byte[nexRecordbytesCount];
          int readBytes = fsdis.read(buf, 0, nexRecordbytesCount);
          if ( readBytes < 0 ) {
            // nothing more to read it should be end of file
            // compare if fileLength matches
            if ( fileLength == nexRecordbytesCount ) {
              LOG.info("End of file is reached sucessfully. Length matches. First lenght: " + fileLength + ", Last Length: " + nexRecordbytesCount);
            } else {
              // might be that file is still being written into
              LOG.warn("Warning while reading data file. File might be still being written into. Length does not match. First lenght: " + fileLength + ", Last Length: " + nexRecordbytesCount);
            }
            long after = System.currentTimeMillis();
            System.out.println("Time took to read file: " + (after - now) + 
                " ms. for : " + readMetrcisCount + 
                " of metrics" + ", requestsCount: " + readRequestsCount
                + ", readBytes: " + readBytesCount);

            if ( fsdis != null ) {
              fsdis.close();
            }
            return;
          }
         // LOG.info("Number of read bytes : " + readBytes + ", written bytes: " +  nexRecordbytesCount);
          if ( readBytes != nexRecordbytesCount ) {
            LOG.info("Number of read bytes : " + readBytes + " != written bytes: " +  nexRecordbytesCount);
          }
          readBytesCount += readBytes;
          CombineMessageRequest.Builder requestBuilder = CombineMessageRequest.newBuilder();
          requestBuilder.mergeFrom(buf);
          readRequestsCount++;
          int timedMetricsCount = requestBuilder.getTimedMetricCount();
          long time = requestBuilder.getTimedMetric(0).getTimestamp();
          readMetrcisCount += timedMetricsCount;
          LOG.info("MetricsCount: " + timedMetricsCount + ", at Time: " + new Date(time));
          CombineMessageRequest msg = requestBuilder.build();
        }
       } catch (FileNotFoundException e) {
        LOG.error("Metrics file not found. Path: " + metricsFile, e);
      } catch (EOFException e) {
        try {
          if ( fsdis != null ) {
            fsdis.close();
          }
        } catch (IOException e1) {
          LOG.error("IOException", e1);
        }      
      } catch (IOException e) {
        LOG.error("I/O Exception while reading metrics file. Path: " + metricsFile, e);
      } catch (Throwable t) {
        LOG.error("Exception", t);
      }
      /*
      long after = System.currentTimeMillis();
      System.out.println("Time took to read file: " + (after - now) + 
          " ms. for : " + readMetrcisCount + 
          " of metrics" + ", requestsCount: " + readRequestsCount
          + ", readBytes: " + readBytesCount);
      
      FSDataInputStream fsdisM = null;
      int desiredHour = -1;
      System.out.println("Time before reading by hour: " + new Date(after));
      LOG.info("Time before reading by hour: " + new Date(after));
      try {
        fsdisM = MapRFSUtil.getMapRFileSystem().open(new Path(metricsFile));
        fsdis = MapRFSUtil.getMapRFileSystem().open(new Path(metricsFile + ".index"));
        if ( args.length > 1 ) {
          desiredHour = Integer.valueOf(args[1]);
        }
        if ( fsdis != null ) {
          while ( true ) {
          byte hour = fsdis.readByte();
          long numberOfWrittenBytes = fsdis.readLong();
          if ( desiredHour > -1 && desiredHour < hour ) {
            continue;
          }
          if ( desiredHour == -1 || desiredHour == hour ) {
            // reading hour
            fsdisM.seek(numberOfWrittenBytes);
            long currentPos = fsdisM.getPos();
            System.out.println("Hour: " + hour + ", BytesCount: " + numberOfWrittenBytes + ", Current POS: " + currentPos);
            
            int nexRecordbytesCount = fsdisM.readInt();
            LOG.info("written bytes: " +  nexRecordbytesCount);
            byte [] buf = new byte[nexRecordbytesCount];
            fsdisM.read(buf, 0, nexRecordbytesCount);
    
            CombineMessageRequest.Builder requestBuilder = CombineMessageRequest.newBuilder();
            requestBuilder.mergeFrom(buf);
            int timedMetricsCount = requestBuilder.getTimedMetricCount();
            long time = requestBuilder.getTimedMetric(0).getTimestamp();
            LOG.info("MetricsCount: " + timedMetricsCount + ", at Time: " + new Date(time));
          }
          if ( desiredHour == hour ) {
            break;
          }
        }
        }
      } catch (EOFException e) {
        LOG.error("EOFException", e);
        try {
          if ( fsdis != null ) {
            fsdis.close();
          }
          if ( fsdisM != null ) {
            fsdisM.close();
          }
        } catch (IOException e1) {
          LOG.error("IOException", e1);
        }
        } catch (IOException e) {
          LOG.error("IOException", e);
      }
        System.out.println("Time taken reading by hour: " + (System.currentTimeMillis() - after));
        */
    }
    
}
