package com.mapr.security.simplesasl;

import java.util.Map;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class GenericLoginModule implements LoginModule {
  
  /**
   * The java vendor name used in this platform.
   */
  public static final String JAVA_VENDOR_NAME = System.getProperty("java.vendor");
  
  /**
   * A public static variable to indicate the current java vendor is
   * IBM java or not.
   */
  public static final boolean IBM_JAVA = JAVA_VENDOR_NAME.contains("IBM");

    private static final boolean windows = 
              System.getProperty("os.name").startsWith("Windows");
    private static final boolean is64Bit = System.getProperty("os.arch").contains("64");
    private static final boolean aix = System.getProperty("os.name").equals("AIX");
    private static final String OS_LOGIN_MODULE_NAME;

    private static String getOSLoginModuleName() {
      if (IBM_JAVA) {
        if (windows) {
          return is64Bit ? "com.ibm.security.auth.module.Win64LoginModule"
                 : "com.ibm.security.auth.module.NTLoginModule";
        } else if (aix) {
          return is64Bit ? "com.ibm.security.auth.module.AIX64LoginModule"
                 : "com.ibm.security.auth.module.AIXLoginModule";
        } else {
          return "com.ibm.security.auth.module.LinuxLoginModule";
        }
      } else {
           return windows ? "com.sun.security.auth.module.NTLoginModule"
                : "com.sun.security.auth.module.UnixLoginModule";
      }
    }
       
    static {
      OS_LOGIN_MODULE_NAME = getOSLoginModuleName();
    }
    
    private LoginModule realModule;

    @Override
    public boolean abort() throws LoginException {
      return realModule.abort();
    }

    @Override
    public boolean commit() throws LoginException {
      return realModule.commit();
    }

    @Override
    public void initialize(Subject arg0, CallbackHandler arg1,
        Map<String, ?> arg2, Map<String, ?> arg3) {
      
      try {
        realModule = (LoginModule) Class.forName(OS_LOGIN_MODULE_NAME).newInstance();
      } catch (Exception e) {
        throw new RuntimeException("Failure to instantiate needed login module: " + OS_LOGIN_MODULE_NAME, e);
      }
      
      realModule.initialize(arg0,  arg1, arg2, arg3);
    }

    @Override
    public boolean login() throws LoginException {
      return realModule.login();
    }

    @Override
    public boolean logout() throws LoginException {
      return realModule.logout();
    }

}
