package com.mapr.security.maprauth;

import com.mapr.fs.proto.Security.Key;
import com.mapr.fs.proto.Security.ServerKeyType;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.server.CookieSignatureSecretFactory;
import org.apache.log4j.Logger;


/**
 * Author: smarella
 */
public class MaprSignatureSecretFactory implements CookieSignatureSecretFactory {
  private static final Logger LOG = Logger.getLogger(MaprSignatureSecretFactory.class);

  @Override
  public String getSignatureSecret() {
    String signatureSecret = null;
    MutableInt err = new MutableInt();
    Key key = Security.GetKey(ServerKeyType.ServerKey, err);
    if (key != null) {
      // Bug 14522: Don't use com.google.protobuf.ByteString.toString.
      // It is not doing the right thing at-least in protobuf 2.5.
      signatureSecret = new String(key.getKey().toByteArray());
      if (LOG.isDebugEnabled()) {
        LOG.debug("Picked up " + ServerKeyType.ServerKey.name() + " to sign " + AuthenticatedURL.AUTH_COOKIE + " cookie");
      }
    } else {
      LOG.warn("Couldn't retrieve " + ServerKeyType.ServerKey.name()
          + ", most likely because MapR security is not enabled.");
    }
    return signatureSecret;
  }

}
