package com.mapr.security.maprauth;

import java.io.IOException;
import java.util.Properties;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.MultiMechsAuthenticationHandler;
import org.apache.log4j.Logger;

import com.mapr.login.PasswordAuthentication;

public class BasicAuthHandler extends MultiMechsAuthenticationHandler {

  private static final Logger LOG = Logger.getLogger(BasicAuthHandler.class);
  private static final String BASIC_AUTH = "Basic";
 
  @Override
  public void init(Properties config) throws ServletException {
  }
  
  @Override
  public AuthenticationToken postauthenticate(HttpServletRequest request, 
      final HttpServletResponse response)
  throws IOException, AuthenticationException {
    AuthenticationToken authToken = null;
    String authorization = request.getHeader(KerberosAuthenticator.AUTHORIZATION);
    if ( authorization != null && authorization.startsWith(BASIC_AUTH) ) {
      try
      {
          if(LOG.isDebugEnabled())  {
            LOG.debug("Credentials: "+authorization);
          }
          authorization = authorization.substring(authorization.indexOf(' ')+1);
          authorization = new String(Base64.decodeBase64(authorization));
          int i = authorization.indexOf(':');
          String username = authorization.substring(0,i);
          String password = authorization.substring(i+1);
          if ( PasswordAuthentication.authenticate(username, password) ) {
            authToken = new AuthenticationToken(username, username, getType());
            response.setStatus(HttpServletResponse.SC_OK);
          } else {
            response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
            LOG.error("User Principal is null while trying to authenticate with Basic Auth");
          }        
      }
      catch (Exception e)
      {
          LOG.warn("AUTH FAILURE: "+e.toString());
      }
   }

    return authToken;
  }
/*
  @Override
  public String getType() {
    return "basic";
  }
*/
  @Override
  public void addHeader(HttpServletResponse response) {
    response.addHeader(KerberosAuthenticator.WWW_AUTHENTICATE, "Basic realm=\""+"WebLogin"+'"');
  }

  @Override
  public MultiMechsAuthenticationHandler getAuthBasedEntity(String authorization) {
    if ( authorization != null && authorization.startsWith(BASIC_AUTH) ) {
      return this;
    }
    return null;
  }

}
