package com.mapr.security.callback;

import java.io.IOException;
import java.io.Serializable;

import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;


public class MaprSaslCallbackHandler implements CallbackHandler {

  @SuppressWarnings("serial")
  public static class MaprCallback implements Callback, Serializable {
    
    private Subject subject;
    private String userName;
    public MaprCallback() {
      
    }
    
    public Subject getSubject() {
      return this.subject;
    }
    public void setSubject(Subject subject) {
      this.subject = subject;
    }
  
    public void setUserName(String userName) {
      this.userName = userName;
    }
  
    public String getUserName() {
      return userName;
    }
    
  }

  private Subject subject;
  private String userName;
  
  public MaprSaslCallbackHandler(Subject subject, String userName) {
    this.subject = subject;
    this.userName = userName;
  }
  
  @Override
  public void handle(Callback[] callbacks) throws IOException,
      UnsupportedCallbackException {
    MaprSaslCallbackHandler.MaprCallback mc = null;
    for (Callback callback : callbacks) {
      if (callback instanceof MaprSaslCallbackHandler.MaprCallback) {
        mc = (MaprSaslCallbackHandler.MaprCallback) callback;
        break;
      } else {
        throw new UnsupportedCallbackException(callback,
            "Unrecognized SASL client callback");
      }
    }
    if ( mc != null ) {
      mc.setSubject(subject);
      mc.setUserName(userName);
    }
  }
  
}
