package com.mapr.security;

/*
 * This interface defines methods to obtain user and group information.
 * 
 * It provides the following functionality:
 * Given a username, obtain the uid and gids
 * Given a groupname, obtain the gid
 * Given a uid, obtain the username
 * Given a gid, obtain the groupname
 * 
 * Given a username, invoke setuid to set the uid
 * of the process.
 */
public interface UserInformation {
  public int getUserId(String username) throws SecurityException;

  public int[] getGroups(String username) throws SecurityException;

  public int getGroupId(String groupname) throws SecurityException;
  
  public String getUsername(int uid) throws SecurityException;
  
  public String getGroupname(int gid) throws SecurityException;

  public void setUID(String username) throws SecurityException;  

  // getuid()
  public String getLoggedinUsername() throws SecurityException;
  
}
