package com.mapr.security;

import org.apache.commons.lang.builder.HashCodeBuilder;

import com.mapr.fs.proto.Security.ServerKeyType;
import com.mapr.fs.proto.Security.TicketAndKey;

public class TicketKeyAndTypeTuple {

  private final TicketAndKey ticketAndKey;
  private final ServerKeyType keyType;
  
  public TicketKeyAndTypeTuple(ServerKeyType keyType, TicketAndKey ticketAndKey) {
    this.ticketAndKey = ticketAndKey;
    this.keyType = keyType;
  }

  public TicketAndKey getTicketAndKey() {
    return ticketAndKey;
  }

  public ServerKeyType getKeyType() {
    return keyType;
  }
  
  @Override
  public boolean equals(Object other) {
    if ( other == null ) {
      return false;
    }
    if ( other instanceof TicketKeyAndTypeTuple) {
      TicketKeyAndTypeTuple tOther = (TicketKeyAndTypeTuple) other;
      if ( this.getKeyType().equals(tOther.getKeyType()) &&
          this.getTicketAndKey().equals(tOther.getTicketAndKey())) {
        return true;
      }
    }
    return false;
  }
  
  @Override
  public int hashCode() {
    return new HashCodeBuilder().append(keyType).append(ticketAndKey).toHashCode();
  }
}
