package com.mapr.security;

import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

import com.google.protobuf.ByteString;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.proto.Security.AuthenticationReqFull;
import com.mapr.fs.proto.Security.ServerKeyType;
import com.mapr.fs.proto.Security.TicketAndKey;

/**
 * SecurityHelper class
 *
 */
public class SecurityHelper {

  private static final Logger LOG = Logger.getLogger(SecurityHelper.class);
  
  public static byte[] zookeeperAuthRequestCreationHelper(TicketAndKey ticketAndKey, long sessionId) {
    if ( ticketAndKey == null ) {
      LOG.error("TicketAndKey is null");
      return null;
    }
    MutableInt err = new MutableInt();
          
    long randomSecret = System.currentTimeMillis();
    byte[] writeBuffer = new byte[16];
    writeBuffer[0] = (byte)(randomSecret >>> 56);
    writeBuffer[1] = (byte)(randomSecret >>> 48);
    writeBuffer[2] = (byte)(randomSecret >>> 40);
    writeBuffer[3] = (byte)(randomSecret >>> 32);
    writeBuffer[4] = (byte)(randomSecret >>> 24);
    writeBuffer[5] = (byte)(randomSecret >>> 16);
    writeBuffer[6] = (byte)(randomSecret >>>  8);
    writeBuffer[7] = (byte)(randomSecret >>>  0);

    writeBuffer[8] = (byte)(sessionId >>> 56);
    writeBuffer[9] = (byte)(sessionId >>> 48);
    writeBuffer[10] = (byte)(sessionId >>> 40);
    writeBuffer[11] = (byte)(sessionId >>> 32);
    writeBuffer[12] = (byte)(sessionId >>> 24);
    writeBuffer[13] = (byte)(sessionId >>> 16);
    writeBuffer[14] = (byte)(sessionId >>>  8);
    writeBuffer[15] = (byte)(sessionId >>>  0);

    AuthenticationReqFull.Builder bld = AuthenticationReqFull.newBuilder();
    byte [] secretBytesEncrypted = Security.Encrypt(ticketAndKey.getUserKey(), writeBuffer, err);
    if ( err.GetValue() != 0 ) {
      LOG.error("Could not encrypt ticket with error: " + err.GetValue());
      return null;
    }

    bld.setEncryptedRandomSecret(ByteString.copyFrom(secretBytesEncrypted));
    bld.setEncryptedTicket(ticketAndKey.getEncryptedTicket());
    byte [] authRequestBytes = bld.build().toByteArray();
    
    authRequestBytes = Base64.encodeBase64(authRequestBytes);
    return authRequestBytes;
 }
  
 public static TicketAndKey ticketReadingHelper() {
    String ticketFileLocation = JNISecurity.GetUserTicketAndKeyFileLocation();
    if ( ticketFileLocation == null ) {
      LOG.error("TicketKey file is not found");
      return null;
    }
    
    MutableInt err = new MutableInt();
    int errorCode = Security.SetTicketAndKeyFile(ticketFileLocation);
    if ( errorCode != 0 ) {
      LOG.error("Problem with TicketKey file: " + errorCode);
      return null;
    }
    //TODO it may not be current cluster we are trying to get???
    String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
    if ( currentClusterName == null ) {
      LOG.error("Current cluster name is not found");
      return null;
    }
    
    TicketAndKey ticketAndKey = Security.GetTicketAndKeyForCluster(ServerKeyType.ServerKey, currentClusterName, err);
    if ( ticketAndKey == null ) {
      LOG.error("MaprTicket is not found");
      return null;
    }
    if (!Security.IsTicketAndKeyUsable(ticketAndKey)) {
      LOG.error("My Mapr ticket is expired. Get new one");
      return null;
    }
    return ticketAndKey;
  }
}
