package com.mapr.security;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;

public class JNISecurity {
  public static class MutableErr {
      private int value;
      public MutableErr() {
        value = 0;
      }  
      public int GetValue() { return value; }
      public  void SetValue(int value) { this.value = value; }
  }

  public static native byte []
    Encrypt(byte [] key, byte[] inBuf, MutableErr err);
  public static native int GetDecryptedSize(int cipherTextSize);
  public static native byte[]
    Decrypt(byte [] key, byte[] inBuf, MutableErr err);
  public static native int SetKeyFileInternal(int keyType, String path);
  public static native byte[] GetKeyInternal(int keyType, MutableErr err);
  public static native byte[] GenerateTicketAndKeyInternal(
      int keyType, String userName,
      int uid, int [] gids, long expiryTime, long maxRenewalTimeSec,
      boolean isExternal, boolean canUserImpersonate, MutableErr err);
  public static native byte [] GenerateTicketAndKeyUsingServerKeyInternal(
      int keyType, byte []key, String userName,
      int uid, int [] gids, long expiryTime, long maxRenewalTimeSec,
      boolean isExternal, MutableErr err);
  public static native byte [] RenewTicketAndKeyInternal(
      int keyType, byte[] ticketAndKey, long expiryTime, MutableErr err);
  public static native byte[]
    DecryptTicketInternal(byte[] encryptedTicket, MutableErr err);
  public static native int SetTicketAndKeyInternal(int keyType,
      String clusterName, byte [] ticketAndKey);
  public static native int SetTicketAndKeyFileInternal(String path);
  public static native int UseClusterTicketAsServerTicketInternal();
  public static native int SetKeyInternal(int keyType, byte [] key);
  public static native byte []
    GetTicketAndKeyForClusterInternal(int keyType,
                              String clusterName, MutableErr err);

  // Initialise the security class 
  // should be called before using any of the methods
  public static native int Initialize();

  public static native boolean IsSecurityEnabled(String clusterName);

  // Returns a 64 bit random number
  public static native long GenerateRandomNumber();

  // Fills the byte array with random bytes
  public static native void GenerateRandomBlock(byte[] buf);

  // Encodes the serializedProtobuf data for writing to file. 
  // on failure error is returned in err parameter
  // on success the encoded data is returned
  public static native byte[] 
    EncodeDataForWritingToKeyFile(byte[] serializedProtobuf, MutableErr err);


  // Decodes the encoded data read from file.
  // on failure error is returned in err parameter
  // on success the return byte array has decoded data
  public static native byte[]
    DecodeDataFromKeyFile(byte[] encodedData, MutableErr err);

  // Generates SHA256 hash of the input byte array data
  // HashType 0 is used for SHA256. In future other hash type
  // might be used to use other hash types. 
  public static native byte[] GetHash(int hashType, byte[] buf);

  // returns the TicketAndKeyFile location for the current user
  // if the env variable MAPR_TICKETFILE_LOCATION is set then it
  // uses that else it returns the default path prefix_<uid>.
  public static native String GetUserTicketAndKeyFileLocation();
  
  public static native boolean IsKerberosEnabled(String clusterName);
  public static native boolean IsReplayDetectionDisabled(String clusterName);
  public static native int GetCldbHttpsPort(String clusterName);
  public static native String GetCldbPrincipal(String clusterName);

  public static native boolean IsParsingDone();
  public static native void SetParsingDone();
  
  public static native int SetClusterOption(String clusterName, 
                               String key, String value);
  public static native String GetClusterOption(String clusterName, String key);
  
  public static native int PopulateServerKeyAndTicket(long[] bindings,
                                                      String clusterName);
  public static native void BlacklistAndCloseConnections(int[] uids,
                                                        long[] blacklistTimes,
                                                        boolean reinitList);
  public static native void RemoveFromBlacklist(int[] uids);
}
