package com.mapr.login.common;

import flexjson.JSONDeserializer;
import flexjson.JSONSerializer;
import org.json.JSONException;

/**
 * Author: smarella
 */
public class RenewRequest {
  private String ticketAndKeyString;
  private Long ticketDurInSecs;

  public RenewRequest() {
  }

  public String getTicketAndKeyString() {
    return this.ticketAndKeyString;
  }

  public void setTicketAndKeyString(String ticketAndKeyString) {
    this.ticketAndKeyString = ticketAndKeyString;
  }

  public Long getTicketDurInSecs() {
    return ticketDurInSecs;
  }

  public void setTicketDurInSecs(Long ticketDurInSecs) {
    this.ticketDurInSecs = ticketDurInSecs;
  }

  @Override
  public String toString() {
    return "ticketAndKeyString: " + (ticketAndKeyString == null ? "null" : ticketAndKeyString);
  }

  public static String toJSON(RenewRequest request) throws JSONException {
    return new JSONSerializer().serialize(request);
  }

  public static RenewRequest fromJSON(String json) throws JSONException {
    return new JSONDeserializer<RenewRequest>().deserialize(json);
  }

}
