/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.login.common;

import org.json.JSONException;
import org.json.JSONObject;

import flexjson.JSONSerializer;
import flexjson.JSONDeserializer;


public class PasswordAuthRequest {
  private String userName;
  private String passWord;
  private Long ticketDurInSecs;

  public PasswordAuthRequest() {
  }

  public String getUserName() {
    return this.userName;
  }

  public String getPassWord() {
    return this.passWord;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public void setPassWord(String passWord) {
    this.passWord = passWord;
  }

  public Long getTicketDurInSecs() {
    return ticketDurInSecs;
  }

  public void setTicketDurInSecs(Long ticketDurInSecs) {
    this.ticketDurInSecs = ticketDurInSecs;
  }

  @Override
  public String toString() {
    return "user: " + userName + ", password: xxxxxx";
  }

  public static String toJSON(PasswordAuthRequest req) throws JSONException {
    return new JSONSerializer().serialize(req);
  }

  public static PasswordAuthRequest fromJSON(String json) throws JSONException {
    return new JSONDeserializer<PasswordAuthRequest>().deserialize(json);
  }

}
