/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.login.common;

import org.json.JSONException;

import flexjson.JSONSerializer;
import flexjson.JSONDeserializer;


public class KerberosAuthRequest {
  private String token;
  private Long ticketDurInSecs;

  public KerberosAuthRequest() {
  }

  public KerberosAuthRequest(final String token) {
    this.token = token;
  }

  public String getToken() {
    return this.token;
  }

  public void setToken(String token) {
    this.token = token;
  }

  public Long getTicketDurInSecs() {
    return ticketDurInSecs;
  }

  public void setTicketDurInSecs(Long ticketDurInSecs) {
    this.ticketDurInSecs = ticketDurInSecs;
  }

  @Override
  public String toString() {
    return "krb token: " + token;
  }

  public static String toJSON(KerberosAuthRequest req) throws JSONException {
    return new JSONSerializer().serialize(req);
  }

  public static KerberosAuthRequest fromJSON(String json) throws JSONException {
    return new JSONDeserializer<KerberosAuthRequest>().deserialize(json);
  }

}
