package com.mapr.login.common;

import flexjson.JSONDeserializer;
import flexjson.JSONSerializer;
import org.json.JSONException;

/**
 * Author: smarella
 */
public class GenTicketTypeRequest {
  public enum TicketType {SERVICE, CROSSCLUSTER,
    SERVICEWITHIMPERSONATION, DEFAULT};
  
  private String ticketAndKeyString;
  private Long ticketDurInSecs;
  private Long ticketRenewInSecs;
  private String targetUserName;
  private TicketType ticketType;

  public GenTicketTypeRequest() {
  }

  public String getTicketAndKeyString() {
    return this.ticketAndKeyString;
  }

  public void setTicketAndKeyString(String ticketAndKeyString) {
    this.ticketAndKeyString = ticketAndKeyString;
  }

  public Long getTicketDurInSecs() {
    return ticketDurInSecs;
  }

  public void setTicketDurInSecs(Long ticketDurInSecs) {
    this.ticketDurInSecs = ticketDurInSecs;
  }

  public Long getTicketRenewInSecs() {
    return ticketRenewInSecs;
  }

  public void setTicketRenewInSecs(Long ticketRenewInSecs) {
    this.ticketRenewInSecs = ticketRenewInSecs;
  }

  public String getTargetUserName() {
    return targetUserName;
  }

  public void setTargetUserName(String targetUserName) {
    this.targetUserName = targetUserName;
  }

  public TicketType getTicketType() {
    return ticketType;
  }

  public void setTicketType(TicketType ticketType) {
    this.ticketType = ticketType;
  }

  @Override
  public String toString() {
    return "ticketAndKeyString: " + (ticketAndKeyString == null ? "null" : ticketAndKeyString);
  }

  public static String toJSON(GenTicketTypeRequest request) throws JSONException {
    return new JSONSerializer().serialize(request);
  }

  public static GenTicketTypeRequest fromJSON(String json) throws JSONException {
    return new JSONDeserializer<GenTicketTypeRequest>().deserialize(json);
  }

}
