/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.login.common;

import com.mapr.baseutils.Errno;

import flexjson.JSONDeserializer;
import flexjson.JSONSerializer;
import org.json.JSONException;

public class AuthResponse {
  private int status = Errno.SUCCESS;
  private String error;
  private String ticketAndKeyString;
  private String token; //additional token used by Kerberos

  public AuthResponse() {
  }

  public int getStatus() {
    return status;
  }

  public void setStatus(int status) {
    this.status = status;
  }

  public String getError() {
    return error;
  }

  public void setError(String error) {
    this.error = error;
  }

  public String getTicketAndKeyString() {
    return this.ticketAndKeyString;
  }

  public void setTicketAndKeyString(String ticketAndKeyString) {
    this.ticketAndKeyString = ticketAndKeyString;
  }

  public String getToken() {
    return this.token;
  }

  public void setToken(String token) {
    this.token = token;
  }

  @Override
  public String toString() {
    return "status: " + status + ", error: " + error + ", ticketAndKeyString: " +
      (ticketAndKeyString == null ? "null" : ticketAndKeyString);
  }

  public static String toJSON(AuthResponse response) throws JSONException {
    return new JSONSerializer().serialize(response);
  }

  public static AuthResponse fromJSON(String json) throws JSONException {
    return new JSONDeserializer<AuthResponse>().deserialize(json);
  }

}
