package com.mapr.login.client;

import com.mapr.fs.proto.Security.TicketAndKey;
import com.mapr.login.MapRLoginException;
import com.mapr.login.common.GenTicketTypeRequest.TicketType;

/**
 * Author: smarella
 */
public interface MapRLoginClient {

  public TicketAndKey getMapRCredentialsViaPassword(String username,
      String password, Long desiredTicketDurInSecs) throws MapRLoginException;
  public TicketAndKey getMapRCredentialsViaPassword(String cluster, String username,
      String password, Long desiredTicketDurInSecs, String ticketLocation) throws MapRLoginException;

  public TicketAndKey getMapRCredentialsViaKerberos(
      Long desiredTicketDurInSecs) throws MapRLoginException;
  public TicketAndKey getMapRCredentialsViaKerberos(String cluster,
      Long desiredTicketDurInSecs) throws MapRLoginException;

  public TicketAndKey authenticateIfNeeded() throws MapRLoginException;
  public TicketAndKey authenticateIfNeeded(String cluster) throws MapRLoginException;

  public void setCheckUGI(boolean checkUGI);
  public boolean isSecurityEnabled() throws MapRLoginException;
  public boolean isSecurityEnabled(String cluster) throws MapRLoginException;

  public void logOut() throws MapRLoginException;
  public void logOut(String cluster) throws MapRLoginException;

  public TicketAndKey renew(Long desiredTicketDurInSecs)
      throws MapRLoginException;
  public TicketAndKey renew(String cluster, Long desiredTicketDurInSecs,
                            String inTicketFile, String ticketLocation)
      throws MapRLoginException;

  public TicketAndKey generateTicket(TicketType ticketType,
                                     String targetUserName,
                                     String cluster,
                                     Long desiredTicketDurInSecs,
                                     Long renewalTicketDurInSecs,
                                     String ticketFileLocation)
                                     throws MapRLoginException;
}
