package com.mapr.login;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.login.LoginContext;
import java.io.IOException;
import org.apache.log4j.Logger;
import com.mapr.baseutils.JVMProperties;

/*

This simple class supports password based authentication. It does this
using a JAAS login configuration.
*/

public class PasswordAuthentication {
  static {
    JVMProperties.init();
  }
  public static final String PASSWORD_PAM_JAAS_CONFIGUATION="jpamLogin";
  private static Logger LOG = Logger.getLogger(PasswordAuthentication.class);

  static class JAASCallbackHandler implements CallbackHandler {
    private String user;
    private String pass;

    public JAASCallbackHandler(String user, String pass) {
      this.user = user;
      this.pass = pass;
    }

    public void handle(Callback[] callbacks) 
          throws IOException, UnsupportedCallbackException {
      for (int i = 0; i < callbacks.length; i++)
        if (callbacks[i] instanceof NameCallback)
          ((NameCallback)callbacks[i]).setName(user);
        else if (callbacks[i] instanceof PasswordCallback)
          ((PasswordCallback)callbacks[i]).setPassword(pass.toCharArray());
        else
          throw new UnsupportedCallbackException(callbacks[i], "unsupported callback - " + callbacks[i].getClass().getName());
    }
  }

  static public boolean authenticate(String user, String pass) {

    try {
      LoginContext ctx = new LoginContext(PASSWORD_PAM_JAAS_CONFIGUATION, new JAASCallbackHandler(user, pass));
      ctx.login();
    } catch (LoginException e) {
      LOG.info("Failed authentication for user " + user + ": " + e);
      LOG.debug("exception:", e);
      return false;
    }
    return true;
  }

  public static void main(String argv[]) throws Exception {
    LOG.addAppender(new org.apache.log4j.ConsoleAppender(new org.apache.log4j.SimpleLayout()));
    String u = argv[0];
    String p = argv[1];
    System.out.println("Authenticating user = " + u + " password = " + p);
    if (PasswordAuthentication.authenticate(u, p))
      System.out.println("Success.");
    else System.out.println("Failure.");
  }
};
