package com.mapr.cli.table;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Author: smarella
 */
public class RecentTablesListManagers {
  private static Map<String, RecentTablesListManager> registry = Maps.newHashMap();

  public synchronized static RecentTablesListManager getRecentTablesListManagerForUser(String user) {
    if (!registry.containsKey(user)) {
      registry.put(user, new RecentTablesListManager(user));
    }
    return registry.get(user);
  }

}
