package com.mapr.cli.common;

import com.mapr.fs.cldb.proto.CLDBProto.VolumeInfoFields;
import com.mapr.fs.proto.Common.PluggableAlarm;

/**
 * User: agliga
 */

/**
 * Class that holds Node field info. Takes NodeInfo or an int/string to use as node identifier
 */
public class VolumeField {
  private VolumeInfoFields nodeInfo;
  private String fieldLabel;
  private int fieldId;
  private PluggableAlarm pluggableAlarm;

  public VolumeField(VolumeInfoFields nodeInfo) {
    this.fieldId = nodeInfo.getNumber();
    this.fieldLabel = nodeInfo.name();
    this.nodeInfo = nodeInfo;
    pluggableAlarm = null;
  }

  public VolumeField(String fieldName, int fieldId) {
    this.fieldId = fieldId;
    this.fieldLabel = fieldName;
    pluggableAlarm = null;
    nodeInfo = null;
  }

  public VolumeField(PluggableAlarm pluggableAlarm) {
    this.fieldId = pluggableAlarm.getId();
    this.fieldLabel = pluggableAlarm.getDisplayName();
    this.pluggableAlarm = pluggableAlarm;
    nodeInfo = null;
  }

  public int getId() {
    return fieldId;
  }

  public String getLabel() {
    return fieldLabel;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    VolumeField volumeField = (VolumeField) o;

    if (fieldId != volumeField.fieldId) return false;
    if (fieldLabel != null ? !fieldLabel.equals(volumeField.fieldLabel) : volumeField.fieldLabel != null) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = fieldLabel != null ? fieldLabel.hashCode() : 0;
    result = 31 * result + fieldId;
    return result;
  }
}

