package com.mapr.cli.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

import com.google.common.collect.Lists;
import com.mapr.baseutils.LogDirectoryFindingUtils;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.security.JNISecurity;

public enum ServicesEnum {
  cldb("all", JNISecurity.IsSecurityEnabled(CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) ?
      String.valueOf(JNISecurity.GetCldbHttpsPort(CLDBRpcCommonUtils.getInstance().getCurrentClusterName())) : "7221",
      "/cldb.jsp", MapRCliUtil.getMapRInstallDir() + "/logs/cldb.log", "CLDB"),
  fileserver("all", "5660", null, MapRCliUtil.getMapRInstallDir() + "/logs/mfs.log", "FileServer"),
	jobtracker("1", "50030", "/jobtracker.jsp", fetchLogPath("classic"), "JobTracker"),
	nfs("all", "9998", null, MapRCliUtil.getMapRInstallDir() + "/logs/nfsserver.log", "NFS Gateway"),
	hbmaster("1", fetchHbasePort("16010", "60010"), "/master.jsp", fetchLogPath("hbase"), "HBase Master"),
	hbregionserver("all", fetchHbasePort("16030", "60030"), "/regionserver.jsp", fetchLogPath("hbase"), "HBase RegionServer"),
	tasktracker("all", "50060", "/tasktracker.jsp", fetchLogPath("classic"), "TaskTracker"),
	webserver("all", null, null, MapRCliUtil.getMapRInstallDir() + "/logs/adminuiapp.log", "Webserver"),
	hoststats("all", null, null, MapRCliUtil.getMapRInstallDir() + "/logs/hoststats.log", "HostStats"),
	resourcemanager("1", JNISecurity.IsSecurityEnabled(CLDBRpcCommonUtils.getInstance().getCurrentClusterName())?"8090":"8088", "/cluster", fetchLogPath("yarn"), "ResourceManager"),
  nodemanager("all", JNISecurity.IsSecurityEnabled(CLDBRpcCommonUtils.getInstance().getCurrentClusterName())?"8044":"8042", "/", fetchLogPath("yarn"), "NodeManager"),
  historyserver("1", JNISecurity.IsSecurityEnabled(CLDBRpcCommonUtils.getInstance().getCurrentClusterName())?"19890":"19888", "/jobhistory", fetchLogPath("yarn"), "JobHistoryServer");

  private static final String LOG_DIR_NAME = "logs";
  private static FileFilter dirFilter = new FileFilter() {
    @Override
    public boolean accept(File file) {
      return file.isDirectory();
    }
  };

	private static String getVersion(String serviceDir, String file){
		String serviceDirPath=MapRCliUtil.getMapRInstallDir()+"/"+serviceDir;
		try {
			BufferedReader fr=new BufferedReader(new FileReader(serviceDirPath+"/"+file));
			String version=fr.readLine();
			fr.close();
			if(version!=null){
				return version;
			} else {
				return "";
			}
		} catch (IOException e){
			return "";
		}
  }

  private static String fetchHbasePort(String newPort, String oldPort){
		String hbaseVersion = getVersion("hbase", "hbaseversion");
		if(!hbaseVersion.isEmpty()){
			String[]hbaseSplit=hbaseVersion.split("\\.");
			if(hbaseSplit[0].equals("0")) {
				return oldPort;
			}
		}
			// Default return if here
			return newPort;
  }

  private static String fetchLogPath(String serviceDir) {
    JNISecurity.GetCldbHttpsPort(CLDBRpcCommonUtils.getInstance().getCurrentClusterName());

    String serviceDirPath = MapRCliUtil.getMapRInstallDir() + "/" + serviceDir;
    if ( "hbase".equalsIgnoreCase(serviceDir) ){
      // get directory from hbaseversion
      String hbaseVersion=getVersion(serviceDir,"hbaseversion");
      if(!hbaseVersion.isEmpty()){
        serviceDirPath=serviceDirPath.concat("/hbase-"+hbaseVersion);
      }
		}
    if ( "classic".equalsIgnoreCase(serviceDir) || "yarn".equalsIgnoreCase(serviceDir)) {
    	return LogDirectoryFindingUtils.getHadoopLogsDirectory(MapRCliUtil.getMapRInstallDir(), serviceDir);
    }

    List<File> dirs = Lists.newArrayList(new File(serviceDirPath));
    while (!dirs.isEmpty()) {
      List<File> subDirs = Lists.newArrayList();
      for (File dir : dirs) {
        if (dir.getName().equals(LOG_DIR_NAME)) {
          return dir.getAbsolutePath();
        } else {
          File[] childDirs = dir.listFiles(dirFilter);
          if (childDirs != null) {
            Collections.addAll(subDirs, childDirs);
          }
        }
      }
      dirs.clear();
      dirs.addAll(subDirs);
    }

    return serviceDirPath;
  }

  /**
	 * Default number of service instances per cluster
	 */
	private String serviceTotal;
	private String port;
	private String webLink;
	private String logPath;
	private String displayName;


	private ServicesEnum(String serviceTotalDefault, String port, String webLink, String logPath, String displayName) {
		this.serviceTotal = serviceTotalDefault;
		this.port = port;
		this.webLink = webLink;
		this.logPath = logPath;
		this.displayName = displayName;
	}

	private ServicesEnum(String serviceTotalDefault, String port) {
		this.serviceTotal = serviceTotalDefault;
		this.port = port;
	}

	private ServicesEnum(String serviceTotalDefault) {
		this.serviceTotal = serviceTotalDefault;
	}

	public String getserviceTotal() {
		return serviceTotal;
	}

	public String getServiceTotal() {
		return serviceTotal;
	}

	public String getWebLink() {
		return webLink;
	}

	public String getPort() {
		return port;
	}

	public String getLogPath() {
	  return logPath;
	}

	public String getDisplayName() {
		return displayName;
	}

}
