/**
 * Singleton utility class to create and authenticate security token
 */
package com.mapr.cli.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Naveen Tirupattur
 */
public class SecurityTokenHelper {

  private static final SecurityTokenHelper INSTANCE = new SecurityTokenHelper();
  private Map<String, ArrayList<String>> tokensMap = new HashMap<String,ArrayList<String>>();

  private SecurityTokenHelper() { }

  public static SecurityTokenHelper getInstance() {
      return INSTANCE;
  }

  public String generateToken(String userName)
  {
    ArrayList<String> tokensList=null;
    //Check if this user was encountered before
    if(tokensMap.containsKey(userName))
    {
      //If yes, get the tokens list
      tokensList = tokensMap.get(userName);
    }else
    {
      //Create a new tokens list
      tokensList = new ArrayList<String>();
    }
    //Generate the token
    String token = generateString(userName);
    //Add it to tokens list
    tokensList.add(token);
    tokensMap.put(userName, tokensList);
    return token;
  }

  public String generateString(String userName)
  {
    return userName+String.valueOf(System.currentTimeMillis());
  }

  public boolean isValidToken(String userName, String token)
  {
    //Check if this user was encountered before
    if(!tokensMap.containsKey(userName))
    { //If no, return false
      return false;
    }
    else
    {
      //If yes, check if the token exists in the user's token list
      ArrayList<String> tokensList = tokensMap.get(userName);
      if(tokensList != null && tokensList.contains(token))
      {
        tokensList.remove(token);
        return true;
      }
    }
    return false;
  }
}
