package com.mapr.cli.common;

import com.mapr.fs.cldb.proto.CLDBProto.NodeInfo;
import com.mapr.fs.proto.Common.PluggableAlarm;

/**
 * User: agliga
 * Date: 1/17/14
 * Time: 8:30 AM
 */

/**
 * Class that holds Node field info. Takes NodeInfo or an int/string to use as node identifier
 */
public class NodeField {
  private NodeInfo nodeInfo;
  private String fieldLabel;
  private int fieldId;
  private PluggableAlarm pluggableAlarm;

  public NodeField(NodeInfo nodeInfo) {
    this.fieldId = nodeInfo.getNumber();
    this.fieldLabel = nodeInfo.name();
    this.nodeInfo = nodeInfo;
    pluggableAlarm = null;
  }

  public NodeField(String fieldName, int fieldId) {
    this.fieldId = fieldId;
    this.fieldLabel = fieldName;
    pluggableAlarm = null;
    nodeInfo = null;
  }

  public NodeField(PluggableAlarm pluggableAlarm) {
    this.fieldId = pluggableAlarm.getId();
    this.fieldLabel = pluggableAlarm.getDisplayName();
    this.pluggableAlarm = pluggableAlarm;
    nodeInfo = null;
  }

  public int getId() {
    return fieldId;
  }

  public String getLabel() {
    return fieldLabel;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    NodeField nodeField = (NodeField) o;

    if (fieldId != nodeField.fieldId) return false;
    if (fieldLabel != null ? !fieldLabel.equals(nodeField.fieldLabel) : nodeField.fieldLabel != null) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = fieldLabel != null ? fieldLabel.hashCode() : 0;
    result = 31 * result + fieldId;
    return result;
  }
}

