package com.mapr.cli.common;

import com.google.protobuf.MessageLite;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy;

/**
 * 
 * Interface to fetch records from server in iterations.
 * 
 * @author smarella
 *
 */
public interface ListIterator {

  /**
   * Initiates the iteration process.
   * while (hasMore()) {
   *    buildNextRequest
   *    sendRequest
   *    processResponse
   * }
   * @param out - The output of all the processed responses.
   * @throws CLIProcessingException
   */
  public void list(OutputHierarchy out) throws CLIProcessingException;

  /**
   * Inspect the last request and last response to see if there are more records to be fetched.
   * 
   * @param prevReq
   * @param prevResp
   * @return - true, if there are more records. false, if no more.
   * @throws CLIProcessingException
   */
  public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException;

  /**
   * Builds the next request object by inspecting the previous request and previous response.
   * @param req - Previous request
   * @param resp - Previous response
   * @return - new request object
   * @throws CLIProcessingException
   */
  public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException;
  
  /**
   * Send the request using RPC and fetch the response.
   * 
   * @param req - request object.
   * @return - the response object.
   * @throws CLIProcessingException
   */
  public MessageLite sendRequest(MessageLite req) throws CLIProcessingException;
  
  /**
   * Parse the response and populate the output hierarchy.
   * @param out - {@link OutputHierarchy}
   * @param resp - response object
   * @throws CLIProcessingException
   */
  public void processResponse(OutputHierarchy out, MessageLite resp) throws CLIProcessingException;

}
