/**
 *  Utility to create ExecutorService and track the job status
 */
package com.mapr.cli.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.apache.log4j.Logger;

public class JobExecutor {
  
  private static Map<String, Double> statusMap = new ConcurrentHashMap<String,Double>();
  private static final Logger LOG = Logger.getLogger(CopyTableCallable.class);
  private static final ExecutorService es = Executors.newFixedThreadPool(20);
  
  public static void setStatus(String key, Double value) throws Exception
  {
    statusMap.put(key, value);
  }
  
  public static Double getStatus(String key)
  {
    return (null == statusMap)?null:statusMap.get(key);
  }
  
  public static ExecutorService getExecutorService()
  {
    return es;
  }

}
