package com.mapr.cli.common;

import com.mapr.cliframework.base.CLIProcessingException;
import org.apache.hadoop.security.UserGroupInformation;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;

import org.apache.log4j.Logger;

/**
 * A util class to be used for anything FileClient related
 * At the moment only has a handler for impersonation
 * to use, instantiate the class and override the runAsProxyUser method.
 * The method overridden in runAsProxyUser will be called using impersonation
 */
public abstract class FileclientRun {
  private static final Logger LOG = Logger.getLogger(FileclientRun.class);

  // Override this method when instantiating class
  abstract public void runAsProxyUser() throws CLIProcessingException, IOException;

  /**
   * Constructor
   *
   * @param user The user to run runAsProxyUser method as
   *
   */
  public FileclientRun(String user) throws CLIProcessingException, IOException {
    try {
      // Get user group information for proxy user
      UserGroupInformation ugi = UserGroupInformation.createProxyUser(
          user, UserGroupInformation.getLoginUser());

      // Run as user
      ugi.doAs(new PrivilegedExceptionAction<Void>() {
        public Void run() throws Exception {
          // Run runAsProxyUser
          try {
              runAsProxyUser();
          } catch (IOException e) {
              throw new InterruptedException(e.getMessage());
          } catch (CLIProcessingException e) {
              throw new InterruptedException(e.getMessage());
          }
          return null;
        }
      });
    } catch (InterruptedException e) {
      // Catch any errors and throw as CLIProcessingException
      // Should be handled by MapR cli (to output to user the errors)
      throw new CLIProcessingException(e.getMessage());
    } 
  }
}
