package com.mapr.cli.bulk;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;

import org.apache.log4j.Logger;

import com.google.common.collect.Lists;

public class TaskCompletionService extends ExecutorCompletionService<TaskResult> {
  private static final Logger LOG = Logger.getLogger(TaskCompletionService.class);
  private static final int NUM_THREADS = 3;
  private static final TaskCompletionService service = new TaskCompletionService();
  
  private int taskCount = 0;
  
  private TaskCompletionService() {
    super(Executors.newFixedThreadPool(NUM_THREADS));
  }
  
  public static TaskCompletionService getInstance() {
    return service;
  }
  
  public void submitTasks(Collection<Task> tasks) {
    for (Task task : tasks) {
      this.submit(task);
      this.taskCount++;
    }
  }

  public List<TaskResult> fetchResults() {
    List<TaskResult> results = Lists.newArrayList();
    try {
      for (int i = 0; i < this.taskCount; i++) {
        TaskResult result = this.take().get();
        if (result == null || result.getStatus() != 0) {
          LOG.warn("Task " + result.getTaskName() + " has failed. Reason: " + result.getFailureMsg());
        }
        results.add(result);
      }
    } catch (Exception e) {
      LOG.error("Exception while fetching the results for tasks.", e);
    } finally {
      this.taskCount = 0;
    }
    return results;
  }
}
