package com.mapr.cli.bulk;

import java.util.List;

import org.apache.log4j.Logger;

import com.google.common.collect.Lists;
import com.mapr.baseutils.Errno;

public abstract class AbstractTask implements Task {
  private static final Logger LOG = Logger.getLogger(AbstractTask.class);
  
  private String taskName;
  private List<Task> dependencies = Lists.newArrayList();
  
  protected AbstractTask(String taskName) {
    this.taskName = taskName;
  }

  @Override
  public TaskResult call() {
    if (LOG.isDebugEnabled()) {
      LOG.debug("Executing task: " + this.taskName + " on thread " + Thread.currentThread().getName());
    }
    
    for (Task dependent : dependencies) {
      TaskResult depResult = dependent.call();
      if (depResult.getStatus() != Errno.SUCCESS) {
        return depResult;
      }
    }
    TaskResult validationResult = this.validateInput();
    if (validationResult.getStatus() != Errno.SUCCESS) {
      validationResult.setTaskName(this.taskName);
      return validationResult;
    }
    TaskResult taskResult = this.executeTask();
    taskResult.setTaskName(this.taskName);
    return taskResult;
  }
  
  @Override
  public void setDependencies(Task... dependencies) {
    if (dependencies != null) {
      this.dependencies.clear();
      for (Task dependent : dependencies) {
        this.dependencies.add(dependent);
      }
    }
  }

  @Override
  public List<Task> getDependencies() {
    return this.dependencies;
  }
  
  public abstract TaskResult validateInput();
  
  public abstract TaskResult executeTask();
}
