package com.mapr.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import mapr.fs.Replicationserver;
import mapr.fs.Replicationserver.GetResyncStatusAndStartResyncRequest;
import mapr.fs.Replicationserver.GetResyncStatusAndStartResyncResponse;

import org.apache.log4j.Logger;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.Errno;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy.OutputNode;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.CLICommand.ExecutionTypeEnum;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy.OutputError;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.proto.CLDBProto.ContainerCreateRequest;
import com.mapr.fs.cldb.proto.CLDBProto.ContainerCreateResponse;
import com.mapr.fs.cldb.proto.CLDBProto.ContainerInfo;
import com.mapr.fs.cldb.proto.CLDBProto.ContainerOnFileServerFailRequest;
import com.mapr.fs.cldb.proto.CLDBProto.ContainerOnFileServerFailResponse;
import com.mapr.fs.cldb.proto.CLDBProto.MirrorInfo;
import com.mapr.fs.cldb.proto.CLDBProto.MirrorInfo.MirrorStatus;
import com.mapr.fs.cldb.proto.CLDBProto.MirrorStartRequest;
import com.mapr.fs.cldb.proto.CLDBProto.MirrorStartResponse;
import com.mapr.fs.cldb.proto.CLDBProto.MirrorStopRequest;
import com.mapr.fs.cldb.proto.CLDBProto.MirrorStopResponse;
import com.mapr.fs.cldb.proto.CLDBProto.SnapshotContainersMapRequest;
import com.mapr.fs.cldb.proto.CLDBProto.SnapshotContainersMapResponse;
import com.mapr.fs.cldb.proto.CLDBProto.SnapshotCreateRequest;
import com.mapr.fs.cldb.proto.CLDBProto.SnapshotCreateResponse;
import com.mapr.fs.cldb.proto.CLDBProto.SnapshotRemoveRequest;
import com.mapr.fs.cldb.proto.CLDBProto.SnapshotRemoveResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeContainersMapRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeContainersMapResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeLookupRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeLookupResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeProperties;
import com.mapr.fs.cldb.proto.CLDBProto.VolumePropertiesLookupRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumePropertiesLookupResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeUpdateRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeUpdateResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeUpdateRequest.MirrorOp;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Common.IPAddress;
import com.mapr.fs.proto.Security.CredentialsMsg;

public class VolumeDumpFileCommands extends CLIBaseClass 
                                  implements CLIInterface {

  private static final Logger LOG = Logger.getLogger(VolumeDumpFileCommands.class);

  public static final String VOLUME_PARAM_NAME = "name";
  public static final String DUMP_FILE_NAME = "dumpfile";
  public static final String START_VOLUME_POINT_NAME = "s";
  public static final String END_VOLUME_POINT_NAME = "e";
  public static final String DUMP_FILE_ON_STDOUT = "o";
  public static final String DUMP_FILE_FROM_STDIN = "i";
  public static final String CREATE_NEW_VOLUME = "n";
 
  CredentialsMsg srcCreds;
  CredentialsMsg dstCreds;
  
  public static final String createDumpUsage =
    "volume dump create [-s startvolumepoint name] [-e endvolumepoint name] " +
    "[-o (for dumpfile on stdout)]  -name volumename " +
    "-dumpfile dumpfilename (ignored if -o specified) " +
    "[-cluster clustername]";
  
  public static final String restoreDumpUsage = 
    "volume dump restore [-i (read dumpfile from stdin)] " +
    "[-n (create new volume if volume doesn't exist)] " +
    "-name volumename -dumpfile dumpfile (ignored if -i specified)" +
    "[-cluster clustername]";

  
  public static final CLICommand createDumpCommand = 
    new CLICommand(
      "create", 
      "",
      VolumeDumpFileCommands.class, ExecutionTypeEnum.NATIVE,
      new ImmutableMap.Builder<String, BaseInputParameter>()
        .putAll(VolumeCommands.baseParams)
        .put(VolumeDumpFileCommands.START_VOLUME_POINT_NAME,
            new TextInputParameter(
                VolumeDumpFileCommands.START_VOLUME_POINT_NAME,
                "start volumepoint name", CLIBaseClass.NOT_REQUIRED, null))

        .put(VolumeDumpFileCommands.END_VOLUME_POINT_NAME,
            new TextInputParameter(
                VolumeDumpFileCommands.END_VOLUME_POINT_NAME,
                "end volumepoint name", CLIBaseClass.NOT_REQUIRED, null))

        .put(VolumeDumpFileCommands.DUMP_FILE_ON_STDOUT,
            new TextInputParameter(
                VolumeDumpFileCommands.DUMP_FILE_ON_STDOUT,
                "(generate dumpfile on stdout)", CLIBaseClass.NOT_REQUIRED, null))

        .put(VolumeDumpFileCommands.DUMP_FILE_NAME,
            new TextInputParameter(
                VolumeDumpFileCommands.DUMP_FILE_NAME,
                "dumpfilename (not needed if -o is used)", CLIBaseClass.REQUIRED, null))

        .put(VolumeDumpFileCommands.VOLUME_PARAM_NAME,
            new TextInputParameter(
                VolumeDumpFileCommands.VOLUME_PARAM_NAME,
                "volumename", CLIBaseClass.REQUIRED, null))

         .build(), null)

  .setShortUsage(createDumpUsage);

  public static final CLICommand restoreDumpCommand = 
    new CLICommand(
      "restore", "",
      VolumeDumpFileCommands.class, ExecutionTypeEnum.NATIVE,
      new ImmutableMap.Builder<String, BaseInputParameter>()
        .putAll(VolumeCommands.baseParams)
        .put(VolumeDumpFileCommands.DUMP_FILE_FROM_STDIN,
            new TextInputParameter(
                VolumeDumpFileCommands.DUMP_FILE_FROM_STDIN,
                "(read dumpfile from stdin)", CLIBaseClass.NOT_REQUIRED, null))

        .put(VolumeDumpFileCommands.CREATE_NEW_VOLUME,
            new TextInputParameter(
                VolumeDumpFileCommands.CREATE_NEW_VOLUME,
                "(create new volume if it doesn't exist)", CLIBaseClass.NOT_REQUIRED, null))

        .put(VolumeDumpFileCommands.DUMP_FILE_NAME,
            new TextInputParameter(
                VolumeDumpFileCommands.DUMP_FILE_NAME,
                "dumpfilename (not needed if -i is used)", CLIBaseClass.REQUIRED, null))

        .put(VolumeDumpFileCommands.VOLUME_PARAM_NAME,
            new TextInputParameter(
                VolumeDumpFileCommands.VOLUME_PARAM_NAME,
                "volumename", CLIBaseClass.REQUIRED, null))      

                .build(), null)
    .setShortUsage(restoreDumpUsage);

  public static CLICommand[] dumpCommandsArray = {
    createDumpCommand,
    restoreDumpCommand,
  };

  public static CLICommand dumpCommands = new CLICommand(
      "dump", "dump", CLIUsageOnlyCommand.class,
      ExecutionTypeEnum.NATIVE, 
      dumpCommandsArray)
  .setShortUsage("dump [create|restore]");
  
  public VolumeDumpFileCommands(ProcessedInput input, CLICommand cliCommand) {
    super(input, cliCommand);
  }
  
  @Override
  public CommandOutput executeRealCommand() throws CLIProcessingException {
    
    if (LOG.isDebugEnabled()) {
      LOG.debug("ExecuteRealCommand" + cliCommand.getCommandName());
    }
    
    init();
    
    if (cliCommand.getCommandName().equalsIgnoreCase("create2")) {
      try {
        return createDump();
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Create dump Exception 
        * Function:VolumeDumpFileCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */

        throw new CLIProcessingException("Create dump Exception ", e);
      }
    } else if (cliCommand.getCommandName().equalsIgnoreCase("restore")) {
      try {
        return restoreDump();
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Restore dump Exception
        * Function:VolumeDumpFileCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */

        throw new CLIProcessingException("Restore dump Exception", e);
      } 
    }
    return null;
  }

  private CommandOutput createDump() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);

    String volumeName;
    String dumpDir;
    
    volumeName = 
          getParamTextValue(VolumeDumpFileCommands.VOLUME_PARAM_NAME, 0);
    dumpDir = getParamTextValue(VolumeDumpFileCommands.DUMP_FILE_NAME, 0);
    
    LOG.info("Creating dumpfile for volume " + volumeName	+ " in dump directory " + dumpDir);
    
    CredentialsMsg.Builder srccreds = CredentialsMsg.newBuilder();
    srccreds.setUid(0);
    srccreds.addGids(0);

    CredentialsMsg.Builder destcreds = CredentialsMsg.newBuilder();
    destcreds.setUid(0);
    destcreds.addGids(0);
   /* 
    new VolumeDumpFile(volumeName, clusterName, dumpDir, 
    		srccreds.build(), destcreds.build()).createDump();
  */
    return output;
  }

  private CommandOutput restoreDump() throws CLIProcessingException {
	    CommandOutput output = new CommandOutput();
	    OutputHierarchy out = new OutputHierarchy();
	    output.setOutput(out);

	    String volumeName;
	    String dumpDir;
	      
	    volumeName = 
	          getParamTextValue(VolumeDumpFileCommands.VOLUME_PARAM_NAME, 0);
	    dumpDir = getParamTextValue(VolumeDumpFileCommands.DUMP_FILE_NAME, 0);
	    
	    System.out.println("Restore volume " + volumeName + 
	                       " from dumpfile in directory " + dumpDir);
	    return output;
	  }

  void init() throws CLIProcessingException {    
    srcCreds = getUserCredentials();
    dstCreds = getUserCredentials();
  }  
}
