/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.cli;

import static org.junit.Assert.*;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BitSetBytesHelperUtils;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.GetStringsForAuditOps;
import com.mapr.cli.bulk.Task;
import com.mapr.cli.bulk.TaskCompletionService;
import com.mapr.cli.bulk.VolumeRemoveTask;
import com.mapr.cli.bulk.VolumeUnMountTask;
import com.mapr.cli.common.AuthManager;
import com.mapr.cli.common.ListCommand;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.PluggableAlarmUtil;
import com.mapr.cli.common.VolumeField;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLICommand.ExecutionTypeEnum;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy.OutputError;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy.OutputNode;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.AceHelper;
import com.mapr.fs.MapRClientImpl;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.VolumeUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.proto.CLDBProto.AeKey;
import com.mapr.fs.cldb.proto.CLDBProto.FileServerInfo;
import com.mapr.fs.cldb.proto.CLDBProto.MirrorInfo;
import com.mapr.fs.cldb.proto.CLDBProto.MirrorInfo.MirrorStatus;
import com.mapr.fs.cldb.proto.CLDBProto.Note;
import com.mapr.fs.cldb.proto.CLDBProto.NoteEntry;
import com.mapr.fs.cldb.proto.CLDBProto.NoteOperation;
import com.mapr.fs.cldb.proto.CLDBProto.NoteOperationEnum;
import com.mapr.fs.cldb.proto.CLDBProto.NoteStateInfo;
import com.mapr.fs.cldb.proto.CLDBProto.ReplicationPolicy;
import com.mapr.fs.cldb.proto.CLDBProto.SecureObjectType;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeChangeMirrorModeRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeChangeMirrorModeResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeCreateRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeCreateResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeInfo;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeInfoFields;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeListRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeListResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeLookupRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeLookupResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeMoveRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeMoveResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumePromoteRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumePromoteResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeProperties;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeRemoveRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeRemoveResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeRenameRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeRenameResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeReplicationInfo;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeShowMountsRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeShowMountsResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeTopology;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeUnMountRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeUnMountResponse;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeUpdateRequest;
import com.mapr.fs.cldb.proto.CLDBProto.VolumeUpdateResponse;
import com.mapr.fs.cldb.proto.CLDBProto.WormSettings;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.cli.proto.CLIProto.Filter;
import com.mapr.fs.cli.proto.CLIProto.Limiter;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Common.AlarmId;
import com.mapr.fs.proto.Common.AlarmMsg;
import com.mapr.fs.proto.Common.ContainerReplType;
import com.mapr.fs.proto.Common.FSAuditOperations;
import com.mapr.fs.proto.Common.FidMsg;
import com.mapr.fs.proto.Common.GuidMsg;
import com.mapr.fs.proto.Common.IPAddress;
import com.mapr.fs.proto.Common.MapRClusterDefaults;
import com.mapr.fs.proto.Common.PluggableAlarm;
// import com.mapr.security.UserInformation;
import com.mapr.fs.proto.Common.VolumeAceEntry;
import com.mapr.fs.proto.Common.VolumeAces;
import com.mapr.fs.proto.Common.VolumeActions;
import com.mapr.fs.proto.Common.VolumeType;
import com.mapr.fs.proto.Security.AccessControlList;
import com.mapr.fs.proto.Security.AclEntry;
import com.mapr.fs.proto.Security.CredentialsMsg;
import com.mapr.fs.proto.Security.ServerKeyType;
import com.mapr.security.JNISecurity;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;

public class VolumeCommands extends ListCommand implements CLIInterface {
  class VolumeAclHelper {
    Integer bitPos;
    Integer bitMask; // bit mask
    int fieldPos; // field position
    CLDBProto.VolumeInfoFields fieldNum; // field number
    
    VolumeAclHelper(int bitPos, CLDBProto.VolumeInfoFields fieldNum) {
      this.bitPos = new Integer(bitPos);
      this.fieldPos = fieldNum.getNumber();
      this.fieldNum = fieldNum;
    }
    
    Integer getBitPos() { return bitPos; }
    int getFieldPos() { return fieldPos; }
    CLDBProto.VolumeInfoFields getFieldNum() { return fieldNum; }
  }
	
  private static final Logger LOG = Logger.getLogger(VolumeCommands.class);
	
  // for 512 volumes VolumeListResp size is close to 450KB
	private static final int NUM_VOLUMES_PER_RPC = 512;
	// Sleep for some time after Volume Mount/unmount. Default 2 seconds
	private static final int VOLUME_OP_DELAY = 2;
	private static final int VOLUME_OP_ATTEMPTS = 60;

	public static final String RW_VOLUME_PARAM_OP_NODELAY = "nodelay";
  public static final String RW_VOLUME_PARAM_NAME = "name";
  public static final String RW_VOLUME_PARAM_NEW_NAME = "newname";
  public static final String RW_VOLUME_PARAM_MOUNTDIR = "path";
  public static final String RW_VOLUME_PARAM_MOUNT = "mount";
  public static final String RW_VOLUME_PARAM_CREATE_PARENT = "createparent";
  public static final String RW_VOLUME_PARAM_REPLICATION = "replication";
  public static final String RW_VOLUME_PARAM_MIN_REPLICATION = "minreplication";
  public static final String RW_VOLUME_PARAM_DCREPLTYPE = "replicationtype";
  public static final String RW_VOLUME_PARAM_NAMESPACE_REPLICATION = "nsreplication";
  public static final String RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION = "nsminreplication";
  public static final String RW_VOLUME_PARAM_READONLY = "readonly";
  public static final String RW_VOLUME_PARAM_MIRRORTHROTTLE = "mirrorthrottle";
  public static final String RW_VOLUME_PARAM_LOCALVOLUMEHOST = "localvolumehost";
  public static final String RW_VOLUME_PARAM_LOCALVOLUMEPORT = "localvolumeport";
  public static final String RW_VOLUME_PARAM_SHUFFLEVOLUME = "shufflevolume";
  public static final String RW_VOLUME_PARAM_FORCE = "force";
  public static final String RW_VOLUME_PARAM_AETYPE = "aetype";
  public static final String RW_VOLUME_PARAM_AE = "ae";
  public static final String RW_VOLUME_PARAM_QUOTA = "quota";
  public static final String RW_VOLUME_PARAM_ADVISORY_QUOTA = "advisoryquota";
  public static final String RW_VOLUME_PARAM_TOPOLOGY = "topology";  
  public static final String MIRROR_VOLUME = "type";
  public static final String MIRROR_VOLUME_SRC_VOLUMENAME = "source";
  public static final String RW_VOLUME_ROOT_DIR_PERM = "rootdirperms";
  public static final String RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC = "rereplicationtimeoutsec";
  public static final String RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC = "criticalrereplicationtimeoutsec";
  public static final String RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD = "maxinodesalarmthreshold";
  public static final String RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH = "dbrepllagsecalarmthresh";
  public static final String RW_FIX_CREATOR_ID = "fixcreatorid";

  public static final String PRESERVE_VOLUME  = "preserve";
  public static final String CHECKIN_TIME_MIN  = "commitTime";
  public static final String RETENTION_PERIOD_DAYS  = "retain";

  public static final String ADD_VOLUME_NOTE = "addNote";
  public static final String RESOLVE_VOLUME_NOTE = "resolveNote";
  public static final String NOTE_COMMENT = "comment";

  public static final String USERPERM_PARAM_NAME = "user";
  public static final String GROUPPERM_PARAM_NAME = "group";
  
  public static final String FILTER_PARAM_NAME   = "filter";
  public static final String COLUMNS_PARAM_NAME   = "columns";
  public static final String SORT_PARAM_NAME = "sort";
  public static final String SORT_DIRECTION_PARAM_NAME = "dir";
  public static final String OUTPUT_PARAM_NAME = "output";
  public static final String START_PARAM_NAME = "start";
  public static final String LIMIT_PARAM_NAME = "limit";
  public static final String ALARMEDVOLUMES_PARAM_NAME = "alarmedvolumes";
  public static final String RW_VOLUME_NODES = "nodes";

  public static final String VOLUME_LIMIT_SPREAD = "limitspread";

  // When set on a volume, lets the volume grant its properties to a newly created child volume, for inheritance
  public static final String ALLOW_GRANT = "allowgrant";
  // When used with volume create, specifies volume to inherit volume properties from
  public static final String INHERIT_SOURCE = "inherit";
  // When used with volume create, inhibits inheriting volume properties from parent volume
  public static final String ALLOW_INHERIT = "allowinherit";

  public static final String VOLUME_SCHEDULE = "schedule";
  public static final String VOLUME_MIRROR_SCHEDULE = "mirrorschedule";
  public static final String MULTI_ARG_SEP = ",";  

  public static final String REPL_TYPE_STAR = "low_latency";
  public static final String REPL_TYPE_CASCADE = "high_throughput";
  public static final String REPL_TYPE_UNKNOWN = "unknown";
  
  private final int VOLUME_ON_FILESERVER_TIMEOUT_SEC = 60; // Used to check for local volume HB
  
  private static int MAX_VOLUMEFIELDINFO = 0;
  public static final String VOL_READACE_PARAM = "readAce";
  public static final String VOL_WRITEACE_PARAM = "writeAce";

  // Audit related parameters
  public static final String AUDIT_VOLUME = "isauditvolume";
  public static final String VOLUME_AUDIT_ENABLED = "enabled";
  public static final String AUDIT_ENABLED = "auditenabled";
  public static final String AUDIT_COALESCE_INTERVAL = "coalesce"; 
  public static final String FSAUDIT_OPS = "dataauditops"; 
  
  public static final String volumeRemoveUsage = 
          "volume remove -name volumeName " +
          "[-cluster clustername -force <true|false> -filter <filters>]";
  
  public static final String volumeMoveUsage = 
          "volume move -name volumeName -topology topology " +
          "[-cluster clustername]";
  
  public static final String volumeRenameUsage = 
          "volume rename -name volumeNmae -newname newVolName " +
          "[-cluster clustername]";

  public static final String volumeUpgradeformatUsage =
          "volume upgradeformat -name volumeNames";
  
  public static final String aclUsageString = 
    "-" + USERPERM_PARAM_NAME + " space separated list of user:permissions,perimssions,.. to be set" +
    "-" + GROUPPERM_PARAM_NAME + " space separated list of group:permissions,permissions,.. to be set";

  public static final String dataAceUsageString =
      "-" + VOL_READACE_PARAM + "aceexpression" +
      "-" + VOL_WRITEACE_PARAM + "aceexpression";

  public static final Map<String, VolumeActions> volumeAceParameterMap =
      new ImmutableMap.Builder<String, VolumeActions>()
      .put(VOL_READACE_PARAM, VolumeActions.VOLUME_READ)
      .put(VOL_WRITEACE_PARAM, VolumeActions.VOLUME_WRITE)
      .build();

  public static final String volumeModifyUsage = 
          "volume modify -name volumeName " +
          "[-replication <repl> -minreplication <minrepl> -readonly <false|true> " +
          "-nsreplication <repl> -nsminreplication <minrepl> " +
          "-cluster clustername " +
          "-mirrorthrottle <false|true> " +
          aclUsageString +
          dataAceUsageString +
          "-source <sourcevol@sourcecluster>" +
          "-aetype <0(user)|1(group)> -ae <name>" +
          "-maxinodesalarmthreshold <val> " +
          "-dbrepllagsecalarmthresh <val>]" +
          "-quota <val> -advisoryquota <val> -maxinodesalarmthreshold <val>" +
          "-" + VOLUME_LIMIT_SPREAD + " <true|false> " +
          "-type type of volume: rw or mirror]" +
          "-" + ALLOW_GRANT + " <true|false> " +
          "[-" + AUDIT_ENABLED  + " <true|false> ]" +
          "[-" + AUDIT_COALESCE_INTERVAL + " <val in mins> ]" +
          "[-" + RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC + " <val in sec> ]" +
          "[-" + RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC + " <val in sec> ]";
    /*  ------------------------------- 
     *  Commented to hide WORM feature
     *  -------------------------------
     *
          "[-" + PRESERVE_VOLUME + " <true|false> ]" +
          "[-" + RETENTION_PERIOD_DAYS + " <int val (days)> ]" +
          "[-" + CHECKIN_TIME_MIN + " <int val (minutes)> ]" +
          "[-" + ADD_VOLUME_NOTE + " <note name> ]" +
          "[-" + RESOLVE_VOLUME_NOTE + " <note name> ]" +
          "[-" + NOTE_COMMENT + " <note state description> ]";
     *  -------------------------------
     */
  
  public static final String volumeListUsage = 
          "volume list [-filter <filters>]"  +
          "[-cluster clustername]";
  
  public static final String volumeInfoUsage =
          "volume info -volumename volName";
  public static final String volumeCreateUsage = 
          "volume create -name volumeName " + 
          "[-path mountDir " + 
          "-mount <true|false> -createparent <false|true> " +
          "-replication <repl> -minreplication <minrepl> -readonly <false|true> " +
          "-nsreplication <repl> -nsminreplication <minrepl> " +
          "-cluster clustername -localvolumehost fileserverhost " +
          "-mirrorthrottle <false|true> " +
          "-localvolumeport fileserverport " +
          aclUsageString +
          dataAceUsageString +
          "-aetype <0(user)|1(group)> -ae aename" +
          "-quota <quotaval> -advisoryquota <val> " +
          "-maxinodesalarmthreshold <val> " +
          "-dbrepllagsecalarmthresh <val> " +
          "-type type of volume: normal(0) or mirror(1) " +
          "-source <srcvolume@srccluster> " +
          "-" + VOLUME_LIMIT_SPREAD + " <true|false> " +
          "-rootdirperms 0777]" +
          "[-" + ALLOW_GRANT + " <true|false> ]" +
          "[-" + INHERIT_SOURCE + " <existing volume name> ]" +
          "[-" + ALLOW_INHERIT + " <true|false> ]" +
          "[-" + AUDIT_ENABLED  + " <true|false> ]" +
          "[-" + AUDIT_COALESCE_INTERVAL + " <val in mins> ]" ;
  
  public static final String volumeAuditUsage = 
          "volume audit -name volumeName " +
          "[-enabled <true|false> ] " +
          "[-coalesce in mins]" +
          "[-enabledataaudit <list of data audit operations>" +
          "[-disabledataaudit <list of data audit operations>";
  
  public static final String volumeUnMountUsage = 
          "volume unmount -name volumeName " +
          "[-cluster clustername]";
  
  public static final String volumeShowMountsUsage = 
	        "volume showmounts -name volumeName " +
	        "[-cluster clustername]";
  
  public static final String volumeMountUsage = 
          "volume mount -name volumeName -path mountDir " +
          "[-createparent <false|true> -cluster clustername]";
  
  public static final String volumeFixMntPathUsage =
          "volume fixmountpath -name volumeName " +
          "[-cluster clustername]";


  // NOTE(smarella): please retain the order in which fields are added here. Currently they are in the
  // same order as listed in cldb.proto/VolumeInfoFields
  public static Map<VolumeField, FieldInfo> fieldTable; // Gets set by pluggable alarms
  public static ImmutableMap.Builder<VolumeField, FieldInfo> fieldTableBuilder = new ImmutableMap.Builder<VolumeField, FieldInfo>()
    .put(new VolumeField(VolumeInfoFields.owner), new FieldInfo(VolumeInfoFields.owner.getNumber(),
        "on", "creator", String.class))
    .put(new VolumeField(VolumeInfoFields.dataContainerRepltype), new FieldInfo(VolumeInfoFields.dataContainerRepltype.getNumber(),
        "dcr", "replicationtype", String.class))
    .put(new VolumeField(VolumeInfoFields.numReplicas), new FieldInfo(VolumeInfoFields.numReplicas.getNumber(),
        "drf", "numreplicas", Integer.class))
    .put(new VolumeField(VolumeInfoFields.minReplicas), new FieldInfo(VolumeInfoFields.minReplicas.getNumber(),
        "mrf", "minreplicas", Integer.class))
    .put(new VolumeField(VolumeInfoFields.rackPath), new FieldInfo(VolumeInfoFields.rackPath.getNumber(),
        "rp", "rackpath", String.class))    
    .put(new VolumeField(VolumeInfoFields.localPath), new FieldInfo(VolumeInfoFields.localPath.getNumber(),
        "lp", "localpath", String.class))    
    .put(new VolumeField(VolumeInfoFields.readOnly), new FieldInfo(VolumeInfoFields.readOnly.getNumber(),
        "ro", "readonly", Integer.class))        
    .put(new VolumeField(VolumeInfoFields.mountDir), new FieldInfo(VolumeInfoFields.mountDir.getNumber(),
        "p", "mountdir", String.class))
    .put(new VolumeField(VolumeInfoFields.volumeName), new FieldInfo(VolumeInfoFields.volumeName.getNumber(),
        "n", "volumename", String.class))
    .put(new VolumeField(VolumeInfoFields.mounted), new FieldInfo(VolumeInfoFields.mounted.getNumber(),
        "mt", "mounted", Integer.class))
    .put(new VolumeField(VolumeInfoFields.quota), new FieldInfo(VolumeInfoFields.quota.getNumber(),
        "qta", "quota", Integer.class))
    .put(new VolumeField(VolumeInfoFields.used), new FieldInfo(VolumeInfoFields.used.getNumber(),
        "dsu", "used", Long.class))
    .put(new VolumeField(VolumeInfoFields.logicalUsed), new FieldInfo(VolumeInfoFields.logicalUsed.getNumber(),
        "dlu", "logicalUsed", Long.class))    
    .put(new VolumeField(VolumeInfoFields.advisoryquota), new FieldInfo(VolumeInfoFields.advisoryquota.getNumber(),
        "aqt", "advisoryquota", Integer.class))
    .put(new VolumeField(VolumeInfoFields.aeName), new FieldInfo(VolumeInfoFields.aeName.getNumber(),
        "aen", "aename", String.class))    
    .put(new VolumeField(VolumeInfoFields.aeType), new FieldInfo(VolumeInfoFields.aeType.getNumber(),
        "aet", "aetype", Integer.class)) 
    .put(new VolumeField(VolumeInfoFields.schedule), new FieldInfo(VolumeInfoFields.schedule.getNumber(),
        "sid", "scheduleid", Integer.class))
    .put(new VolumeField(VolumeInfoFields.mirrorSchedule), new FieldInfo(VolumeInfoFields.mirrorSchedule.getNumber(),
        "msid", "mirrorscheduleid", Integer.class))
    .put(new VolumeField(VolumeInfoFields.volumeType), new FieldInfo(VolumeInfoFields.volumeType.getNumber(),
        "t", "volumetype", Integer.class))
    .put(new VolumeField(VolumeInfoFields.mirrorType), new FieldInfo(VolumeInfoFields.mirrorType.getNumber(), 
        "mrt", "mirrortype", Integer.class))
    .put(new VolumeField(VolumeInfoFields.CreatorContainerId), new FieldInfo(VolumeInfoFields.CreatorContainerId.getNumber(), 
        "ccid", "creatorcontainerid", Integer.class))
    .put(new VolumeField(VolumeInfoFields.CreatorVolumeUuid), new FieldInfo(VolumeInfoFields.CreatorVolumeUuid.getNumber(), 
        "cvid", "creatorvolumeuuid", String.class))
    .put(new VolumeField(VolumeInfoFields.mirrorSrcVolume), new FieldInfo(VolumeInfoFields.mirrorSrcVolume.getNumber(),
        "src", "mirrorSrcVolume", String.class))
    .put(new VolumeField(VolumeInfoFields.mirrorStatus), new FieldInfo(VolumeInfoFields.mirrorStatus.getNumber(),
        "mst", "mirrorstatus", Integer.class)) 
    .put(new VolumeField(VolumeInfoFields.lastSuccessfulMirrorTime), new FieldInfo(VolumeInfoFields.lastSuccessfulMirrorTime.getNumber(),
        "lmt", "lastSuccessfulMirrorTime", Long.class)) 
    .put(new VolumeField(VolumeInfoFields.mirrorPercentComplete), new FieldInfo(VolumeInfoFields.mirrorPercentComplete.getNumber(),
        "mpc", "mirror-percent-complete", Integer.class)) 
    .put(new VolumeField(VolumeInfoFields.mirrorErrorCode), new FieldInfo(VolumeInfoFields.mirrorErrorCode.getNumber(),
        "mer", "mirror errorcode", Integer.class))
    .put(new VolumeField(VolumeInfoFields.snapshotcount), new FieldInfo(VolumeInfoFields.snapshotcount.getNumber(),
        "sc", "snapshotcount", Integer.class))
    .put(new VolumeField(VolumeInfoFields.volumeId), new FieldInfo(VolumeInfoFields.volumeId.getNumber(),
        "id", "volumeid", Integer.class))
    .put(new VolumeField(VolumeInfoFields.snapshotUsed), new FieldInfo(VolumeInfoFields.snapshotUsed.getNumber(),
        "ssu", "snapshotused", Long.class))    
    .put(new VolumeField(VolumeInfoFields.totalUsed), new FieldInfo(VolumeInfoFields.totalUsed.getNumber(),
        "tsu", "totalused", Long.class))    
    .put(new VolumeField(VolumeInfoFields.listReplicas), new FieldInfo(VolumeInfoFields.listReplicas.getNumber(),
        "arf", "actualreplication", Integer.class))
    .put(new VolumeField(VolumeInfoFields.scheduleName), new FieldInfo(VolumeInfoFields.scheduleName.getNumber(),
        "sn", "schedulename", String.class))        
    .put(new VolumeField(VolumeInfoFields.SnapshotFailureAlarm), new FieldInfo(VolumeInfoFields.SnapshotFailureAlarm.getNumber(),
        "sfa", "SnapshotFailureAlarm", Integer.class))     
    .put(new VolumeField(VolumeInfoFields.MirrorFailureAlarm), new FieldInfo(VolumeInfoFields.MirrorFailureAlarm.getNumber(),
        "mfa", "MirrorFailureAlarm", Integer.class))    
    .put(new VolumeField(VolumeInfoFields.DataUnderReplicatedAlarm), new FieldInfo(VolumeInfoFields.DataUnderReplicatedAlarm.getNumber(),
        "rfa", "DataUnderReplicatedAlarm", Integer.class))    
    .put(new VolumeField(VolumeInfoFields.DataUnavailableAlarm), new FieldInfo(VolumeInfoFields.DataUnavailableAlarm.getNumber(),
        "dua", "DataUnavailableAlarm", Integer.class))    
    .put(new VolumeField(VolumeInfoFields.AdvisoryQuotaExceededAlarm), new FieldInfo(VolumeInfoFields.AdvisoryQuotaExceededAlarm.getNumber(),
        "aqa", "AdvisoryQuotaExceededAlarm", Integer.class))    
    .put(new VolumeField(VolumeInfoFields.QuotaExceededAlarm), new FieldInfo(VolumeInfoFields.QuotaExceededAlarm.getNumber(),
        "qa", "QuotaExceededAlarm", Integer.class))
    .put(new VolumeField(VolumeInfoFields.NoNodesInTopologyAlarm), new FieldInfo(VolumeInfoFields.NoNodesInTopologyAlarm.getNumber(),
        "nna", "NoNodesInTopologyAlarm", Integer.class))       
    .put(new VolumeField(VolumeInfoFields.AlmostFullTopologyAlarm), new FieldInfo(VolumeInfoFields.AlmostFullTopologyAlarm.getNumber(),
        "afta", "AlmostFullTopologyAlarm", Integer.class))       
    .put(new VolumeField(VolumeInfoFields.FullTopologyAlarm), new FieldInfo(VolumeInfoFields.FullTopologyAlarm.getNumber(),
        "fta", "FullTopologyAlarm", Integer.class))       
    .put(new VolumeField(VolumeInfoFields.InodesExceededAlarm), new FieldInfo(VolumeInfoFields.InodesExceededAlarm.getNumber(),
        "ia", "InodesExceededAlarm", Integer.class))
    .put(new VolumeField(VolumeInfoFields.ContainersNonLocalAlarm), new FieldInfo(VolumeInfoFields.ContainersNonLocalAlarm.getNumber(),
        "cnla", "ContainersNonLocalAlarm", Integer.class))
    .put(new VolumeField(VolumeInfoFields.CannotMirrorAlarm), new FieldInfo(VolumeInfoFields.CannotMirrorAlarm.getNumber(),
        "cma", "CannotMirrorAlarm", Integer.class))
    .put(new VolumeField(VolumeInfoFields.acl), new FieldInfo(VolumeInfoFields.acl.getNumber(),
        "acl", "acl", OutputNode.class))
    .put(new VolumeField(VolumeInfoFields.mirrorSrcClusterName), new FieldInfo(VolumeInfoFields.mirrorSrcClusterName.getNumber(),
        "msc", "mirrorSrcCluster", String.class))
    .put(new VolumeField(VolumeInfoFields.mirrorSrcVolumeId), new FieldInfo(VolumeInfoFields.mirrorSrcVolumeId.getNumber(),
        "msi", "mirrorSrcVolumeId", Integer.class))
    .put(new VolumeField(VolumeInfoFields.mirrorDataGeneratorSrcVolumeName), new FieldInfo(VolumeInfoFields.mirrorDataGeneratorSrcVolumeName.getNumber(),
        "mds", "mirrorDataSrcVolume", String.class))
    .put(new VolumeField(VolumeInfoFields.mirrorDataGeneratorSrcVolumeId), new FieldInfo(VolumeInfoFields.mirrorDataGeneratorSrcVolumeId.getNumber(),
        "mdi", "mirrorDataSrcVolumeId", Integer.class))
    .put(new VolumeField(VolumeInfoFields.mirrorDataGeneratorSrcClusterName), new FieldInfo(VolumeInfoFields.mirrorDataGeneratorSrcClusterName.getNumber(),
        "mdc", "mirrorDataSrcCluster", String.class))
    .put(new VolumeField(VolumeInfoFields.mirrorId), new FieldInfo(VolumeInfoFields.mirrorId.getNumber(),
        "mid", "mirrorId", Integer.class))
    .put(new VolumeField(VolumeInfoFields.nextMirrorId), new FieldInfo(VolumeInfoFields.nextMirrorId.getNumber(),
        "nmid", "nextMirrorId", Integer.class))
    .put(new VolumeField(VolumeInfoFields.nameContainerSize), new FieldInfo(VolumeInfoFields.nameContainerSize.getNumber(),
        "ncsmb", "nameContainerSizeMB", Long.class))    
    .put(new VolumeField(VolumeInfoFields.nameContainerId), new FieldInfo(VolumeInfoFields.nameContainerId.getNumber(),
        "ncid", "nameContainerId", Integer.class))    
    .put(new VolumeField(VolumeInfoFields.needsGfsck), new FieldInfo(VolumeInfoFields.needsGfsck.getNumber(),
        "nfsck", "needsGfsck", Boolean.class))
    .put(new VolumeField(VolumeInfoFields.maxinodesalarmthreshold), new FieldInfo(VolumeInfoFields.maxinodesalarmthreshold.getNumber(),
        "miath", "maxinodesalarmthreshold", Boolean.class))
    .put(new VolumeField(VolumeInfoFields.dbReplLagSecAlarmThresh), new FieldInfo(VolumeInfoFields.dbReplLagSecAlarmThresh.getNumber(), 
         "dlsat", "dbrepllagsecalarmthresh", Integer.class))
    .put(new VolumeField(VolumeInfoFields.partlyOutOfTopology), new FieldInfo(VolumeInfoFields.partlyOutOfTopology.getNumber(),
        "poot", "partlyOutOfTopology", Integer.class))
    .put(new VolumeField(VolumeInfoFields.isAuditVolume), new
         FieldInfo(VolumeInfoFields.isAuditVolume.getNumber(),
        "av", "auditVolume", Integer.class))
    .put(new VolumeField(VolumeInfoFields.audited), new
         FieldInfo(VolumeInfoFields.audited.getNumber(),
        "ea", "audited", Integer.class))
    .put(new VolumeField(VolumeInfoFields.coalesceInterval), new
         FieldInfo(VolumeInfoFields.coalesceInterval.getNumber(),
        "ci", "coalesceInterval", Integer.class))
    .put(new VolumeField(VolumeInfoFields.fsAuditEnabledOperations), new
         FieldInfo(VolumeInfoFields.fsAuditEnabledOperations.getNumber(),
        "edao", "enableddataauditoperations", String.class))
    .put(new VolumeField(VolumeInfoFields.fsAuditDisabledOperations), new
         FieldInfo(VolumeInfoFields.fsAuditDisabledOperations.getNumber(),
        "ddao", "disableddataauditoperations", String.class))
    .put(new VolumeField(VolumeInfoFields.numContainers), new FieldInfo(VolumeInfoFields.numContainers.getNumber(),
        "nc", "numcontainers", Integer.class))
    .put(new VolumeField(VolumeInfoFields.mirrorThrottle),
         new FieldInfo(VolumeInfoFields.mirrorThrottle.getNumber(), 
        "dt", "mirrorthrottle", Integer.class))
    .put(new VolumeField(VolumeInfoFields.volumeAccessTime),
         new FieldInfo(VolumeInfoFields.volumeAccessTime.getNumber(), 
        "va", "accesstime", String.class))
    .put(new VolumeField(VolumeInfoFields.limitSpread),
         new FieldInfo(VolumeInfoFields.limitSpread.getNumber(),
                       "ls", "limitspread", Boolean.class))
    .put(new VolumeField(VolumeInfoFields.namespaceContainerNumReplicas),
         new FieldInfo(VolumeInfoFields.namespaceContainerNumReplicas.getNumber(),
                       "nsnr", "nsNumReplicas", Integer.class))
    .put(new VolumeField(VolumeInfoFields.namespaceContainerMinReplicas),
         new FieldInfo(VolumeInfoFields.namespaceContainerMinReplicas.getNumber(),
                       "nsmr", "nsMinReplicas", Integer.class))
    .put(new VolumeField(VolumeInfoFields.allowGrant),
         new FieldInfo(VolumeInfoFields.allowGrant.getNumber(),
                       "ag", "allowGrant", Boolean.class))
    .put(new VolumeField(VolumeInfoFields.reReplicationTimeOutSec),
         new FieldInfo(VolumeInfoFields.reReplicationTimeOutSec.getNumber(),
                       "rto", "reReplTimeOutSec", Integer.class))
    .put(new VolumeField(VolumeInfoFields.criticalReReplicationTimeOutSec),
         new FieldInfo(VolumeInfoFields.criticalReReplicationTimeOutSec.getNumber(),
                       "crto", "criticalReReplTimeOutSec", Integer.class))
    .put(new VolumeField(VolumeInfoFields.fixCreatorId),
         new FieldInfo(VolumeInfoFields.fixCreatorId.getNumber(),
                       "fcid", "fixCreatorId", Boolean.class))
    .put(new VolumeField(VolumeInfoFields.noteEntries),
         new FieldInfo(VolumeInfoFields.noteEntries.getNumber(),
                       "vn", "volumeNote", String.class))
    .put(new VolumeField(VolumeInfoFields.isWorm),
         new FieldInfo(VolumeInfoFields.isWorm.getNumber(),
                       "iw", "isWorm", String.class))
    .put(new VolumeField(VolumeInfoFields.wormConfig),
         new FieldInfo(VolumeInfoFields.wormConfig.getNumber(),
                       "worm", "wormSettings", String.class))
    .put(new VolumeField(VolumeInfoFields.commitMinutes),
         new FieldInfo(VolumeInfoFields.commitMinutes.getNumber(),
                       "cm", "commitMinutes", String.class))
    .put(new VolumeField(VolumeInfoFields.retentionDays),
         new FieldInfo(VolumeInfoFields.retentionDays.getNumber(),
                       "rd", "retentionDays", String.class))
    .put(new VolumeField(VolumeInfoFields.hasNotes),
         new FieldInfo(VolumeInfoFields.hasNotes.getNumber(),
                       "hn", "hasNotes", String.class))
    .put(new VolumeField(VolumeInfoFields.unresolvedNotes),
         new FieldInfo(VolumeInfoFields.unresolvedNotes.getNumber(),
                       "un", "unresolvedNotes", String.class))
    .put(new VolumeField(VolumeInfoFields.replTypeConversionInProgress),
    		new FieldInfo(VolumeInfoFields.replTypeConversionInProgress.getNumber(), 
    				"rtip", "ReplTypeConversionInProgress", Integer.class));

  static {
    VolumeInfoFields [] values = VolumeInfoFields.values();
    int max = 0;
    for ( VolumeInfoFields value : values ) {
      if ( value.getNumber() > max )
        max = value.getNumber();
    }
    MAX_VOLUMEFIELDINFO = max;
  }
  
  public static Map<String, BaseInputParameter> baseParams = 
    new ImmutableMap.Builder<String, BaseInputParameter>()
    .put(MapRCliUtil.CLUSTER_NAME_PARAM, new TextInputParameter(
        MapRCliUtil.CLUSTER_NAME_PARAM, "cluster_name",
         CLIBaseClass.NOT_REQUIRED, null))    
    .build();

  public static Map<String, BaseInputParameter> aclParams =
    new ImmutableMap.Builder<String, BaseInputParameter>()
      .put(VolumeCommands.USERPERM_PARAM_NAME, new TextInputParameter(
          VolumeCommands.USERPERM_PARAM_NAME,
          "space separated list of user:permissions,perimssions,.. to be set",
          CLIBaseClass.NOT_REQUIRED,
          null))
      .put(VolumeCommands.GROUPPERM_PARAM_NAME, new TextInputParameter(
          VolumeCommands.GROUPPERM_PARAM_NAME,
          "space separated list of user:permissions,perimssions,.. to be set",
          CLIBaseClass.NOT_REQUIRED,
          null))
      .build();

  public static final CLICommand volumeAuditCommand = new CLICommand( 
    "audit", 
    "", 
    VolumeCommands.class, ExecutionTypeEnum.NATIVE, 
      new ImmutableMap.Builder<String, BaseInputParameter>() 
        .putAll(VolumeCommands.baseParams)
        .put(VolumeCommands.RW_VOLUME_PARAM_NAME, 
          new TextInputParameter( 
              VolumeCommands.RW_VOLUME_PARAM_NAME, 
              "volumeName", CLIBaseClass.REQUIRED, null))
        .put(VolumeCommands.VOLUME_AUDIT_ENABLED,
           new BooleanInputParameter(
               VolumeCommands.VOLUME_AUDIT_ENABLED,
               "<true|false>", CLIBaseClass.NOT_REQUIRED, null)) 
        .put(VolumeCommands.AUDIT_COALESCE_INTERVAL,
           new IntegerInputParameter(
               VolumeCommands.AUDIT_COALESCE_INTERVAL,
               "interval in mins", CLIBaseClass.NOT_REQUIRED, null))
        .put(VolumeCommands.FSAUDIT_OPS,
           new TextInputParameter(
               VolumeCommands.FSAUDIT_OPS,
               "data audit operations", CLIBaseClass.NOT_REQUIRED, null))
        .build(), null)
    .setShortUsage(volumeAuditUsage);
  
  public static final CLICommand volumeUnMountCommand = new CLICommand( 
    "unmount", 
    "", 
    VolumeCommands.class, ExecutionTypeEnum.NATIVE, 
      new ImmutableMap.Builder<String, BaseInputParameter>() 
        .putAll(VolumeCommands.baseParams)
        .put(VolumeCommands.RW_VOLUME_PARAM_NAME, 
          new TextInputParameter( 
              VolumeCommands.RW_VOLUME_PARAM_NAME, 
              "name", CLIBaseClass.REQUIRED, null))
        .put(VolumeCommands.RW_VOLUME_PARAM_FORCE,
          new BooleanInputParameter(
              VolumeCommands.RW_VOLUME_PARAM_FORCE,
              "force", CLIBaseClass.NOT_REQUIRED, 0))
        .put(VolumeCommands.RW_VOLUME_PARAM_OP_NODELAY,
          new BooleanInputParameter(
              VolumeCommands.RW_VOLUME_PARAM_OP_NODELAY,
              "nodelay", CLIBaseClass.NOT_REQUIRED, 0).setInvisible(true))  
        .build(), null)
    .setShortUsage(volumeUnMountUsage);
  
  public static final CLICommand volumeShowMountsCommand = new CLICommand( 
		    "showmounts", 
		    "", 
		    VolumeCommands.class, ExecutionTypeEnum.NATIVE, 
		      new ImmutableMap.Builder<String, BaseInputParameter>() 
		        .putAll(VolumeCommands.baseParams)
		        .put(VolumeCommands.RW_VOLUME_PARAM_NAME, 
		          new TextInputParameter( 
		              VolumeCommands.RW_VOLUME_PARAM_NAME, 
		              "name", CLIBaseClass.REQUIRED, null))
		        .build(), null)   
		    .setShortUsage(volumeShowMountsUsage);
		  
  
  public static final CLICommand volumeMountCommand = new CLICommand( 
      "mount", 
      "", 
      VolumeCommands.class, ExecutionTypeEnum.NATIVE, 
        new ImmutableMap.Builder<String, BaseInputParameter>() 
          .putAll(VolumeCommands.baseParams) 
          .put(VolumeCommands.RW_VOLUME_PARAM_NAME, 
            new TextInputParameter( 
              VolumeCommands.RW_VOLUME_PARAM_NAME, 
              "name", CLIBaseClass.REQUIRED, null)) 
          .put(VolumeCommands.RW_VOLUME_PARAM_MOUNTDIR, 
            new TextInputParameter( 
              VolumeCommands.RW_VOLUME_PARAM_MOUNTDIR, 
              "path", CLIBaseClass.NOT_REQUIRED, null))
          .put(VolumeCommands.RW_VOLUME_PARAM_CREATE_PARENT,
            new BooleanInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_CREATE_PARENT,
                "createparent", CLIBaseClass.NOT_REQUIRED, false))
          .put(VolumeCommands.RW_VOLUME_PARAM_OP_NODELAY,
            new BooleanInputParameter(
              VolumeCommands.RW_VOLUME_PARAM_OP_NODELAY,
              "nodelay", CLIBaseClass.NOT_REQUIRED, 0).setInvisible(true))    
          .build(), null) 
       .setShortUsage(volumeMountUsage);
  
  public static final CLICommand volumeCreateCommand = new CLICommand(
      "create", 
      "",
      VolumeCommands.class, ExecutionTypeEnum.NATIVE,
      new ImmutableMap.Builder<String, BaseInputParameter>()
      .putAll(VolumeCommands.baseParams)
        .put(VolumeCommands.RW_VOLUME_PARAM_NAME,
            new TextInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_NAME,
                "volumeName", CLIBaseClass.REQUIRED, null))
        .put(VolumeCommands.RW_VOLUME_PARAM_MOUNTDIR,
            new TextInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_MOUNTDIR,
                "mountdir", CLIBaseClass.NOT_REQUIRED, null))
        .put(VolumeCommands.RW_VOLUME_PARAM_CREATE_PARENT,
            new BooleanInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_CREATE_PARENT,
                "createparent", CLIBaseClass.NOT_REQUIRED, false))
        .put(VolumeCommands.RW_VOLUME_PARAM_MOUNT,
            new BooleanInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_MOUNT,
                "mount", CLIBaseClass.NOT_REQUIRED, true))
        .put(VolumeCommands.RW_VOLUME_ROOT_DIR_PERM,
            new TextInputParameter(
                VolumeCommands.RW_VOLUME_ROOT_DIR_PERM,
                "rootdirperms", CLIBaseClass.NOT_REQUIRED, null))        
        .put(VolumeCommands.RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC,
            new IntegerInputParameter(
                VolumeCommands.RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC,
                "rereplicationtimeoutsec", CLIBaseClass.NOT_REQUIRED, null))
        .put(VolumeCommands.RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC,
            new IntegerInputParameter(
                VolumeCommands.RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC,
                "criticalrereplicationtimeoutsec", CLIBaseClass.NOT_REQUIRED, null))
        .put(VolumeCommands.RW_VOLUME_PARAM_LOCALVOLUMEHOST,
            new TextInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_LOCALVOLUMEHOST,
                "localvolumehost", CLIBaseClass.NOT_REQUIRED, null))
        .put(VolumeCommands.RW_VOLUME_PARAM_LOCALVOLUMEPORT,
            new IntegerInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_LOCALVOLUMEPORT,
                "localvolumeport", CLIBaseClass.NOT_REQUIRED, 5660))
        .put(VolumeCommands.RW_VOLUME_PARAM_SHUFFLEVOLUME,
            new BooleanInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_SHUFFLEVOLUME,
                "shufflevolume", CLIBaseClass.NOT_REQUIRED,
                0).setInvisible(true))  
         .put(VolumeCommands.RW_VOLUME_PARAM_REPLICATION,
            new IntegerInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_REPLICATION,
                "replication", CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.RW_VOLUME_PARAM_MIN_REPLICATION,
            new IntegerInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_MIN_REPLICATION,
                "minreplication", CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_REPLICATION,
            new IntegerInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_REPLICATION,
                "nsreplication", CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION,
            new IntegerInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION,
                "nsminreplication", CLIBaseClass.NOT_REQUIRED, null))
        .put(VolumeCommands.RW_VOLUME_PARAM_DCREPLTYPE,
            new TextInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_DCREPLTYPE,
                "replicationtype: low_latency or high_throughput. default: high_throughput",
                CLIBaseClass.NOT_REQUIRED, null))
         .putAll(aclParams)
         .put(VolumeCommands.RW_VOLUME_PARAM_AETYPE,
            new BooleanInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_AETYPE,
                "aetype", CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.RW_VOLUME_PARAM_AE,
            new TextInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_AE,
                "ae", CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.RW_VOLUME_PARAM_QUOTA,
            new TextInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_QUOTA,
                "quota", CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.RW_VOLUME_PARAM_ADVISORY_QUOTA,
            new TextInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_ADVISORY_QUOTA,
                "advisoryquota", CLIBaseClass.NOT_REQUIRED, null))       
         .put(VolumeCommands.RW_VOLUME_PARAM_TOPOLOGY,
            new TextInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_TOPOLOGY,
                "topology", CLIBaseClass.NOT_REQUIRED, null))      
         .put(VolumeCommands.RW_VOLUME_PARAM_READONLY,
            new BooleanInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_READONLY,
                "readonly", CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.RW_VOLUME_PARAM_MIRRORTHROTTLE,
            new BooleanInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_MIRRORTHROTTLE,
                "mirrorthrottle", CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.MIRROR_VOLUME,
            new TextInputParameter(
                VolumeCommands.MIRROR_VOLUME,
                "type of volume: rw or mirror", CLIBaseClass.NOT_REQUIRED, null))         
         .put(VolumeCommands.MIRROR_VOLUME_SRC_VOLUMENAME,
            new TextInputParameter(
                VolumeCommands.MIRROR_VOLUME_SRC_VOLUMENAME,
                "source", CLIBaseClass.NOT_REQUIRED, null))  
         .put(VolumeCommands.VOLUME_SCHEDULE,
            new IntegerInputParameter(
                VolumeCommands.VOLUME_SCHEDULE,
                "schedule ID", CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.VOLUME_MIRROR_SCHEDULE,
            new IntegerInputParameter(
                VolumeCommands.VOLUME_MIRROR_SCHEDULE,
                "mirror schedule ID", CLIBaseClass.NOT_REQUIRED, null))
         .put(VOLUME_LIMIT_SPREAD,
            new BooleanInputParameter(
                VOLUME_LIMIT_SPREAD, "limitspread",
                CLIBaseClass.NOT_REQUIRED, null).setInvisible(true))
         .put(VolumeCommands.RW_VOLUME_PARAM_OP_NODELAY,
            new BooleanInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_OP_NODELAY,
                "nodelay", CLIBaseClass.NOT_REQUIRED, 0).setInvisible(true))   
         .put(VolumeCommands.RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD,
            new LongInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD,
                "maxinodesalarmthreshold", CLIBaseClass.NOT_REQUIRED, null))    
         .put(VolumeCommands.RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH,
            new IntegerInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH,
                VolumeCommands.RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH,
                CLIBaseClass.NOT_REQUIRED, null))   
         .put(VolumeCommands.AUDIT_ENABLED,
            new BooleanInputParameter(
                VolumeCommands.AUDIT_ENABLED,
                "<true|false>", CLIBaseClass.NOT_REQUIRED,
                null)) 
         .put(VolumeCommands.AUDIT_COALESCE_INTERVAL,
            new IntegerInputParameter(
                VolumeCommands.AUDIT_COALESCE_INTERVAL,
                "interval in mins", CLIBaseClass.NOT_REQUIRED,
                null))
         .put(VolumeCommands.AUDIT_VOLUME,
            new BooleanInputParameter(
                VolumeCommands.AUDIT_VOLUME,
                "isauditvolume", CLIBaseClass.NOT_REQUIRED,
                null).setInvisible(true))
         .put(VolumeCommands.FSAUDIT_OPS,
            new TextInputParameter(
                VolumeCommands.FSAUDIT_OPS,
                "data audit operations", CLIBaseClass.NOT_REQUIRED,
                null))
         .put(VolumeCommands.ALLOW_GRANT,
            new BooleanInputParameter(
                VolumeCommands.ALLOW_GRANT, ALLOW_GRANT,
                CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.INHERIT_SOURCE,
            new TextInputParameter(
                VolumeCommands.INHERIT_SOURCE,
                "volume to copy properties from: defaults to parent volume", CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.ALLOW_INHERIT,
            new BooleanInputParameter(
                VolumeCommands.ALLOW_INHERIT, "allowinherit",
                CLIBaseClass.NOT_REQUIRED, null))
         .put(VOL_READACE_PARAM,
             new TextInputParameter(VOL_READACE_PARAM, "<Acess Control Expression>",
                 CLIBaseClass.NOT_REQUIRED, null))
         .put(VOL_WRITEACE_PARAM,
             new TextInputParameter(VOL_WRITEACE_PARAM, "<Acess Control Expression>",
                 CLIBaseClass.NOT_REQUIRED, null))
         .build(), null)
  .setShortUsage(volumeCreateUsage);
  
  
  public static final CLICommand[] volumeCommands = 
    new CLICommand[] {
      new CLICommand(
          "remove", 
          "",
          VolumeCommands.class, ExecutionTypeEnum.NATIVE,
          new ImmutableMap.Builder<String, BaseInputParameter>()
            .putAll(VolumeCommands.baseParams) 
            .put(VolumeCommands.RW_VOLUME_PARAM_NAME,
                new TextInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_NAME,
                    "volumeName", CLIBaseClass.NOT_REQUIRED, null))
            .put(VolumeCommands.RW_VOLUME_PARAM_FORCE,
                new BooleanInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_FORCE,
                    "force", CLIBaseClass.NOT_REQUIRED, 0))
            .put(VolumeCommands.RW_VOLUME_PARAM_OP_NODELAY,
                new BooleanInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_OP_NODELAY,
                    "nodelay", CLIBaseClass.NOT_REQUIRED, 0).setInvisible(true))
            .put(VolumeCommands.FILTER_PARAM_NAME,
                 new TextInputParameter(VolumeCommands.FILTER_PARAM_NAME,
                     "remove volumes that match the filter",
                     CLIBaseClass.NOT_REQUIRED,
                 "none"))
            .build(), null)
      .setShortUsage(volumeRemoveUsage),
      
      new CLICommand(
          "move", 
          "",
          VolumeCommands.class, ExecutionTypeEnum.NATIVE,
          new ImmutableMap.Builder<String, BaseInputParameter>()
          .putAll(VolumeCommands.baseParams) 
            .put(VolumeCommands.RW_VOLUME_PARAM_NAME,
                new TextInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_NAME,
                    "volumeName", CLIBaseClass.REQUIRED, null))
            .put(VolumeCommands.RW_VOLUME_PARAM_TOPOLOGY,
                new TextInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_TOPOLOGY,
                    "topology", CLIBaseClass.REQUIRED, null))
            .build(), null)
      .setShortUsage(volumeMoveUsage),
      
      new CLICommand(
          "rename", 
          "",
          VolumeCommands.class, ExecutionTypeEnum.NATIVE,
          new ImmutableMap.Builder<String, BaseInputParameter>()
          .putAll(VolumeCommands.baseParams) 
            .put(VolumeCommands.RW_VOLUME_PARAM_NAME,
                new TextInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_NAME,
                    "volumeName", CLIBaseClass.REQUIRED, null))
            .put(VolumeCommands.RW_VOLUME_PARAM_NEW_NAME,
                new TextInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_NEW_NAME,
                    "newVolumeName", CLIBaseClass.REQUIRED, null))
            .put(VolumeCommands.RW_VOLUME_PARAM_OP_NODELAY,
                new BooleanInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_OP_NODELAY,
                    "nodelay", CLIBaseClass.NOT_REQUIRED, 0).setInvisible(true))        
            .build(), null)
      .setShortUsage(volumeRenameUsage),

       new CLICommand(
          "upgradeformat",
          "",
          VolumeCommands.class, ExecutionTypeEnum.NATIVE,
          new ImmutableMap.Builder<String, BaseInputParameter>()
          .putAll(VolumeCommands.baseParams)
            .put(VolumeCommands.RW_VOLUME_PARAM_NAME,
                new TextInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_NAME,
                    "volumeNames", CLIBaseClass.REQUIRED, null))
          .build(), null)
      .setShortUsage(volumeUpgradeformatUsage),      

      new CLICommand(
          "modify", 
          "",
          VolumeCommands.class, ExecutionTypeEnum.NATIVE,
          new ImmutableMap.Builder<String, BaseInputParameter>()
          .putAll(VolumeCommands.baseParams) 
            .put(VolumeCommands.RW_VOLUME_PARAM_NAME,
                new TextInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_NAME,
                    "volumeName", CLIBaseClass.REQUIRED, null))
            .put(VolumeCommands.MIRROR_VOLUME_SRC_VOLUMENAME,
                new TextInputParameter(
                    VolumeCommands.MIRROR_VOLUME_SRC_VOLUMENAME,
                    "source", CLIBaseClass.NOT_REQUIRED, null))
            .put(VolumeCommands.RW_VOLUME_PARAM_REPLICATION,
                new IntegerInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_REPLICATION,
                    "replication", CLIBaseClass.NOT_REQUIRED, null))
            .put(VolumeCommands.RW_VOLUME_PARAM_MIN_REPLICATION,
                new IntegerInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_MIN_REPLICATION,
                    "minreplication", CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_REPLICATION,
            new IntegerInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_REPLICATION,
                "nsreplication", CLIBaseClass.NOT_REQUIRED, null))
         .put(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION,
            new IntegerInputParameter(
                VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION,
                "nsminreplication", CLIBaseClass.NOT_REQUIRED, null))
            .putAll(aclParams)
            .put(VolumeCommands.RW_VOLUME_PARAM_AETYPE,
                new BooleanInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_AETYPE,
                    "aetype", CLIBaseClass.NOT_REQUIRED, null))
            .put(VolumeCommands.RW_VOLUME_PARAM_AE,
                new TextInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_AE,
                    "ae", CLIBaseClass.NOT_REQUIRED, null))        
            .put(VolumeCommands.RW_VOLUME_PARAM_QUOTA,
                new TextInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_QUOTA,
                    "quota", CLIBaseClass.NOT_REQUIRED, null))
            .put(VolumeCommands.RW_VOLUME_PARAM_ADVISORY_QUOTA,
                new TextInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_ADVISORY_QUOTA,
                    "advisoryquota", CLIBaseClass.NOT_REQUIRED, null))        
            .put(VolumeCommands.RW_VOLUME_PARAM_READONLY,
                new BooleanInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_READONLY,
                    "readonly", CLIBaseClass.NOT_REQUIRED, null))         
            .put(VolumeCommands.RW_VOLUME_PARAM_MIRRORTHROTTLE,
                new BooleanInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_MIRRORTHROTTLE,
                    "mirrorthrottle", CLIBaseClass.NOT_REQUIRED, null))
            .put(VolumeCommands.VOLUME_SCHEDULE,
            	  new IntegerInputParameter(
            		    VolumeCommands.VOLUME_SCHEDULE,
                    "schedule ID", 
                    CLIBaseClass.NOT_REQUIRED, null)) 
            .put(VolumeCommands.VOLUME_MIRROR_SCHEDULE,
            	  new IntegerInputParameter(
            		    VolumeCommands.VOLUME_MIRROR_SCHEDULE,
                    "mirror schedule ID", 
                    CLIBaseClass.NOT_REQUIRED, null)) 
           .put(VolumeCommands.RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD,
              new LongInputParameter(
                  VolumeCommands.RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD,
                  "maxinodesalarmthreshold", CLIBaseClass.NOT_REQUIRED, null))
           .put(VolumeCommands.RW_VOLUME_PARAM_DCREPLTYPE,
        		   new TextInputParameter(
        				   VolumeCommands.RW_VOLUME_PARAM_DCREPLTYPE,
        				   "<" + REPL_TYPE_STAR + " | " + REPL_TYPE_CASCADE + ">",
        				   CLIBaseClass.NOT_REQUIRED, null).setInvisible(true))
           .put(VolumeCommands.RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH,
              new IntegerInputParameter(
                  VolumeCommands.RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH,
                  VolumeCommands.RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH,
                  CLIBaseClass.NOT_REQUIRED, null))   
           .put(VolumeCommands.MIRROR_VOLUME,
              new TextInputParameter(
                  VolumeCommands.MIRROR_VOLUME,
                  "type of volume: rw or mirror", CLIBaseClass.NOT_REQUIRED, null))         
           .put(VOLUME_LIMIT_SPREAD,
                new BooleanInputParameter(
                    VOLUME_LIMIT_SPREAD, "limitspread",
                    CLIBaseClass.NOT_REQUIRED, null).setInvisible(true))
           .put(VolumeCommands.AUDIT_ENABLED,
              new BooleanInputParameter(
                  VolumeCommands.AUDIT_ENABLED,
                  "<true|false>", CLIBaseClass.NOT_REQUIRED,
                  null)) 
           .put(VolumeCommands.AUDIT_COALESCE_INTERVAL,
              new IntegerInputParameter(
                  VolumeCommands.AUDIT_COALESCE_INTERVAL,
                  "interval in mins", CLIBaseClass.NOT_REQUIRED,
                  null))
           .put(VolumeCommands.FSAUDIT_OPS,
              new TextInputParameter(
                  VolumeCommands.FSAUDIT_OPS,
                  "data audit operations", CLIBaseClass.NOT_REQUIRED, null))
           .put(ALLOW_GRANT,
                new BooleanInputParameter(
                    VolumeCommands.ALLOW_GRANT,
                    "let child volume inherit volume properties <true|false>",
                    CLIBaseClass.NOT_REQUIRED, null))
           .put(VolumeCommands.RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC,
               new IntegerInputParameter(
                   VolumeCommands.RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC,
                   "rereplicationtimeoutsec", CLIBaseClass.NOT_REQUIRED, null))
            .put(VolumeCommands.RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC,
                new IntegerInputParameter(
                    VolumeCommands.RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC,
                    "criticalrereplicationtimeoutsec", CLIBaseClass.NOT_REQUIRED, null))
           .put(VolumeCommands.RW_FIX_CREATOR_ID,
               new BooleanInputParameter(
                   VolumeCommands.RW_FIX_CREATOR_ID, "fixcreatorid",
                   CLIBaseClass.NOT_REQUIRED, null)
               .setInvisible(true))
           .put(VOL_READACE_PARAM,
               new TextInputParameter(VOL_READACE_PARAM, "<Acess Control Expression>",
                   CLIBaseClass.NOT_REQUIRED, null))
           .put(VOL_WRITEACE_PARAM,
               new TextInputParameter(VOL_WRITEACE_PARAM, "<Acess Control Expression>",
                   CLIBaseClass.NOT_REQUIRED, null))
           .build(), null)
      .setShortUsage(volumeModifyUsage),
      
      new CLICommand(
          "info", 
          "",
          VolumeCommands.class, ExecutionTypeEnum.NATIVE,
          new ImmutableMap.Builder<String, BaseInputParameter>()
          .putAll(VolumeCommands.baseParams) 
            .put(VolumeCommands.OUTPUT_PARAM_NAME,
                 new TextInputParameter(VolumeCommands.OUTPUT_PARAM_NAME,
                     "verbose",
                     CLIBaseClass.NOT_REQUIRED,
                 "verbose"))
            .put(VolumeCommands.RW_VOLUME_PARAM_MOUNTDIR,
                  new TextInputParameter(
                      VolumeCommands.RW_VOLUME_PARAM_MOUNTDIR,
                      "mountdir", CLIBaseClass.NOT_REQUIRED, null))     
            .put(VolumeCommands.RW_VOLUME_PARAM_NAME,
                new TextInputParameter(
                    VolumeCommands.RW_VOLUME_PARAM_NAME,
                    "volumeName", CLIBaseClass.NOT_REQUIRED, null))       
            .put(VolumeCommands.COLUMNS_PARAM_NAME,
                 new TextInputParameter(VolumeCommands.COLUMNS_PARAM_NAME,
                     "comma separated list of column names",
                     CLIBaseClass.NOT_REQUIRED,
                 "all"))
            .build(), null)
      .setShortUsage(volumeInfoUsage),
      
      new CLICommand(
          "list", 
          "",
          VolumeCommands.class, ExecutionTypeEnum.NATIVE,
          new ImmutableMap.Builder<String, BaseInputParameter>()
          .putAll(VolumeCommands.baseParams) 
            .put(VolumeCommands.SORT_PARAM_NAME,
                 new TextInputParameter(VolumeCommands.SORT_PARAM_NAME,
                     "none",
                     CLIBaseClass.NOT_REQUIRED,
                     "volumename").setInvisible(true))
            .put(VolumeCommands.SORT_DIRECTION_PARAM_NAME,
                 new TextInputParameter(VolumeCommands.SORT_DIRECTION_PARAM_NAME,
                     "none",
                     CLIBaseClass.NOT_REQUIRED,
                     "ASC").setInvisible(true))
            .put(VolumeCommands.OUTPUT_PARAM_NAME,
                 new TextInputParameter(VolumeCommands.OUTPUT_PARAM_NAME,
                     "verbose",
                     CLIBaseClass.NOT_REQUIRED,
                     "verbose"))
            .put(VolumeCommands.START_PARAM_NAME,
                 new IntegerInputParameter(VolumeCommands.START_PARAM_NAME,
                     "start",
                     CLIBaseClass.NOT_REQUIRED,
                     0))
            .put(VolumeCommands.LIMIT_PARAM_NAME,
                 new IntegerInputParameter(VolumeCommands.LIMIT_PARAM_NAME,
                     "limit",
                     CLIBaseClass.NOT_REQUIRED,
                     Integer.MAX_VALUE))
            .put(VolumeCommands.FILTER_PARAM_NAME,
                 new TextInputParameter(VolumeCommands.FILTER_PARAM_NAME,
                     "none",
                     CLIBaseClass.NOT_REQUIRED,
                 "none"))
            .put(VolumeCommands.RW_VOLUME_NODES,
                 new TextInputParameter(VolumeCommands.RW_VOLUME_NODES,
                     "nodes",
                     CLIBaseClass.NOT_REQUIRED,
                 null))
            .put(VolumeCommands.COLUMNS_PARAM_NAME,
                 new TextInputParameter(VolumeCommands.COLUMNS_PARAM_NAME,
                     "comma separated list of column names",
                     CLIBaseClass.NOT_REQUIRED,
                 "all"))
            .put(VolumeCommands.ALARMEDVOLUMES_PARAM_NAME,
                 new BooleanInputParameter(VolumeCommands.ALARMEDVOLUMES_PARAM_NAME,
                     "alarmsonly",
                     CLIBaseClass.NOT_REQUIRED,
                     0))    
            .build(), null)
      .setShortUsage(volumeListUsage),

      new CLICommand(
          "fixmountpath",
          "",
          VolumeCommands.class, ExecutionTypeEnum.NATIVE,
          new ImmutableMap.Builder<String, BaseInputParameter>()
          .putAll(VolumeCommands.baseParams)
            .put(VolumeCommands.RW_VOLUME_PARAM_NAME,
                    new TextInputParameter(
                            VolumeCommands.RW_VOLUME_PARAM_NAME,
                            "volumeName", CLIBaseClass.REQUIRED, null))
            .build(), null)
      .setShortUsage(volumeFixMntPathUsage),

      VolumeLinkCommands.VolumeLinkCommands,
      SnapshotCommands.snapshotCommands,
      VolumeMirrorCommands.mirrorCommands,
      VolumeDumpFileCommands.dumpCommands,
      VolumeContainerCommands.containerCommands
    };
    
  UnixUserGroupHelper uInfo;
  int maxVolumeReplicationFactor;
  private List<VolumeInfo> listedVolumes = Lists.newArrayList();

  private AuthManager authManager;
  
  void init() throws CLIProcessingException {
    uInfo = new UnixUserGroupHelper();
    
    try {
      int port = Rpc.initialize(0, 0, null); // Client
      if (port < 0)
        throw new IOException("Error in RPC init");
    } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message::Send request Exception
        * Function:VolumeCommands.init()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
       LOG.error("Exception while initializing RPC " + e);
    }
    // First get all pluggable alarms and add all them to the immutable map
    fieldTable = PluggableAlarmUtil.appendVolumeMap(getUserCredentials(), fieldTableBuilder);
    MAX_VOLUMEFIELDINFO = PluggableAlarmUtil.getMaxNumNodes(getUserCredentials(), MAX_VOLUMEFIELDINFO);


    maxVolumeReplicationFactor =  MapRClusterDefaults
        .getDefaultInstance().getMaxVolumeReplication();
  }
  
  // This function checks if a newly mounted volume is accessible at its mount path
  // Otherwise, it sleeps for VOLUME_OP_DELAY seconds and tries upto VOLUME_OP_ATTEMPTS

  private boolean sleepAndCheckMountedDir (MapRFileSystem fs, String cluster,
                                           String dir) {
    String fullDir = dir;
    
    /* If we have a cluster and the remote path is not a fully
     * qualified pathname, create a fully qualified path name
     */
    if (cluster != null && !dir.startsWith("maprfs://"))
      fullDir = "maprfs://" + cluster + ":" + dir;
    
    Path fullPath = new Path(fullDir);
    
    for (int nAttempts = 0; nAttempts < VOLUME_OP_ATTEMPTS; nAttempts++) {
      // Check the status of the mountedDir
      try {
        FileStatus fStatus = fs.getFileStatus(fullPath);
        if (fStatus != null)
          return true;
      } catch (IOException e) {
      }
      // Sleep for VOLUME_OP_DELAY seconds
      try {
        Thread.sleep(VOLUME_OP_DELAY * 1000);
      } catch (InterruptedException e) {
      }
    }
    return false;
  }

  private List<String> getUserGroupsNames(List<String> perms) {
    List<String> permissions = new ArrayList<String>();
    List<String> userGroups = new ArrayList<String>();
    for (String perm : perms) {
      // split the permission string based on space as
      // UI sends it as a single space separated string.
      // For CLI, this code path ends up copying "perms" list
      // into "permissions" list.
      Collections.addAll(permissions, perm.split(" "));
    }

    for (String perm: permissions) {
      List<String> userPerm = Arrays.asList 
        (perm.split(AclCommands.ALLOW_MASK_SEP));
      userGroups.add(userPerm.get(0));
    }
    return userGroups;
  }
  
  private ContainerReplType getContainerReplType(String type) {
    if (type.equalsIgnoreCase(REPL_TYPE_STAR))
      return ContainerReplType.STAR;
    else if (type.equalsIgnoreCase(REPL_TYPE_CASCADE))
      return ContainerReplType.CASCADE;
    else
      return ContainerReplType.INVALID;
  }

  private String getContainerReplTypeString(ContainerReplType type) {
    if (type == ContainerReplType.STAR)
      return REPL_TYPE_STAR;
    else if (type == ContainerReplType.CASCADE)
      return REPL_TYPE_CASCADE;
    else
      return REPL_TYPE_UNKNOWN;
  }

  public VolumeCommands(ProcessedInput input, CLICommand cliCommand) 
      throws CLIProcessingException {
    super(input, cliCommand);
    authManager = AuthManager.getInstance();
  }  

  public CommandOutput executeRealCommand() throws CLIProcessingException {
    init();
    
    if (cliCommand.getCommandName().equalsIgnoreCase("remove")) {
      try {
        if (!getParamTextValue(FILTER_PARAM_NAME, 0).equals("none")) {
          return removeFilteredVolumes();
        }
        return volumeRemove();
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Send request Exception
        * Function:VolumeCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        throw new CLIProcessingException("Send request Exception", e);
      }
    }else if (cliCommand.getCommandName().equalsIgnoreCase("move")) {
      try {
        return volumeMove();
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Send request Exception
        * Function:VolumeCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        throw new CLIProcessingException("Send request Exception", e);
      } 
    } else if (cliCommand.getCommandName().equalsIgnoreCase("audit")) {
      try {
        return volumeModify();
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Send request Exception
        * Function:VolumeCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        throw new CLIProcessingException("Send request Exception", e);
      } 
    } else if (cliCommand.getCommandName().equalsIgnoreCase("rename")) {
      try {
        return volumeRename();
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Send request Exception
        * Function:VolumeCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        throw new CLIProcessingException("Send request Exception", e);
      } 
    } else if (cliCommand.getCommandName().equalsIgnoreCase("upgradeformat")) {
      try {
        return volumeUpgradeformat();
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Send request Exception
        * Function:VolumeCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        throw new CLIProcessingException("Send request Exception", e);
      } 
    } else if (cliCommand.getCommandName().equalsIgnoreCase("list")) {
      try {
        CommandOutput output = new CommandOutput();
        OutputHierarchy out = new OutputHierarchy();
        output.setOutput(out);
        if (!super.validateInput()) {
          return output;
        }
        if (isParamPresent(ALARMEDVOLUMES_PARAM_NAME) && 
						getAlarmedVolumesParamValue() &&
            isParamPresent(RW_VOLUME_NODES) && 
						!getParamTextValue(RW_VOLUME_NODES, 0).isEmpty()) {
          /**
          * <MAPR_ERROR>
          * Message:Cannot use both -alarmedvolumes and -nodes parameters.
          * Function:VolumeCommands.executeRealCommand()
          * Meaning:You cannot specify both the {{\-alarmedvolumes}} and {{\-nodes}} parameters.
          * Resolution:Check the command syntax and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EINVAL,
              "Cannot use both -alarmedvolumes and -nodes parameters."));
          return output;
        }
        list(out);
        return output;
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Send request Exception
        * Function:VolumeCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        throw new CLIProcessingException("Send request Exception", e);
      } 
    } else if (cliCommand.getCommandName().equalsIgnoreCase("info")) {
      try {
        return volumeInfo();
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Send request Exception
        * Function:VolumeCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        throw new CLIProcessingException("Send request Exception", e);
      } 
    } else if (cliCommand.getCommandName().equalsIgnoreCase("modify")) {
      try {
        return volumeModify();
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Send request Exception
        * Function:VolumeCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        throw new CLIProcessingException("Send request Exception", e);
      } 
    } else if (cliCommand.getCommandName().equalsIgnoreCase("create")) {
      try {
        return volumeCreate();
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Send request Exception
        * Function:VolumeCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        throw new CLIProcessingException("Send request Exception", e);
      }
    } else if (cliCommand.getCommandName().equalsIgnoreCase("unmount")) {
      try {
        return volumeUnMount();
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Send request Exception
        * Function:VolumeCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        throw new CLIProcessingException("Send request Exception", e);
      }
    } else if (cliCommand.getCommandName().equalsIgnoreCase("mount")) {
      try {
        return volumeMount();
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Send request Exception
        * Function:VolumeCommands.executeRealCommand()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        throw new CLIProcessingException("Send request Exception", e);
      }  
    } else if (cliCommand.getCommandName().equalsIgnoreCase("showmounts")) {
    	try {
    	  return volumeShowMounts();
    	} catch (Exception e) {
    	  /**
    	   * <MAPR_ERROR>
    	   * Message:Send request Exception
    	   * Function:VolumeCommands.executeRealCommand()
    	   * Meaning:An error occurred.
    	   * Resolution:Contact technical support.
    	   * </MAPR_ERROR>
    	   */
    	  throw new CLIProcessingException("Send request Exception", e);
    	}  
    } else if (cliCommand.getCommandName().equalsIgnoreCase("fixmountpath")) {
      try {
        return volumeFixMountPath();
      } catch (Exception e) {
        throw new CLIProcessingException("Send request Exception", e);
      }
    }
    /**
    * <MAPR_ERROR>
    * Message:Volume command failed
    * Function:VolumeCommands.executeRealCommand()
    * Meaning:An error occurred.
    * Resolution:Contact technical support.
    * </MAPR_ERROR>
    */
    return new TextCommandOutput(("Volume command failed").getBytes());
  }

  @Override
  public boolean validateInput() throws IllegalArgumentException {
    if (cliCommand.getCommandName().equals("remove")) {
      return input.getAllParameters().size() > 1 && super.validateInput();
    }
    return super.validateInput();
  }

  CommandOutput volumeMount() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);

    String rwVolumeName = getRwVolumeName();
    
    List<String> volumeNames = new ArrayList<String>();
    List<String> mountedVolumePaths = new ArrayList<String>();

    if (!rwVolumeName.contains(MULTI_ARG_SEP)) {
      volumeNames.add(rwVolumeName);
    } else if (rwVolumeName.contains(MULTI_ARG_SEP)) {
      volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
    }
        
    MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
    String cluster = null;
    if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
      cluster = getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM, 0);
    }
    
    for (String volName : volumeNames) {
      if (volName.equals(
          MapRClusterDefaults.getDefaultInstance().getClusterRootName())) {
        /**
        * <MAPR_ERROR>
        * Message:Cannot mount root volume <volume name> <error>
        * Function:VolumeCommands.volumeMount()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EINVAL, "Cannot mount root volume " +
                      volName + " " + Errno.toString(Errno.EINVAL)));
        continue;
      }      
      
      if (LOG.isDebugEnabled())
        LOG.debug("Trying to mount volume " + volName);
      String rwVolumeMountDir = null;
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MOUNTDIR)) {
        rwVolumeMountDir = getParamTextValue(VolumeCommands
                                      .RW_VOLUME_PARAM_MOUNTDIR, 0)
                           .replaceAll("\\/+$", "");
      }
      VolumeProperties volProps = this.volumePropetiesLookup(volName);
      if (volProps == null) {
        /**
        * <MAPR_ERROR>
        * Message:Failed to mount <volume name>, <error>
        * Function:VolumeCommands.volumeMount()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.ENOENT, "Failed to mount " +
            volName + ", " + Errno.toString(Errno.ENOENT)));
        /**
        * <MAPR_ERROR>
        * Message:VolumeMount : Could not find volume properties for <volume name>
        * Function:VolumeCommands.volumeMount()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        LOG.error("VolumeMount : Could not find volume properties for " + 
                  volName);     
        continue;
      }
      if (volProps.getMounted()) {
        LOG.warn("VolumeMount : Volume already mounted at " +
            volProps.getMountDir());
        out.addError(new OutputError(Errno.EINVAL, volName + " " + 
            Errno.toString(Errno.EINVAL) + " already mounted"));
        continue;
      }
      if (rwVolumeMountDir == null)
        rwVolumeMountDir = volProps.getMountDir();      
          
      if (!MapRCliUtil.parentDirExists(fs, cluster, rwVolumeMountDir)) {
      	// If createparent is set, create parent directory
      	if (getParamBooleanValue(RW_VOLUME_PARAM_CREATE_PARENT, 0)) {
      		if (!MapRCliUtil.createParentDir(fs, cluster, rwVolumeMountDir)) {
      			/**
             * <MAPR_ERROR>
             * Message:Volume Mount: Failed to create parent dir for mount path
             * Function:VolumeCommands.volumeMount()
             * Meaning:An error occurred.
             * Resolution:Contact technical support.
             * </MAPR_ERROR>
             */
             LOG.error("Volume Mount: Volume " + volName + ", failed to mount, " + 
            		       "could not create parent directory for mount dir " +
                       rwVolumeMountDir);
             /**
             * <MAPR_ERROR>
             * Message:Failed to create parent dir for mount path
             * Function:VolumeCommands.volumeMount()
             * Meaning:An error occurred.
             * Resolution:Contact technical support.
             * </MAPR_ERROR>
             */
             out.addError(new OutputError(Errno.ENOENT, "Failed to mount " + volName + 
            		          ", could not create parent directory for mount dir " + 
            		          rwVolumeMountDir));
             continue;
      		}      		
      	} else {
      		/**
           * <MAPR_ERROR>
           * Message:Volume Mount: Volume <volume> parent of mount dir <path> does not exist
           * Function:VolumeCommands.volumeMount()
           * Meaning:An error occurred.
           * Resolution:Contact technical support.
           * </MAPR_ERROR>
           */
           LOG.error("Volume Mount: Volume " + volName + " parent of mount dir " +
                     rwVolumeMountDir + " does not exist");
           /**
           * <MAPR_ERROR>
           * Message:Failed to mount <volume name>, parent of mount dir <path> does not exist, <error>
           * Function:VolumeCommands.volumeMount()
           * Meaning:An error occurred.
           * Resolution:Contact technical support.
           * </MAPR_ERROR>
           */
           out.addError(new OutputError(Errno.ENOENT, "Failed to mount " +
                        volName + ", parent of mount dir " + rwVolumeMountDir + 
                        " does not exist, " + Errno.toString(Errno.ENOENT)));
           continue;	
      	}
      }
      
      if (LOG.isDebugEnabled())
        LOG.debug("Mounting volume " + volName + " at " + rwVolumeMountDir);
      int status = fs.mountVolume(cluster, volName, 
                                  rwVolumeMountDir, getUserLoginId());
      if (status == 0) {        
        mountedVolumePaths.add(rwVolumeMountDir);
      } else {
        /**
        * <MAPR_ERROR>
        * Message:Failed to mount volume <volume name> <error>
        * Function:VolumeCommands.volumeMount()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(status, "Failed to mount volume " + 
            rwVolumeName + ", " + Errno.toString(status)));
        /**
        * <MAPR_ERROR>
        * Message:Unable to mount volume <volume name> at <path>
        * Function:VolumeCommands.volumeMount()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        LOG.error("Unable to mount volume " + volName + " at " +
                  rwVolumeMountDir);
      }
    }
    
    if (!mountedVolumePaths.isEmpty() && 
        !getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0)) {
      for (String dir : mountedVolumePaths) {
        if (!sleepAndCheckMountedDir(fs, cluster, dir)) {
          /**
          * <MAPR_ERROR>
          * Message:"Volume mount for <path> failed, Could not get status of mount path
          * Function:VolumeCommands.volumeMount()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED, "Volume mount for "
              + dir + " failed, Could not get status of mount path"));
        }
      }
    }
    return output;
  }
    
  CommandOutput volumeShowMounts() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);
    
    String volumeName = getParamTextValue(RW_VOLUME_PARAM_NAME, 0);
    byte[] data = null;
    VolumeShowMountsRequest volShowMountsReq = VolumeShowMountsRequest.newBuilder()
                                              .setVolumeName(volumeName)
                                              .setCreds(getUserCredentials())
                                              .build();
    try {
      if ( isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
        data = CLDBRpcCommonUtils.getInstance()
        .sendRequest(getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0),
            Common.MapRProgramId.CldbProgramId.getNumber(),
            CLDBProto.CLDBProg.VolumeShowMountsProc.getNumber(), 
            volShowMountsReq, 
            VolumeShowMountsResponse.class);
      } else {
        data = CLDBRpcCommonUtils.getInstance().sendRequest(
            Common.MapRProgramId.CldbProgramId.getNumber(),
            CLDBProto.CLDBProg
            .VolumeShowMountsProc.getNumber(), volShowMountsReq,
            VolumeShowMountsResponse.class);
      }

      if (data == null) {
        /**
         * <MAPR_ERROR>
         * Message:Force volumeShowMounts response null for volume <volume name>
         * Function:VolumeCommands.volumeShowMounts()
         * Meaning:An error occurred.
         * Resolution:Contact technical support.
         * </MAPR_ERROR>
         */
        out.addError(new OutputError(Errno.ERPCFAILED, "Couldn't connect to the CLDB service. " +
        		"volumeShowMounts response null for volume " + volumeName));
        LOG.error("VolumeShowMounts response null for volume " + volumeName);
      }  
          
      VolumeShowMountsResponse resp = VolumeShowMountsResponse.parseFrom(data);
      if (resp.getStatus() == 0) {
        OutputNode cOut = new OutputNode();
        OutputNode mountedVolumes = new OutputNode("MountedVolumes");
        cOut.addChild(mountedVolumes);
        
        for (String volName : resp.getVolumesList()) {
          mountedVolumes.addChild(new OutputNode("Name", volName));
        }
        out.addNode(cOut);
        
      } else {
        out.addError(new OutputError(resp.getStatus(), "Volume ShowMounts: " + 
                Errno.toString(resp.getStatus())));
        /**
         * <MAPR_ERROR>
         * Message:ShowMounts of volume failed, <error>
         * Function:VolumeCommands.volumeUnMount()
         * Meaning:An error occurred.
         * Resolution:Contact technical support.
         * </MAPR_ERROR>
         */
        LOG.error("ShowMounts of volume failed, " + Errno.toString(resp.getStatus()));
        return output;
      }         
    } catch (MaprSecurityException e) {
      throw new CLIProcessingException(
        "MaprSecurityException " + "Exception", e);
    } catch (Exception e) {
      out.addError(new OutputError(Errno.EOPFAILED, "Volume showMounts: " +
              " Operation failed"));
      LOG.error("Exception during volume show Mounts" + e);
      return output;
    }
    return output; 
  }


  CommandOutput volumeUnMount() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);

    List<String> volumeNames = new ArrayList<String>();
    
    String rwVolumeName = getRwVolumeName();
    if (!rwVolumeName.contains(MULTI_ARG_SEP)) {
      volumeNames.add(rwVolumeName);
    } else if (rwVolumeName.contains(MULTI_ARG_SEP)) {
      volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
    }
    boolean forceUnMount = false;
    if (isParamPresent(RW_VOLUME_PARAM_FORCE)) {
      forceUnMount = getParamBooleanValue(RW_VOLUME_PARAM_FORCE, 0);
    }
        
    MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
    String cluster = null;
    if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
      cluster = getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM, 0);
    }
    
    boolean unmountedOne = false;
    
    for (String volName : volumeNames) {
      VolumeProperties volProps = this.volumePropetiesLookup(volName, false);
      if (volProps == null) {
        /**
        * <MAPR_ERROR>
        * Message:Cannot find volume properties for <volume name> <error>
        * Function:VolumeCommands.volumeUnMount()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.ENOENT, "Cannot find volume properties for " + 
            volName + " " + Errno.toString(Errno.ENOENT)));
        /**
        * <MAPR_ERROR>
        * Message:VolumeUnmount : Could not find volume properties for <volume name>
        * Function:VolumeCommands.volumeUnMount()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        LOG.error("VolumeUnmount : Could not find volume properties for " + 
            volName);
        continue;
      }
      
      // Send it to fileserver
      if (!volProps.getMounted()) {
        LOG.warn("VolumeUnmount : Volume " + volName + " already unmounted");
       /**
       * <MAPR_ERROR>
       * Message:Volume <volume name> already unmounted, <error>
       * Function:VolumeCommands.volumeUnMount()
       * Meaning:The specified volume is already unmounted.
       * Resolution:Check the volume name and try again.
       * </MAPR_ERROR>
       */
        out.addError(new OutputError(Errno.EINVAL, "Volume " + 
            volName + "already unmounted, " + Errno.toString(Errno.EINVAL)));
        continue;
      }
      boolean rootVolUnMount = false;
      if (volProps.getVolumeName()
          .equals(MapRClusterDefaults.getDefaultInstance()
              .getClusterRootName())) {
        rootVolUnMount = true;
        forceUnMount = true; // For root volumeunmount force unmount
      }
      
      String rwVolumeMountDir = volProps.getMountDir();
      FidMsg parentFid = volProps.getParentFid();
      
      int status = 0;
      if (!rootVolUnMount) {
        status = fs.unmountVolume (
                cluster,
                volName,
                rwVolumeMountDir,
                getUserLoginId(),
                parentFid.getCid(),
                parentFid.getCinum(),
                parentFid.getUniq());
      }
      
      if (rootVolUnMount || ((status != 0) && (forceUnMount))) {
        // Send to CLDB 
        if (LOG.isDebugEnabled())
          LOG.debug("ForceUnmount volume " + volName);
        byte[] data = null;
        VolumeUnMountRequest volUnMount = VolumeUnMountRequest.newBuilder()
                                              .setVolumeName(volName)
                                              .setCreds(getUserCredentials())
                                              .setForce(true)
                                              .build();
        try {
            if ( isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
              data = CLDBRpcCommonUtils.getInstance()
                .sendRequest(getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0),
                    Common.MapRProgramId.CldbProgramId.getNumber(),
                    CLDBProto.CLDBProg.VolumeUnMountProc.getNumber(), 
                    volUnMount, 
                    VolumeUnMountResponse.class);
            } else {
              data = CLDBRpcCommonUtils.getInstance().sendRequest(
                  Common.MapRProgramId.CldbProgramId.getNumber(),
                CLDBProto.CLDBProg
                    .VolumeUnMountProc.getNumber(), volUnMount,
                    VolumeUnMountResponse.class);
            }

          if (data == null) {
            /**
            * <MAPR_ERROR>
            * Message:Force volumeUnmount response null for volume <volume name>
            * Function:VolumeCommands.volumeUnMount()
            * Meaning:An error occurred.
            * Resolution:Contact technical support.
            * </MAPR_ERROR>
            */
            out.addError(new OutputError(Errno.ERPCFAILED, "Couldn't connect to the CLDB service. Force volumeUnmount " +
                "response null for volume " + volName));
            LOG.error("Force volumeUnmount response null for volume " + volName);
          }  
          
          VolumeUnMountResponse resp = VolumeUnMountResponse.parseFrom(data);
          if (resp.getStatus() == 0) {
            if (LOG.isInfoEnabled())
              LOG.info("Force unmount volume " + volName);
            continue;
          } else {
            /**
            * <MAPR_ERROR>
            * Message:Volume UnMount: <error>
            * Function:VolumeCommands.volumeUnMount()
            * Meaning:An error occurred.
            * Resolution:Contact technical support.
            * </MAPR_ERROR>
            */
            out.addError(new OutputError(resp.getStatus(), "Volume UnMount: " + 
                Errno.toString(resp.getStatus())));
            /**
            * <MAPR_ERROR>
            * Message:Forceunmount of volume failed, <error>
            * Function:VolumeCommands.volumeUnMount()
            * Meaning:An error occurred.
            * Resolution:Contact technical support.
            * </MAPR_ERROR>
            */
            LOG.error("Forceunmount of volume failed, " + Errno.toString(resp.getStatus()));
            continue;
          }         
        } catch (MaprSecurityException e) {
          throw new CLIProcessingException(
            "MaprSecurityException " + "Exception", e);
        } catch (Exception e) {
          /**
          * <MAPR_ERROR>
          * Message:Volume unMount:  Operation failed
          * Function:VolumeCommands.volumeUnMount()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED, "Volume unMount: " +
              " Operation failed"));
          /**
          * <MAPR_ERROR>
          * Message:Exception during volume force unmount <error>
          * Function:VolumeCommands.volumeUnMount()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          LOG.error("Exception during volume force unmount " + e);
          continue;
        }
      } else if (status != 0) {
        /**
        * <MAPR_ERROR>
        * Message:Failed to unmount volume <error>
        * Function:VolumeCommands.volumeUnMount()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(status, "Failed to unmount volume " + 
            Errno.toString(status)));
        /**
        * <MAPR_ERROR>
        * Message:Volume unmount <volume name> failed, <error>
        * Function:VolumeCommands.volumeUnMount()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        LOG.error("Volume unmount "+ rwVolumeMountDir + " failed, " + 
                  Errno.toString(status));
        continue;
      } else {
        if (LOG.isInfoEnabled())
          LOG.info("Volume unmount " + rwVolumeMountDir + " successful");
        unmountedOne = true;
      }
    }
    
    if (unmountedOne && !getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0)) {
      try {
        Thread.sleep(VOLUME_OP_DELAY * 1000);
      } catch (InterruptedException e) {
      }
    }
    return output; 
  }
  
  // TODO: Handle ACEs in the following
  CommandOutput volumeCreate() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);
    
    String rwVolumeName = getRwVolumeName();
    boolean rootVolume = (rwVolumeName.equals(
        MapRClusterDefaults.getDefaultInstance()
          .getClusterRootName())) ? true : false;
    
    boolean permsPresent = false;
    AccessControlList.Builder aclBuilder = AccessControlList.newBuilder();
    if (isParamPresent(USERPERM_PARAM_NAME)) {
      permsPresent = true;
      List<String> perms = input.getParameterByName(USERPERM_PARAM_NAME).getParamValues();
      List<String> userNames = getUserGroupsNames(perms);
      for (String userName : userNames) {
        if (!checkEntityExists(false, userName)) {
          /**
          * <MAPR_ERROR>
          * Message:Volume create failed - user <user> not found
          * Function:VolumeCommands.volumeUnMount()
          * Meaning:The specified user was not found.
          * Resolution:Check the user name and the command syntax, and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED,
              "Volume create failed - user " + userName + " not found")
              .setField(USERPERM_PARAM_NAME));
          return output;
        }
      }
      List<AclEntry> elements = AclCommands.actionsToAcls(perms, uInfo, 
          SecureObjectType.OBJECT_TYPE_VOLUME, true, out); 
      if (elements == null) {
        /**
        * <MAPR_ERROR>
        * Message:Volume create failed - invalid list of user permissions - <permissions>
        * Function:VolumeCommands.volumeUnMount()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EOPFAILED,
            "Volume create failed - invalid list of user permissions - " + perms)
            .setField(USERPERM_PARAM_NAME));
        return output;
      }
      aclBuilder.addAllAcl(elements);
    }

    if (isParamPresent(GROUPPERM_PARAM_NAME)) {
      permsPresent = true;
      List<String> perms = input.getParameterByName (GROUPPERM_PARAM_NAME).getParamValues();
      List<String> groupNames = getUserGroupsNames(perms);
      for (String groupName : groupNames) {
        if (!checkEntityExists(true, groupName)) {
          /**
          * <MAPR_ERROR>
          * Message:Volume create failed - group <group> not found
          * Function:VolumeCommands.volumeUnMount()
          * Meaning:The specified group was not found.
          * Resolution:Check the group name and the command syntax, and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED,
              "Volume create failed - group " + groupName + " not found")
              .setField(USERPERM_PARAM_NAME));
          return output;
        }
      }
      List<AclEntry> elements = AclCommands.actionsToAcls(perms, uInfo,
          SecureObjectType.OBJECT_TYPE_VOLUME, false, out); 
      if (elements == null) {
        /**
        * <MAPR_ERROR>
        * Message:Volume create failed - invalid list of group permissions - <permissions>
        * Function:VolumeCommands.volumeUnMount()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EOPFAILED,
            "Volume create failed - invalid list of group permissions - " + perms)
            .setField(GROUPPERM_PARAM_NAME));
        return output;
      }
      aclBuilder.addAllAcl(elements);
    }
    
    if (rootVolume) {
      try {
       VolumeCreateRequest.Builder volumeCreate = VolumeCreateRequest.newBuilder();
        // Root Volume is special
       VolumeProperties volProps = VolumeProperties.newBuilder()
           .setVolumeName(MapRClusterDefaults.getDefaultInstance().getClusterRootName())
           .setMounted(true)
           .setMountDir(MapRClusterDefaults.getDefaultInstance().getClusterRootPath())
           .setAcl(aclBuilder.build())
           .build();
       volumeCreate.setVolProperties(volProps);
       volumeCreate.setCreds(getUserCredentials());
       
       byte[] data = null;
       if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
         data = CLDBRpcCommonUtils.getInstance().sendRequest(
             getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0),
             Common.MapRProgramId.CldbProgramId.getNumber(),
             CLDBProto.CLDBProg
             .VolumeCreateProc.getNumber(), 
             volumeCreate.build(), VolumeCreateResponse.class);
       } else {
         data = CLDBRpcCommonUtils.getInstance().sendRequest(
             Common.MapRProgramId.CldbProgramId.getNumber(),
             CLDBProto.CLDBProg
             .VolumeCreateProc.getNumber(), 
             volumeCreate.build(), VolumeCreateResponse.class);
       }
  
       if (data == null) {
         out.addError(new OutputError(Errno.ERPCFAILED, "Couldn't connect to the CLDB service"));
         return output;
       }  
       
       VolumeCreateResponse resp = VolumeCreateResponse.parseFrom(data);
       LOG.info(resp.getErrMsg());
       out.addError(new OutputError(resp.getStatus(),resp.getErrMsg()));
       return output;
      } catch (MaprSecurityException e) {
        throw new CLIProcessingException(
           "MaprSecurityException " + "Exception", e);
      } catch (Exception e) {
        throw new CLIProcessingException("Exception while sending RPC to CLDB");
      }
    } /* if (rootVolume) */
    
    String rwVolumeMountDir = null;
    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MOUNTDIR)) {
      rwVolumeMountDir = getParamTextValue(
                              VolumeCommands.RW_VOLUME_PARAM_MOUNTDIR, 0)
                         .replaceAll("\\/+$", "");
    }
    
    boolean mount = true;
    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MOUNT)) {
      mount = getParamBooleanValue(VolumeCommands.RW_VOLUME_PARAM_MOUNT, 0);
    }
    
    // Check to see if name length exceeds
    if (!VolumeUtils.isValidVolumeNameLength(rwVolumeName)) {
      /**
      * <MAPR_ERROR>
      * Message:Invalid Volume Name <volume name>, Exceeds allowed length of <number> characters
      * Function:VolumeCommands.volumeCreate()
      * Meaning:The specified volume name is too long.
      * Resolution:Choose a shorter volume name and try again.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EINVAL,
          "Invalid Volume Name " + rwVolumeName +
          ", Exceeds allowed length of " + 
          VolumeUtils.validVolumeNameLength() + " characters")
            .setField(RW_VOLUME_PARAM_NEW_NAME));      
      return output;
    }
    // Check if it is valid volume name
    if (!VolumeUtils.isValidVolumeName(rwVolumeName)) {
      /**
      * <MAPR_ERROR>
      * Message:Invalid Volume Name <volume name>, Allowed characters 
      * Function:VolumeCommands.volumeCreate()
      * Meaning:The specified volume name is invalid because it contains characters that are not allowed.
      * Resolution:Choose a new volume name and try again.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EINVAL,
          "Invalid Volume Name " + rwVolumeName +
          ", Allowed characters " + VolumeUtils.getValidName())
            .setField(RW_VOLUME_PARAM_NEW_NAME));      
      return output;
    }

    String cluster = null;
    if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM))
      cluster = getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM, 0);

     // If a volume already exists with given name, fail
    VolumeLookupResponse lookupResp = volumeLookup(cluster, getUserCredentials(),
                                                   rwVolumeName, null,isServerCall);
    if (lookupResp != null &&
        lookupResp.getStatus() == Errno.SUCCESS) {
      /**
       * <MAPR_ERROR>
       * Message:A Volume Already Exist With Same Name <volume name>,
       * Function:VolumeCommands.volumeCreate()
       * Meaning:The specified volume name is already in use.
       * Resolution:Choose a new volume name and try again.
       * </MAPR_ERROR>
       */
      out.addError(new OutputError(Errno.EEXIST,
            "Volume name " + rwVolumeName + ", already in use.")
          .setField(RW_VOLUME_PARAM_NEW_NAME)
          .setPropagateErrorSupport(true));
      return output;
    }

    VolumeCreateRequest.Builder volumeCreate = VolumeCreateRequest.newBuilder();
    VolumeProperties.Builder    volProps     = VolumeProperties.newBuilder()
                                                               .setVolumeName(rwVolumeName);
    if (permsPresent) {
      volProps.setAcl(aclBuilder);
    }
    ReplicationPolicy.Builder replPolicy = null;
    
    if (isParamPresent(VolumeCommands.RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC)) {
      int timeout = getParamIntValue(VolumeCommands
          .RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, 0);
      volProps.setReReplicationTimeOutSec(timeout);
    }

    if (isParamPresent(VolumeCommands.RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC)) {
      int timeout = getParamIntValue(VolumeCommands
          .RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC, 0);
      volProps.setCriticalReReplicationTimeOutSec(timeout);
    }

    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_READONLY)) {
      boolean readOnly = getParamBooleanValue(VolumeCommands.RW_VOLUME_PARAM_READONLY, 0);    
      volProps.setReadOnly(readOnly);
    }

    boolean allowInherit = true;
    if (isParamPresent(VolumeCommands.ALLOW_INHERIT)) {
      allowInherit = getParamBooleanValue(ALLOW_INHERIT, 0);
    }
    
    if (isParamPresent(VolumeCommands.INHERIT_SOURCE) && allowInherit) {
      String src = getParamTextValue(VolumeCommands.INHERIT_SOURCE, 0);
      volumeCreate.setInheritPropsSource(src);
    }

    if (isParamPresent(VolumeCommands.ALLOW_GRANT)) {
      boolean val = getParamBooleanValue(VolumeCommands.ALLOW_GRANT, 0);
      volProps.setAllowGrant(val);
    }

    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_LOCALVOLUMEHOST) &&
         isParamPresent(VolumeCommands.RW_VOLUME_PARAM_LOCALVOLUMEPORT)) {
      String fsHost = getParamTextValue(VolumeCommands
                                        .RW_VOLUME_PARAM_LOCALVOLUMEHOST, 0);
      List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(fsHost));
      int localFSPort = getParamIntValue(VolumeCommands
                                                  .RW_VOLUME_PARAM_LOCALVOLUMEPORT, 0);

      final IPAddress.Builder ipAddressBuilder = IPAddress.newBuilder();
      ipAddressBuilder.setHostname(fsHost).setPort(localFSPort);
      //This is kept for backward compatibility. Cldb does not need
      //ip now.
      if (!ips.isEmpty()) {
        ipAddressBuilder.setHost(Util.ipToInt(ips.get(0)));
      }
      final IPAddress fileServer = ipAddressBuilder.build();

      FileServerInfo fsInfo = NodesCommonUtils.getFileServerInfo(fileServer,
                                                                 getUserCredentials(), cluster);
      if (fsInfo == null) {
        /**
        * <MAPR_ERROR>
        * Message:FileServer <host>:<port> has not registered with CLDB
        * Function:VolumeCommands.volumeCreate()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EINVAL, 
          "FileServer " + fsHost + ":" + localFSPort +
          " has not registered with CLDB"));
        return output;
      }
      if (fsInfo.getLastHeartbeatSec() > VOLUME_ON_FILESERVER_TIMEOUT_SEC) {
        /**
        * <MAPR_ERROR>
        * Message:FileServer<host>:<port> has not heartbeated with CLDB for <time>
        * Function:VolumeCommands.volumeCreate()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EINVAL, 
            "FileServer " + fsHost + ":" + localFSPort + 
            " has not heartbeated with CLDB for " +
            fsInfo.getLastHeartbeatSec()));
          return output;
      }
      
      // Set replication of local volume to be 1 (default value, can be 
      // overridden).
      if (replPolicy == null)
        replPolicy = ReplicationPolicy.newBuilder();
      replPolicy.setNumReplicas(1);
      replPolicy.setGuaranteedMinReplicas(1);

      volProps.setLocalVolume(true);
      volumeCreate.setLocalFileServer(fileServer);
    }

    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_SHUFFLEVOLUME)) {
      boolean shuffleVol = getParamBooleanValue(
                               VolumeCommands.RW_VOLUME_PARAM_SHUFFLEVOLUME, 0);
      volProps.setShuffleVolume(shuffleVol);
    }

    // Use logged in userName
    volProps.setOwnerId((int)super.getUserId());    
          
    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_AE) ||
        isParamPresent(VolumeCommands.RW_VOLUME_PARAM_AETYPE)) {
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_AETYPE) &&
          (!isParamPresent(VolumeCommands.RW_VOLUME_PARAM_AE))) {
        /**
        * <MAPR_ERROR>
        * Message:Please specify both <parameter> and <parameter> while creating volume 
        * Function:VolumeCommands.volumeCreate()
        * Meaning:Not all required commands were specified.
        * Resolution:Check the command syntax and try again.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EINVAL, 
            "Please specify both " + VolumeCommands.RW_VOLUME_PARAM_AETYPE +
            " and " + VolumeCommands.RW_VOLUME_PARAM_AE + 
            " while creating volume " + rwVolumeName));
        return output;
      }
      String name = getParamTextValue(VolumeCommands.RW_VOLUME_PARAM_AE, 0);
      boolean type = isParamPresent(VolumeCommands.RW_VOLUME_PARAM_AETYPE) ?
          getParamBooleanValue(VolumeCommands.RW_VOLUME_PARAM_AETYPE, 0) : false;
      if (!checkEntityExists(type, name)) {
        /**
        * <MAPR_ERROR>
        * Message:Invalid AE specified while trying to create Volume <volume name>
        * Function:VolumeCommands.volumeCreate()
        * Meaning:The specified user or group is not valid.
        * Resolution:Check the user or group and try again.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EINVAL, 
            "Invalid AE specified while trying to create Volume " + rwVolumeName));
        /**
        * <MAPR_ERROR>
        * Message:Volume create with invalid AE 
        * Function:VolumeCommands.volumeCreate()
        * Meaning:The specified user or group is not valid.
        * Resolution:Check the user or group and try again.
        * </MAPR_ERROR>
        */
        LOG.error("Volume create with invalid AE ");        
        return output;
      }
      AeKey.Builder keyBuilder = AeKey.newBuilder();
      keyBuilder.setName(name);
      keyBuilder.setType(type);
      volProps.setVolumeAe(keyBuilder);
    }

    long quotaInMB = 0L;
    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_QUOTA)) {
      String quota = getParamTextValue(
                            VolumeCommands.RW_VOLUME_PARAM_QUOTA, 0);
      quotaInMB = MapRCliUtil.quotaStringToMB(quota);
      if (quotaInMB == -1) {
        /**
        * <MAPR_ERROR>
        * Message:Volume create with invalid quota <quota>, Should be either an Integer, or a decimal value followed by one of (M,MB,G,GB,T,TB,P,PB)
        * Function:VolumeCommands.volumeCreate()
        * Meaning:The quota size must be specified as a number and letter specifying a number of units. Example: 500GB specifies a quota size of 500 gigabytes.
        * Resolution:Check the command syntax and try again
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EOPFAILED, 
                                     "Volume create with invalid quota " + quota +
                                     ", Should be either an Integer, or a decimal value " +
                                     "followed by one of (M,MB,G,GB,T,TB,P,PB)")
                            .setField(RW_VOLUME_PARAM_QUOTA));        
        return output;
      }
      volProps.setVolumeQuotaSizeMB(quotaInMB);
    }
    int mode;
    String rootDirPerms;
    if (isParamPresent(VolumeCommands.RW_VOLUME_ROOT_DIR_PERM)) {
      rootDirPerms = getParamTextValue(VolumeCommands
                                        .RW_VOLUME_ROOT_DIR_PERM, 0);
    } else {
      try {
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        rootDirPerms = String.format("%04o", MapRClientImpl.getModeBits(FsPermission.getDefault(), fs.getConf()));
      } catch (IllegalArgumentException e) {
        out.addError(new OutputError(Errno.EOPFAILED, 
              "Error parsing \"dfs.umaskmode\" property from core-site.xml."));
        return output;
      }
    }

    try {
      mode = Integer.parseInt(rootDirPerms, 8);
    } catch (NumberFormatException e) {
      /**
      * <MAPR_ERROR>
      * Message:VolumeCreate: Volumename : <volume name> Invalid rootdirperms specified. Should be valid octal string
      * Function:VolumeCommands.volumeCreate()
      * Meaning:The permissions on the root directory are invalid.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      LOG.error("VolumeCreate: Volumename : " + rwVolumeName + " Invalid " +
      		"rootdirperms specified. Should be valid octal string");
      /**
      * <MAPR_ERROR>
      * Message:Volume Create for <volume name> failed, Invalid rootdirperms specified. Should be valid octal string
      * Function:VolumeCommands.volumeCreate()
      * Meaning:The permissions on the root directory are invalid.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EINVAL, 
          "Volume Create for " + rwVolumeName + " failed, Invalid " +
          "rootdirperms specified. Should be valid octal string")
         .setField(RW_VOLUME_ROOT_DIR_PERM));        
      return output;
    }

    if ((mode & ~07777) != 0) {
      /**
      * <MAPR_ERROR>
      * Message:VolumeCreate: Volumename : <volume name> Invalid rootdirperms specified. Should be a subset of 07777. 
      * Function:VolumeCommands.volumeCreate()
      * Meaning:The permissions on the root directory are invalid.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      LOG.error("VolumeCreate: Volumename : " + rwVolumeName + " Invalid " +
      		"rootdirperms specified. Should be a subset of 07777");
      /**
      * <MAPR_ERROR>
      * Message:Volume Create for <volume name> failed, Invalid rootdirperms specified. Should be valid octal string
      * Function:VolumeCommands.volumeCreate()
      * Meaning:The permissions on the root directory are invalid.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EINVAL, 
          "Volume Create for " + rwVolumeName + " failed, Invalid " +
          "rootdirperms specified. Should be a subset of 07777")
         .setField(RW_VOLUME_ROOT_DIR_PERM));        
      return output;
    } 
    volProps.setRootDirPerms(mode);
    
    long advisoryQuotaInMB = 0L;
    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_ADVISORY_QUOTA)) {
      String quota = getParamTextValue(
                            VolumeCommands.RW_VOLUME_PARAM_ADVISORY_QUOTA, 0);
      advisoryQuotaInMB = MapRCliUtil.quotaStringToMB(quota);
      if (advisoryQuotaInMB == -1) {   
        /**
        * <MAPR_ERROR>
        * Message:Volume create of <volume name> with invalid advisory quota <quota>, Should be either an Integer, or a decimal value followed by one of (M,MB,G,GB,T,TB,P,PB)
        * Function:VolumeCommands.volumeCreate()
        * Meaning:The quota size must be specified as a number and letter specifying a number of units. Example: 500GB specifies a quota size of 500 gigabytes.
        * Resolution:Check the command syntax and try again.
        * </MAPR_ERROR>
        */             
        out.addError(new OutputError(Errno.EOPFAILED, 
                            "Volume create of " + rwVolumeName + 
                            "with invalid advisory quota " + quota + 
                            ", Should be either an Integer, or a decimal value " +
                            "followed by one of (M,MB,G,GB,T,TB,P,PB)")
                            .setField(RW_VOLUME_PARAM_ADVISORY_QUOTA));        
        return output;
      }
      volProps.setVolumeQuotaAdvisorySizeMB(advisoryQuotaInMB);
    }
    
    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_ADVISORY_QUOTA) &&
        isParamPresent(VolumeCommands.RW_VOLUME_PARAM_QUOTA)) {
      if ((quotaInMB > 0) && (advisoryQuotaInMB > quotaInMB)) {
        /**
        * <MAPR_ERROR>
        * Message:Volume create of <volume name> with invalid advisory quota greater than volume quota
        * Function:VolumeCommands.volumeCreate()
        * Meaning:The advisory quota cannot be greater than the volume quota.
        * Resolution:Check the parameters and try again.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EOPFAILED, 
            "Volume create of " + rwVolumeName + 
            " with invalid advisory quota greater than volume quota")
            .setField(RW_VOLUME_PARAM_ADVISORY_QUOTA));        
        return output;
      }
    }
         
    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_REPLICATION) ||
        isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MIN_REPLICATION) ||
        isParamPresent(VolumeCommands.RW_VOLUME_PARAM_DCREPLTYPE)) {

      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MIN_REPLICATION) &&
          !isParamPresent(VolumeCommands.RW_VOLUME_PARAM_REPLICATION)) {
        /**
        * <MAPR_ERROR>
        * Message:Volume create of <volume name> insufficient arguments. Please specify replication along with minreplication
        * Function:VolumeCommands.volumeCreate()
        * Meaning:You must specify a desired replication factor and a minimum replication factor.
        * Resolution:Check the command syntax and try again.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EINVAL, "Volume create of " + 
            rwVolumeName + " insufficient arguments. Please specify " +
            		"replication along with minreplication"));      
        return output;
      }

      if (replPolicy == null)
        replPolicy = ReplicationPolicy.newBuilder();

      int repl = 0;
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_REPLICATION)) {
        repl = getParamIntValue(VolumeCommands
                                        .RW_VOLUME_PARAM_REPLICATION, 0);
        if (repl > 0) {
          if (repl > maxVolumeReplicationFactor) {
            /**
            * <MAPR_ERROR>
            * Message:Volume create of <volume name> failed. The maximum value allowed for
            * the replication factor is <replication> while the requested value is <replication>
            * Function:VolumeCommands.volumeCreate()
            * Meaning:The specified replication is too high.
            * Resolution:Try again, specifying a lower replication factor.
            * </MAPR_ERROR>
            */
            out.addError(new OutputError(Errno.EINVAL,
                "Volume create of "
                + rwVolumeName + " failed. "
                + "The maximum value allowed for the replication factor is " 
                + maxVolumeReplicationFactor
                + " while the requested value is "
                + repl));
            return output;
          }
          replPolicy.setNumReplicas(repl);
        } else {
          /**
          * <MAPR_ERROR>
          * Message:Volume create of <volume name> failed, due to invalid replication 
          * Function:VolumeCommands.volumeCreate()
          * Meaning:The specified replication factor was invalid.
          * Resolution:Check the command syntax and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED, "Volume create of " + 
              rwVolumeName + " failed, due to invalid replication " + repl));      
          return output;
        }
      }
      
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MIN_REPLICATION)) {
        int minRepl = getParamIntValue(VolumeCommands
            .RW_VOLUME_PARAM_MIN_REPLICATION, 0);
        if (minRepl > 0) {
          if (repl > 0 && minRepl > repl) {
            /**
            * <MAPR_ERROR>
            * Message:Volume create of <volume name> failed, minreplication <replication> greater than replicaton
            * Function:VolumeCommands.volumeCreate()
            * Meaning:The specified minimum replication is greater than the replication.
            * Resolution:Specify a minimum replication factor lower than the desired replication factor, and try again.
            * </MAPR_ERROR>
            */
            out.addError(new OutputError(Errno.EOPFAILED, "Volume create of " + 
                rwVolumeName + " failed, minreplication " + repl +
                " greater than replicaton"));          
            return output;
          }
          replPolicy.setGuaranteedMinReplicas(minRepl);
        } else {
          /**
          * <MAPR_ERROR>
          * Message:Volume create of <volume name> failed, due to invalid minreplication 
          * Function:VolumeCommands.volumeCreate()
          * Meaning:The specified minimum replication factor was invalid.
          * Resolution:Check the command syntax and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED, "Volume create of " + 
            rwVolumeName + " failed, due to invalid minreplication " + repl));
          return output;
        }
      } else {
        if (repl == 1) {
          replPolicy.setGuaranteedMinReplicas(repl);
        }
      }

      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_DCREPLTYPE)) {
        String stype = getParamTextValue(VolumeCommands
            .RW_VOLUME_PARAM_DCREPLTYPE, 0);
        ContainerReplType rtype = getContainerReplType(stype);
        if (rtype == ContainerReplType.INVALID) {
          /**
          * <MAPR_ERROR>
          * Message:Volume create of <volume name> failed, due to invalid replicationtype
          * Function:VolumeCommands.volumeCreate()
          * Meaning:The specified minimum replication type was invalid. 
          * Resolution:Check the command syntax and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED, "Volume create of " + 
            rwVolumeName + " failed, due to invalid replicationtype " +
            stype));
          return output;
        }

        replPolicy.setDataContainerReplType(rtype);
      }
    }

    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_REPLICATION) ||
        isParamPresent(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION)) {

      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION) &&
          !isParamPresent(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_REPLICATION)) {
        /**
        * <MAPR_ERROR>
        * Message:Volume create of <volume name> insufficient arguments. Please specify namespace replication along with namespace minreplication
        * Function:VolumeCommands.volumeCreate()
        * Meaning:You must specify a desired replication factor and a minimum replication factor for namespace container.
        * Resolution:Check the command syntax and try again.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EINVAL, "Volume create of " + 
            rwVolumeName + " insufficient arguments. Please specify " +
            		"namespace replication along with namespace minreplication"));      
        return output;
      }
      int repl = 0;

      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_REPLICATION)) {
        repl = getParamIntValue(VolumeCommands
                                .RW_VOLUME_PARAM_NAMESPACE_REPLICATION, 0);
        if (repl <= 0) {
          /**
          * <MAPR_ERROR>
          * Message:Volume create of <volume name> failed, due to invalid namespace replication 
          * Function:VolumeCommands.volumeCreate()
          * Meaning:The specified namespace replication factor was invalid.
          * Resolution:Check the command syntax and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED, "Volume create of " + 
              rwVolumeName + " failed, due to invalid namespace replication " + repl));      
          return output;
        }
        if (repl > maxVolumeReplicationFactor) {
          /**
           * <MAPR_ERROR>
           * Message:Volume create of <volume name> failed. The maximum value allowed for
           * the namespace replication factor is <replication> while the requested value is <replication>
           * Function:VolumeCommands.volumeCreate()
           * Meaning:The specified namespace replication is too high.
           * Resolution:Try again, specifying a lower namespace replication factor.
           * </MAPR_ERROR>
           */
          out.addError(new OutputError(Errno.EINVAL,
                "Volume create of "
                + rwVolumeName + " failed. "
                + "The maximum value allowed for the namespace replication factor is " 
                + maxVolumeReplicationFactor
                + " while the requested value is "
                + repl));
          return output;
        }
        volProps.setNumNamespaceReplicas(repl);
      }
      
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION)) {
        int minRepl = getParamIntValue(VolumeCommands
                                       .RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, 0);
        if (minRepl <= 0) {
          /**
          * <MAPR_ERROR>
          * Message:Volume create of <volume name> failed, due to invalid namespace minreplication 
          * Function:VolumeCommands.volumeCreate()
          * Meaning:The specified minimum replication factor for namespace was invalid.
          * Resolution:Check the command syntax and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED, "Volume create of " +
            rwVolumeName + " failed, due to invalid namespace minreplication " + repl));
          return output;
        }
        if (minRepl > repl) {
          /**
           * <MAPR_ERROR>
           * Message:Volume create of <volume name> failed, minreplication for namespace <replication> greater than replicaton for namespace
           * Function:VolumeCommands.volumeCreate()
           * Meaning:The specified namespace minimum replication is greater than the namespace replication.
           * Resolution:Specify a minimum namespace replication factor lower than the desired namespace replication factor, and try again.
           * </MAPR_ERROR>
           */
          out.addError(new OutputError(Errno.EOPFAILED, "Volume create of " +
                rwVolumeName + " failed, namespace minreplication " + minRepl +
                " can not be more than namespace replicaton " + repl));
          return output;
        }
        volProps.setGuaranteedMinNamespaceReplicas(minRepl);
      }
    }
    
    
    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MIRRORTHROTTLE)) {
      boolean mirrorThrottle =
        getParamBooleanValue(VolumeCommands.RW_VOLUME_PARAM_MIRRORTHROTTLE, 0);
      volProps.setMirrorThrottle(mirrorThrottle);
    }

    if (isParamPresent(VOLUME_LIMIT_SPREAD)) {
      boolean limitSpread = getParamBooleanValue(VOLUME_LIMIT_SPREAD, 0);
      volProps.setLimitVolumeSpread(limitSpread);
    }

    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_TOPOLOGY)) {
      String topology = getParamTextValue(VolumeCommands
                                .RW_VOLUME_PARAM_TOPOLOGY, 0);
      if (!topology.startsWith("/")) {
        /**
        * <MAPR_ERROR>
        * Message:Invalid topology(rackpath) specified <topology>. Topology must start with \"/\"
        * Function:VolumeCommands.volumeCreate()
        * Meaning:The specified topology does not start with a forward slash.
        * Resolution:Check the command syntax and try again.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EINVAL, 
                                     "Invalid topology(rackpath) specified" + 
                                     topology + 
                                     ". It should start with \"/\"")
                           .setField(RW_VOLUME_PARAM_TOPOLOGY).setFieldValue(topology));        
        return output;
      }
      VolumeTopology topo = VolumeTopology.newBuilder()
                              .setTopologyRestricted(topology)
                              .build();
      volProps.setTopology(topo);
    }
    
    if ( isParamPresent(VolumeCommands.VOLUME_SCHEDULE)) {
    	int scheduleId = getParamIntValue(VOLUME_SCHEDULE, 0);
    	volProps.setSchedulingPolicyId(scheduleId);
    }

    if ( isParamPresent(VolumeCommands.VOLUME_MIRROR_SCHEDULE)) {
    	int scheduleId = getParamIntValue(VOLUME_MIRROR_SCHEDULE, 0);
    	volProps.setMirrorSchedulingPolicyId(scheduleId);
    }

    if ( isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD)) {
      long maxInodes = getParamLongValue(VolumeCommands
                         .RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, 0);
      volProps.setMaxInodesAlarmThreshold(maxInodes);
    }
    if ( isParamPresent(VolumeCommands.RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH)) {
      int thresh = getParamIntValue(VolumeCommands
                      .RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, 0);
      volProps.setDbReplLagSecAlarmThresh(thresh);
    }


    if (isParamPresent(VolumeCommands.MIRROR_VOLUME)) {
      int mirrorFlag = 3;
      String mirrorType = getParamTextValue(MIRROR_VOLUME, 0);
      if (!mirrorType.equalsIgnoreCase("rw") &&
          !mirrorType.equalsIgnoreCase("mirror") &&
          !mirrorType.equalsIgnoreCase("0") &&
          !mirrorType.equalsIgnoreCase("1")) {
          out.addError(new OutputError(Errno.EINVAL, 
        		           "Invalid type " + mirrorType +
                       " specified. Please specify rw/mirror")
                           .setField(MIRROR_VOLUME_SRC_VOLUMENAME));          
          return output;
      }
      if (mirrorType.equalsIgnoreCase("mirror") ||
          mirrorType.equalsIgnoreCase("1"))
        mirrorFlag = 2;
      if (mirrorFlag == 1 || mirrorFlag == 2) {
        // Mirror volume cannot be audit volume
        if (isParamPresent(VolumeCommands.AUDIT_VOLUME)) {
          boolean isAuditVolume = getParamBooleanValue(AUDIT_VOLUME, 0);
          if (isAuditVolume) {
            out.addError(new OutputError(Errno.EINVAL,
                          "Mirror volume cannot be audit volume")
                           .setField(AUDIT_VOLUME));
            return output;
          }
        }

        // Set readOnly flag for MirrorVolume
        // For UI/CLI mirror volumes should be shown as ReadOnly
        volProps.setReadOnly(true);
        LOG.info("Setting readonly to true for Mirror Volume " +
          volProps.getVolumeName());
        if (!isParamPresent(VolumeCommands.MIRROR_VOLUME_SRC_VOLUMENAME)) {
          /**
          * <MAPR_ERROR>
          * Message:Source volume name is not specified.
          * Function:VolumeCommands.volumeCreate()
          * Meaning:You must specify a source volume name.
          * Resolution:Check the volume name and the command syntax, then try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EINVAL, 
        		           "Source volume name is not specified.")
                           .setField(MIRROR_VOLUME_SRC_VOLUMENAME));          
          return output;
        }
        String srcVolumeFullName = getParamTextValue(
        		VolumeCommands.MIRROR_VOLUME_SRC_VOLUMENAME, 0);
        int index = srcVolumeFullName.indexOf('@');
        if ((index == -1) || (index == 0)) {
          /**
          * <MAPR_ERROR>
          * Message:Source volume name is not specified in format srcvolume\@srccluster
          * Function:VolumeCommands.volumeCreate()
          * Meaning:You must specify the source volume name in the format {{<volume>\@<cluster>}}.
          * Resolution: Check the volume name, the cluster name, and the command syntax, then try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EINVAL, 
        		  "Source volume name is not specified in format " +
        		  "srcvolume@srccluster")
          		  .setField(MIRROR_VOLUME_SRC_VOLUMENAME));          
          return output;        	
        }
        String srcVolumeName = srcVolumeFullName.substring(0, index);
        String srcClusterName = srcVolumeFullName.substring(index + 1, 
        										srcVolumeFullName.length());
        if (srcClusterName == null) {
          /**
          * <MAPR_ERROR>
          * Message:Source volume name <volume name> is not specified in format srcvolume\@srccluster
          * Function:VolumeCommands.volumeCreate()
          * Meaning:You must specify the source volume name in the format {{<volume>\@<cluster>}}.
          * Resolution: Check the volume name, the cluster name, and the command syntax, then try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EINVAL, 
            		"Source volume name " + srcVolumeName + " is " +
            		"not specified in format srcvolume@srccluster")
            		.setField(MIRROR_VOLUME_SRC_VOLUMENAME));
          return output;
        }

        // validate the srcClusterName
        if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(srcClusterName)) {
          /**
          * <MAPR_ERROR>
          * Message:Invalid cluster name <cluster name>
          * Function:VolumeCommands.volumeCreate()
          * Meaning:The specified cluster name is invalid.
          * Resolution:Check the cluster name and the command syntax, and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EINVAL, "Invalid cluster name "
                + srcClusterName) .setField(MIRROR_VOLUME_SRC_VOLUMENAME));
          return output;
        }

        // In the current release we don't support cross cluster mirroring
        // from a secure cluster. So fail the mirror volume creation itself
        // from a source cluster.
        String destClusterName = null;

        if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM))
          destClusterName = getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0);
        else
          destClusterName = CLDBRpcCommonUtils.getInstance()
                                              .getCurrentClusterName();

        if (rwVolumeName.equalsIgnoreCase(srcVolumeName) &&
          destClusterName.equalsIgnoreCase(srcClusterName)) {
          /**
          * <MAPR_ERROR>
          * Message:Invalid cluster name <cluster name>
          * Function:VolumeCommands.UpdateMirrorSourceVolumeName()
          * Meaning:Volume attaching itself as source.
          * Resolution:Check the src volume and cluster name and the command syntax, and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EINVAL, "Specified source "
                 + srcVolumeFullName + " is same as destination")
                   .setField(MIRROR_VOLUME_SRC_VOLUMENAME));
          return output;
        }

        if (destClusterName.equalsIgnoreCase(srcClusterName) == false) {
          boolean isSourceClusterSecure = JNISecurity.IsSecurityEnabled(srcClusterName);
          boolean isDestClusterSecure = JNISecurity.IsSecurityEnabled(destClusterName);
          if (isSourceClusterSecure ^ isDestClusterSecure) {
            out.addError(new OutputError(Errno.EOPNOTSUPP,
                "In cross cluster mirroring, both clusters must be either " +
                "secure or unsecure. Other combination is not allowed."));
            return output;
          }
        }

        MirrorInfo.Builder mirror = MirrorInfo.newBuilder();
        mirror.setSrcVolumeName(srcVolumeName)
              .setSrcClusterName(srcClusterName);
        MirrorInfo destMirrorInfo = mirror.build();
        volProps.setIsMirrorVol(true);
        volProps.setMirrorInfo(destMirrorInfo);
        
        VolumeLookupResponse resp = volumeLookup(srcClusterName,
                                                 getUserCredentials(),
                                                 srcVolumeName,
                                                 null,isServerCall);
        if (resp.hasStatus() && resp.getStatus() != 0) {
          out.addError(new OutputError(Errno.EINVAL,
              "Volume " + srcVolumeName +
              "does not exist in cluster " + srcClusterName));
          return output;
        }
     
        VolumeProperties vProps = resp.getVolInfo().getVolProperties();
        int srcMirrorType = 0;
        if (vProps.hasVolumetype()) 
          srcMirrorType = vProps.getVolumetype()
                                .getNumber();
        boolean oldTypeVol = (srcMirrorType == 0 || srcMirrorType == 1);
        if (oldTypeVol)
          mirrorFlag = 1;
        else
          mirrorFlag = 2;
        volProps.setVolumetype(VolumeType.values()[mirrorFlag]);
      } else {
        if (isParamPresent(VolumeCommands.MIRROR_VOLUME_SRC_VOLUMENAME)) {
          out.addError(new OutputError(Errno.EINVAL,
              "Source cannot be specified for rw volume"));
          return output;
        }
      }
    } else {
      if (isParamPresent(VolumeCommands.MIRROR_VOLUME_SRC_VOLUMENAME)) {
        out.addError(new OutputError(Errno.EINVAL,
            "Source cannot be specified for rw volume"));
        return output;
      }
    }

    // audit volume parameters
    if (isParamPresent(VolumeCommands.AUDIT_VOLUME)) {
      boolean isAuditVolume = getParamBooleanValue(AUDIT_VOLUME, 0);
      volProps.setIsAuditVolume(isAuditVolume);
    }
   
    if (isParamPresent(VolumeCommands.AUDIT_ENABLED)) {
      boolean audited = getParamBooleanValue(AUDIT_ENABLED, 0);
      volProps.setAudited(audited);
    }
   
    if (isParamPresent(VolumeCommands.AUDIT_COALESCE_INTERVAL)) {
      int coalesceInterval = getParamIntValue(AUDIT_COALESCE_INTERVAL, 0);
      if (coalesceInterval < 0) {
        out.addError(new OutputError(Errno.EINVAL,
                      "Coalesce interval cannot be negative"));
        return output;
      }
      // UI currently sends default coalesce interval even if user does not
      // specify, hence to bail out UI
      if (coalesceInterval != volProps.getCoalesceInterval()) {
        volProps.setCoalesceInterval(coalesceInterval);
      }
    }

    List<FSAuditOperations> fsAuditEnableOperations =
      new ArrayList<FSAuditOperations>(); 
    List<FSAuditOperations> fsAuditDisableOperations =
      new ArrayList<FSAuditOperations>(); 

    if (isParamPresent(VolumeCommands.FSAUDIT_OPS)) {
      String fsOperations = getParamTextValue(FSAUDIT_OPS, 0);
      if (!validateAndAddFsOperations(fsAuditEnableOperations,
        fsAuditDisableOperations, fsOperations)) {
        out.addError(new OutputError(Errno.EINVAL,
                    "Invalid dataauditops text specified, text = " +
                    fsOperations));
        return output;
      }
    }

    // validate for "all" option
    if (fsAuditEnableOperations.contains(FSAuditOperations.AuditAll) &&
       (fsAuditEnableOperations.size() > 1)) {
      out.addError(new OutputError(Errno.EINVAL, "When specifying +all, " +
        " cannot enable any other operation"));
      return output;
    }
    if (fsAuditDisableOperations.contains(FSAuditOperations.AuditAll) &&
      (fsAuditDisableOperations.size() > 1)) {
        out.addError(new OutputError(Errno.EINVAL, "When specifying -all, " +
          " cannot disable any other operation"));
      return output;
    }

    if ((fsAuditEnableOperations.size() > 0) &&
       (fsAuditDisableOperations.size() > 0)) {
        out.addError(new OutputError(Errno.EINVAL,
                      "Cannot mix enable and disable dataaudit ops"));
      return output;
    }

    volumeCreate.addAllFsAuditEnableOperations(fsAuditEnableOperations);
    volumeCreate.addAllFsAuditDisableOperations(fsAuditDisableOperations);

    for (FSAuditOperations op: fsAuditEnableOperations)
      LOG.info("Enable Op = " + op.toString());
    for (FSAuditOperations op: fsAuditDisableOperations)
      LOG.info("Disable Op = " + op.toString());

    // Set Volume Mount path regardless of being asked to mount or not
    if (rwVolumeMountDir != null) {
      volProps.setMountDir(rwVolumeMountDir);
    }
    
    if (replPolicy != null) {
      volProps.setReplicationPolicy(replPolicy);
    }
    
    VolumeAces volumeAces = null;
    try {
      volumeAces = buildVolumeAcesProtobuf(volumeAceParameterMap);
    }
    catch (IOException e) {
      LOG.error("Unable to parse volume ace arguments");
      out.addError(new OutputError(Errno.EINVAL,
          "Error Parsing Volume Aces: " + e.getMessage()));
      return output;
    }
    if (volumeAces != null) {
      volumeCreate.setVolumeAces(volumeAces);
    }

    volumeCreate.setVolProperties(volProps.build());
    volumeCreate.setCreds(getUserCredentials());
    
    byte[] data = null;
    try {
      MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
      if (rwVolumeMountDir != null) {
        if (!MapRCliUtil.parentDirExists(fs, cluster, rwVolumeMountDir)) {
        	// If createparent is set, create parent directory
        	if (getParamBooleanValue(RW_VOLUME_PARAM_CREATE_PARENT, 0)) {
        		if (!MapRCliUtil.createParentDir(fs, cluster, rwVolumeMountDir)) {
        			/**
               * <MAPR_ERROR>
               * Message:Volume Mount: Failed to create parent dir for mount path
               * Function:VolumeCommands.volumeMount()
               * Meaning:An error occurred.
               * Resolution:Contact technical support.
               * </MAPR_ERROR>
               */
               LOG.error("Volume Mount: Volume " + rwVolumeName + ", failed to mount, " + 
              		       "could not create parent directory for mount dir " +
                         rwVolumeMountDir);
               /**
               * <MAPR_ERROR>
               * Message:Failed to create parent dir for mount path
               * Function:VolumeCommands.volumeMount()
               * Meaning:An error occurred.
               * Resolution:Contact technical support.
               * </MAPR_ERROR>
               */
               out.addError(new OutputError(Errno.ENOENT, "Failed to mount " + rwVolumeName + 
              		          ", could not create parent directory for mount dir " + 
              		          rwVolumeMountDir));
               return output;
        		}      		
        	} else {
        		/**
             * <MAPR_ERROR>
             * Message:Volume Mount: Volume <volume> parent of mount dir <path> does not exist
             * Function:VolumeCommands.volumeMount()
             * Meaning:An error occurred.
             * Resolution:Contact technical support.
             * </MAPR_ERROR>
             */
             LOG.error("Volume Mount: Volume " + rwVolumeName + " parent of mount dir " +
                       rwVolumeMountDir + " does not exist");
             /**
             * <MAPR_ERROR>
             * Message:Failed to mount <volume name>, parent of mount dir <path> does not exist, <error>
             * Function:VolumeCommands.volumeMount()
             * Meaning:An error occurred.
             * Resolution:Contact technical support.
             * </MAPR_ERROR>
             */
             out.addError(new OutputError(Errno.ENOENT, "Failed to mount " +
            		          rwVolumeName + ", parent of mount dir " + rwVolumeMountDir + 
                          " does not exist, " + Errno.toString(Errno.ENOENT)));
             return output;	
        	}
        }

        if (allowInherit) {
          int parentCid = MapRCliUtil.getParentCid(fs, cluster, rwVolumeMountDir);
          if (parentCid == 0) {
            out.addError(new OutputError(Errno.EINVAL,
                  "Volume Name " + rwVolumeName + ", could not get parent volume cid for mountpath " + rwVolumeMountDir)
                .setField(RW_VOLUME_PARAM_MOUNTDIR));
            return output;
          } else {
            volumeCreate.setParentNamespaceCID(parentCid);
          }
        }
      }
      // Send VolumeCreate Request
      if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
    	  data = CLDBRpcCommonUtils.getInstance().sendRequest(getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0),
    			  Common.MapRProgramId.CldbProgramId.getNumber(),
    	          CLDBProto.CLDBProg
                  .VolumeCreateProc.getNumber(), 
                  volumeCreate.build(), VolumeCreateResponse.class);
      } else {
    	  data = CLDBRpcCommonUtils.getInstance().sendRequest(
    			  Common.MapRProgramId.CldbProgramId.getNumber(),
    			  CLDBProto.CLDBProg
                  .VolumeCreateProc.getNumber(), 
                volumeCreate.build(), VolumeCreateResponse.class);
      }

      if (data == null) {
        /**
        * <MAPR_ERROR>
        * Message:Exception while processing RPC
        * Function:VolumeCommands.volumeCreate()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
    	  out.addError(new OutputError(Errno.ERPCFAILED, "Couldn't connect to the CLDB service"));
    	  return output;
      }  
      
      VolumeCreateResponse resp = VolumeCreateResponse.parseFrom(data);
      int mountStatus = -1;

      if (resp.getStatus() == 0) {
        out.addMessage("Successfully created volume: '" + rwVolumeName + "'");
      }

      if ((resp.getStatus() == 0) && (rwVolumeMountDir != null) && (mount)) {
        mountStatus = fs.mountVolume(cluster, rwVolumeName, 
                                     rwVolumeMountDir, getUserLoginId());
        if (mountStatus != 0) {
          /**
          * <MAPR_ERROR>
          * Message:Volume mount for <mount path> failed, <error>
          * Function:VolumeCommands.volumeCreate()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED, "Volume mount for " + 
              rwVolumeMountDir + " failed, " + Errno.toString(mountStatus))
             .setField(RW_VOLUME_PARAM_NAME).setFieldValue(rwVolumeName));          
          return output;
        }
        if (!getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0) &&
            !sleepAndCheckMountedDir(fs, cluster, rwVolumeMountDir)) {
          /**
          * <MAPR_ERROR>
          * Message:Volume create for <mount path> failed, Could not get status of mount path
          * Function:VolumeCommands.volumeCreate()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED, "Volume create for "
             + rwVolumeMountDir + " failed, Could not get status of mount path")
             .setField(RW_VOLUME_PARAM_NAME).setFieldValue(rwVolumeName));
          return output;
        }
      }
      
      if (resp.getStatus() == 0) {
        return output;
      } else {
        OutputError procssobj = new OutputError(resp.getStatus(), resp.getErrMsg());
        if (resp.getStatus() == Errno.ENOENT) {
          procssobj.setField(RW_VOLUME_PARAM_NAME);
          procssobj.setFieldValue(rwVolumeName);
        } else if ( resp.getStatus() != Errno.ENONOESINTOPOLOGY) {
          procssobj.setPropagateErrorSupport(true);
          procssobj.setField(RW_VOLUME_PARAM_NAME);
          procssobj.setFieldValue(rwVolumeName);
        }
        out.addError(procssobj);
        return output;
      }
    } catch (InvalidProtocolBufferException e) {
      /**
      * <MAPR_ERROR>
      * Message:InvalidProtocolBufferException <error>
      * Function:VolumeCommands.volumeCreate()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      throw new CLIProcessingException("InvalidProtocolBufferException " + e);
    } catch (MaprSecurityException e) {
      throw new CLIProcessingException(
        "MaprSecurityException " + "Exception", e);
    } catch (Exception e) {
      /**
      * <MAPR_ERROR>
      * Message:Send request Exception
      * Function:VolumeCommands.volumeCreate()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      throw new CLIProcessingException("Send request Exception", e);
    }
  }
  
  boolean validateAndAddFsOperations(List <FSAuditOperations> fsAuditEnableOperations,
    List <FSAuditOperations> fsAuditDisableOperations,
    String fsOperations) 
  {
    // first op is a disable and arg value begins with "--"
    if (fsOperations.charAt(0) == '-') {
      if (fsOperations.length() <= 1) return false;
      fsOperations = fsOperations.substring(1, fsOperations.length());
    }
    fsOperations = fsOperations.toLowerCase();
    String[] tokens = fsOperations.split("[,]");
    for (int i = 0; i < tokens.length; i++) {
      List <FSAuditOperations> list = null;
      String next = tokens[i];
      if (next.length() == 0) return false;
      String op = null;
      char first = next.charAt(0);
      if (first == '+') {
        list = fsAuditEnableOperations;
        op = next.substring(1, next.length());
      } else if (first == '-') {
        list = fsAuditDisableOperations;
        op = next.substring(1, next.length());
      } else {
        list = fsAuditEnableOperations;
        op = next; // could be enable without a '+' prefix
      }
      if (op.length() == 0) return false;

      if (op.equals("all")) list.add(FSAuditOperations.AuditAll);
      else if (op.equals("getattr")) list.add(FSAuditOperations.AuditGetattr);
      else if (op.equals("setattr")) {
          list.add(FSAuditOperations.AuditSetattr);
          list.add(FSAuditOperations.AuditChown);
          list.add(FSAuditOperations.AuditChperm);
          list.add(FSAuditOperations.AuditChgrp);
      } else if (op.equals("chown")) list.add(FSAuditOperations.AuditChown);
      else if (op.equals("chperm")) list.add(FSAuditOperations.AuditChperm);
      else if (op.equals("chgrp")) list.add(FSAuditOperations.AuditChgrp);
      else if (op.equals("getxattr")) list.add(FSAuditOperations.AuditGetxattr);
      else if (op.equals("listxattr")) list.add(FSAuditOperations.AuditListxattr);
      else if (op.equals("setxattr")) list.add(FSAuditOperations.AuditSetxattr);
      else if (op.equals("removexattr")) list.add(FSAuditOperations.AuditRemovexattr);
      else if (op.equals("getperm")) list.add(FSAuditOperations.AuditGetperm);
      else if (op.equals("read"))  list.add(FSAuditOperations.AuditRead);
      else if (op.equals("write")) list.add(FSAuditOperations.AuditWrite);
      else if (op.equals("create")) list.add(FSAuditOperations.AuditCreate);
      else if (op.equals("mkdir")) list.add(FSAuditOperations.AuditMkdir);
      else if (op.equals("delete")) list.add(FSAuditOperations.AuditDelete);
      else if (op.equals("rmdir")) list.add(FSAuditOperations.AuditRmdir);
      else if (op.equals("readdir")) list.add(FSAuditOperations.AuditReaddir);
      else if (op.equals("createsym")) list.add(FSAuditOperations.AuditCreatesym);
      else if (op.equals("lookup")) list.add(FSAuditOperations.AuditLookup);
      else if (op.equals("rename")) list.add(FSAuditOperations.AuditRename);
      else if (op.equals("createdev")) list.add(FSAuditOperations.AuditCreatedev);
      else if (op.equals("truncate")) list.add(FSAuditOperations.AuditTruncate);
      else if (op.equals("getpathforfid")) list.add(FSAuditOperations.AuditGetpathforfid);
      else if (op.equals("tablecfcreate")) list.add(FSAuditOperations.AuditDbCfcreate);
      else if (op.equals("tablecfdelete")) list.add(FSAuditOperations.AuditDbCfdelete);
      else if (op.equals("tablecfmodify")) list.add(FSAuditOperations.AuditDbCfmodify);
      else if (op.equals("tablecfscan")) list.add(FSAuditOperations.AuditDbCfscan);
      else if (op.equals("tableget")) list.add(FSAuditOperations.AuditDbGet);
      else if (op.equals("tableput")) list.add(FSAuditOperations.AuditDbPut);
       else if (op.equals("tablescan")) list.add(FSAuditOperations.AuditDbScan);
       else if (op.equals("tablecreate")) list.add(FSAuditOperations.AuditDbTablecreate);
       else if (op.equals("tablemodify")) list.add(FSAuditOperations.AuditDbTablemodify);
       else if (op.equals("tableinfo")) list.add(FSAuditOperations.AuditDbTableinfo);
       else if (op.equals("hardlink")) list.add(FSAuditOperations.AuditHardLink);
      else return false;
    }
    return true;
  }

  CommandOutput volumeRename() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);
    
    // Do some checks on old volume name
    String volumeName = 
      getRwVolumeName();    
    VolumeProperties volProps = this.volumePropetiesLookup(volumeName);
    if (volProps == null) {
      // Make sure old volume exists
      /**
      * <MAPR_ERROR>
      * Message:Volume rename failed, could not fetch properties for volume <volume name> <error>
      * Function:VolumeCommands.volumeRename()
      * Meaning:The specified volume could not be found.
      * Resolution:Check the volume name and the command syntax, then try again.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.ENOENT, 
                           "Volume rename failed, could not fetch properties for volume " + 
                           volumeName + ", " + 
                           Errno.toString(Errno.ENOENT)));
      /**
      * <MAPR_ERROR>
      * Message:VolumeRename : Could not find volume properties for <volume name>
      * Function:VolumeCommands.volumeRename()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      LOG.error("VolumeRename : Could not find volume properties for " + 
                  volumeName);
      return output;
    }
    
    // Do some checks on new volume name
    String newVolumeName = 
      getParamTextValue(VolumeCommands.RW_VOLUME_PARAM_NEW_NAME, 0);
    if (volumeName.equals(newVolumeName)) {
      // Check if old volume name and new volume name are the same	
      /**
      * <MAPR_ERROR>
      * Message:Volume rename failed, Volume <volume name> same as old volume name
      * Function:VolumeCommands.volumeRename()
      * Meaning:When re-naming a volume, you must specify a new name that is different
      * from the existing name.
      * Resolution:Choose a new volume name and try again
      * </MAPR_ERROR>
      */    
      out.addError(new OutputError(Errno.ENOENT, 
          "Volume rename failed, Volume " + newVolumeName + " same as old volume name"));
      /**
      * <MAPR_ERROR>
      * Message:VolumeRename : Volume <volume name> same as old volume name
      * Function:VolumeCommands.volumeRename()
      * Meaning:When re-naming a volume, you must specify a new name that is different
      * from the existing name.
      * Resolution:Choose a new volume name and try again.
      * </MAPR_ERROR>
      */
      LOG.error("VolumeRename : Volume " + newVolumeName + " same as old volume name");
      return output;
    }
    // Check to see if name length exceeds
    if (!VolumeUtils.isValidVolumeNameLength(newVolumeName)) {
      /**
      * <MAPR_ERROR>
      * Message:Invalid Volume Name <volume name>, Exceeds allowed length of <number> characters
      * Function:VolumeCommands.volumeRename()
      * Meaning:The specified volume name is too long.
      * Resolution:Choose a shorter volume name and try again.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EINVAL,
          "Invalid Volume Name " + newVolumeName +
          ", Exceeds allowed length of " + 
          VolumeUtils.validVolumeNameLength() + " characters")
            .setField(RW_VOLUME_PARAM_NEW_NAME));      
      return output;
    }
    
    if (!VolumeUtils.isValidVolumeName(newVolumeName)) {
      // Check if it is a valid volume name
      /**
      * <MAPR_ERROR>
      * Message:Invalid Volume Name  Allowed characters <characters>
      * Function:VolumeCommands.volumeRename()
      * Meaning:The specified volume name is invalid because it contains characters that are not allowed.
      * Resolution:Choose a different volume name and try again.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EINVAL,
                   "Invalid Volume Name " +
                   " Allowed characters " + VolumeUtils.getValidName())
                     .setField(RW_VOLUME_PARAM_NEW_NAME));
      return output;
    }
    VolumeProperties newVolProps = this.volumePropetiesLookup(newVolumeName);
    if (newVolProps != null) {
      // Make sure the new volume doesn't exist
      // We need this extra call, even though CLDB does this check itself, because 
      // we are unmounting old volume before renaming..So we don't want to unmount if
      // New volume already exists
      /**
      * <MAPR_ERROR>
      * Message:Volume rename failed, Volume <volume name> already exists 
      * Function:VolumeCommands.volumeRename()
      * Meaning:The specified volume name already exists.
      * Resolution:Choose a different volume name and try again.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.ENOENT, 
                         "Volume rename failed, Volume " + newVolumeName + " already exists "));
      /**
      * <MAPR_ERROR>
      * Message:VolumeRename : Volume <volume name> already exists
      * Function:VolumeCommands.volumeRename()
      * Meaning:The specified volume name already exists.
      * Resolution:Choose a different volume name and try again.
      * </MAPR_ERROR>
      */
      LOG.error("VolumeRename : Volume " + newVolumeName + " already exists");
      return output;
    }
    
    boolean wasMounted = false;
    if (LOG.isDebugEnabled())
      LOG.debug("Trying to rename volume " + volumeName + 
          " to new name " + newVolumeName);
    // Lookup volume
    
    VolumeRenameRequest volumeRename = 
                    VolumeRenameRequest.newBuilder().setVolumeName(volumeName)
                    .setCreds(getUserCredentials())
                    .setNewVolumeName(newVolumeName)
                    .build();
            
    MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
    String cluster = null;
    if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
      cluster = getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM, 0);
    }
    
    if (volProps.getMounted()) {
      wasMounted = true;
      if (LOG.isInfoEnabled())
        LOG.info("Volume " + volumeName + " is mounted at " +
                 volProps.getMountDir() + 
                 ". Trying to unmount before renaming");
      
      String volumeMountDir = volProps.getMountDir();
      FidMsg parentFid = volProps.getParentFid();
      int status = fs.unmountVolume(
              cluster,
              volumeName,
              volumeMountDir,
              getUserLoginId(),
              parentFid.getCid(),
              parentFid.getCinum(),
              parentFid.getUniq());

      if (status != 0) {
        /**
        * <MAPR_ERROR>
        * Message:Volume Unmount before rename failed : <error>
        * Function:VolumeCommands.volumeRename()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(status, "Volume " +
        		"Unmount before rename failed : " + 
            Errno.toString(status)));
        /**
        * <MAPR_ERROR>
        * Message:Volume unmount <volume name> before rename failed, <error>
        * Function:VolumeCommands.volumeRename()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        LOG.error("Volume unmount "+ volumeName + " before rename" +
            " failed, " + Errno.toString(status));        
        return output;
      } else {
        if (LOG.isInfoEnabled())
          LOG.info("Volume unmount " + volumeName + " successful before rename");
        if (!getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0)) {
          try {
            Thread.sleep(VOLUME_OP_DELAY * 1000);
          } catch (InterruptedException e) {
          }
        }        
      }
    }
    if (LOG.isDebugEnabled())
      LOG.debug("Renaming volume " + volumeName + " to new name " + newVolumeName);
    byte[] data = null;
    try {
        if ( isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
      	  data = CLDBRpcCommonUtils.getInstance()
      	               .sendRequest(getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0),
      			                        Common.MapRProgramId.CldbProgramId.getNumber(),
      			                        CLDBProto.CLDBProg.VolumeRenameProc.getNumber(), 
      			                        volumeRename, 
      			                        VolumeRenameResponse.class);
        } else {
      	  data = CLDBRpcCommonUtils.getInstance().sendRequest(
      			  Common.MapRProgramId.CldbProgramId.getNumber(),
      			CLDBProto.CLDBProg
                .VolumeRenameProc.getNumber(), volumeRename, VolumeRenameResponse.class);
        }

      if (data == null) {
        /**
        * <MAPR_ERROR>
        * Message:Exception while processing RPC
        * Function:VolumeCommands.volumeRename()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
    	  out.addError(new OutputError(Errno.ERPCFAILED, "Couldn't connect to the CLDB service"));
    	  return output;
      }  
      VolumeRenameResponse resp = VolumeRenameResponse.parseFrom(data);
      if (resp.getStatus() == 0) {
        if (LOG.isInfoEnabled())
          LOG.info("Renamed volume " + volumeName + " to new name "+
              newVolumeName);
      } else {
        /**
        * <MAPR_ERROR>
        * Message:Volume Rename: <error>
        * Function:VolumeCommands.volumeRename()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(resp.getStatus(), "Volume Rename: " + 
            Errno.toString(resp.getStatus())));
        /**
        * <MAPR_ERROR>
        * Message:Rename of volume failed, <error>
        * Function:VolumeCommands.volumeRename()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        LOG.error("Rename of volume failed, " + Errno.toString(resp.getStatus()));
        return output;
      }
      
    } catch (MaprSecurityException e) {
      throw new CLIProcessingException(
        "MaprSecurityException " + "Exception", e);
    } catch (Exception e) {
      /**
      * <MAPR_ERROR>
      * Message:Volume Rename:  Operation failed
      * Function:VolumeCommands.volumeRename()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EOPFAILED, "Volume Rename: " +
          " Operation failed"));
      /**
      * <MAPR_ERROR>
      * Message:Exception during volume rename <error>
      * Function:VolumeCommands.volumeRename()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      LOG.error("Exception during volume rename " + e);
      return output;
    }
    if (wasMounted) {
      // Now remount volume
      if (LOG.isInfoEnabled())
        LOG.info("Volume " + newVolumeName + 
                 ". Trying to mount after renaming from " + volumeName);
      String volumeMountDir = volProps.getMountDir();
      int status = fs.mountVolume(cluster, newVolumeName, volumeMountDir, getUserLoginId());
      if (status != 0) {
        /**
        * <MAPR_ERROR>
        * Message:"Volume mount after rename failed : <error>
        * Function:VolumeCommands.volumeRename()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(status, "Volume " +
            "mount after rename failed : " + 
            Errno.toString(status)));
        /**
        * <MAPR_ERROR>
        * Message:Volume mount <volume name> after rename failed, <error>
        * Function:VolumeCommands.volumeRename()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        LOG.error("Volume mount "+ newVolumeName + " after rename" +
            " failed, " + Errno.toString(status));
        return output;
      } else {
        if (LOG.isInfoEnabled())
          LOG.info("Volume Mount " + volumeName + " successful after rename");
        if (!getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0) &&
            !sleepAndCheckMountedDir(fs, cluster, volumeMountDir)) {
          /**
          * <MAPR_ERROR>
          * Message:Volume rename for <mount path> failed, Could not get status of mount path
          * Function:VolumeCommands.volumeRename()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED, "Volume rename for "
              + volumeMountDir + " failed, Could not get status of mount path")
             .setField(RW_VOLUME_PARAM_NAME).setFieldValue(newVolumeName));
          return output;
        }
      }    
    }    
    return output;
  }

  CommandOutput volumeUpgradeformat() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);

    String rwVolumeName = 
      getRwVolumeName();
    List<String> volumeNames = new ArrayList<String>();
    if (!rwVolumeName.contains(MULTI_ARG_SEP)) {
      volumeNames.add(rwVolumeName);
    } else if (rwVolumeName.contains(MULTI_ARG_SEP)) {
      volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
    }

    for (String volumeName : volumeNames) {
      VolumeProperties volProps = this.volumePropetiesLookup(volumeName);
      if (volProps == null) {
        // Make sure old volume exists
        /**
         * <MAPR_ERROR>
         * Message:Volume upgradeformat failed, could not fetch properties for volume <volume name> <error>
         * Function:VolumeCommands.volumeUpgradeformat()
         * Meaning:The specified volume could not be found.
         * Resolution:Check the volume name and the command syntax, then try again.
         * </MAPR_ERROR>
         */
        out.addError(new OutputError(Errno.ENOENT, 
              "Volume upgradeformat failed, could not fetch properties for " +
              "volume " + volumeName + ", " + 
              Errno.toString(Errno.ENOENT)));
        /**
         * <MAPR_ERROR>
         * Message:VolumeUpgradeformat : Could not find volume properties for <volume name>
         * Function:VolumeCommands.volumeUpgradeformat()
         * Meaning:An error occurred.
         * Resolution:Contact technical support.
         * </MAPR_ERROR>
         */
        LOG.error("VolumeUpgradeformat : Could not find volume properties for " + 
            volumeName);
        continue;
      }

      if (volProps.getVolumetype() != VolumeType.VTRW) {
        /**
         * <MAPR_ERROR>
         * Message:Volume upgradeformat failed, can not upgrade the format of volume <volume name> <error>
         * Function:VolumeCommands.volumeUpgradeformat()
         * Meaning:The specified volume can not be upgraded to new format.
         * Resolution:Check the volume name and the command syntax, then try again.
         * </MAPR_ERROR>
         */
        if (volProps.getVolumetype() == VolumeType.VTMirror || 
            volProps.getVolumetype() == VolumeType.VTRwConvertibleMirror) {
          out.addError(new OutputError(Errno.EINVAL, 
                "Volume upgradeformat failed: " + 
                volumeName + " mirror volumes can not be upgraded to new format. " + 
                Errno.toString(Errno.EINVAL)));
        } else {
          out.addError(new OutputError(Errno.EINVAL, 
                "Volume upgradeformat failed: " + 
                volumeName + " is already in new type. " + 
                Errno.toString(Errno.EINVAL)));
        }
        /**
         * <MAPR_ERROR>
         * Message:VolumeRename : can not upgradeformat <volume name>
         * Function:VolumeCommands.volumeUpgradeformat()
         * Meaning:An error occurred.
         * Resolution:Contact technical support.
         * </MAPR_ERROR>
         */
        LOG.error("VolumeUpgradeformat : Can not upgrade the format of volume " + 
            volumeName);
        continue;
      }

      VolumePromoteRequest volumePromote =
        VolumePromoteRequest.newBuilder().setVolumeName(volumeName)
        .setCreds(getUserCredentials())
        .build();

      if (LOG.isDebugEnabled())
        LOG.debug("Promoting volume " + volumeName);
      byte[] data = null;
      try {
        if ( isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
          data = CLDBRpcCommonUtils.getInstance()
            .sendRequest(getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0),
                Common.MapRProgramId.CldbProgramId.getNumber(),
                CLDBProto.CLDBProg.VolumePromoteProc.getNumber(), 
                volumePromote, 
                VolumePromoteResponse.class);
        } else {
          data = CLDBRpcCommonUtils.getInstance().sendRequest(
              Common.MapRProgramId.CldbProgramId.getNumber(),
              CLDBProto.CLDBProg
              .VolumePromoteProc.getNumber(), volumePromote, VolumePromoteResponse.class);
        }

        if (data == null) {
          /**
           * <MAPR_ERROR>
           * Message:Exception while processing RPC
           * Function:VolumeCommands.volumeUpgrageformat()
           * Meaning:An error occurred.
           * Resolution:Contact technical support.
           * </MAPR_ERROR>
           */
          out.addError(new OutputError(Errno.ERPCFAILED, "Couldn't connect to the CLDB service"));
          return output;
        }  
        VolumePromoteResponse resp = VolumePromoteResponse.parseFrom(data);
        if (resp.getStatus() == 0) {
          if (LOG.isInfoEnabled())
            LOG.info("Upgraded volume " + volumeName + " to new format");
        } else {
          /**
           * <MAPR_ERROR>
           * Message:Volume Upgradeformat: <error>
           * Function:VolumeCommands.volumeUpgradeformat()
           * Meaning:An error occurred.
           * Resolution:Contact technical support.
           * </MAPR_ERROR>
           */
          if(resp.hasErrMsg()){
            out.addError(new OutputError(resp.getStatus(),"Volume upgradeformat failed, for volume " + volumeName + ", "+resp.getErrMsg()));
          } else {
            out.addError(new OutputError(resp.getStatus(),
                "Volume Upgradeformat: " + 
                Errno.toString(resp.getStatus())));
          }

          /**
           * <MAPR_ERROR>
           * Message:Upgrade of volume to new format failed, <error>
           * Function:VolumeCommands.volumeUpgradeformat()
           * Meaning:An error occurred.
           * Resolution:Contact technical support.
           * </MAPR_ERROR>
           */
          LOG.error("Upgrade of volume to new format failed, " + Errno.toString(resp.getStatus()));
          continue;
        }

      } catch (MaprSecurityException e) {
        throw new CLIProcessingException(
            "MaprSecurityException " + "Exception", e);
      } catch (Exception e) {
        /**
         * <MAPR_ERROR>
         * Message:Volume Upgradeformat:  Operation failed
         * Function:VolumeCommands.volumeUpgradeformat()
         * Meaning:An error occurred.
         * Resolution:Contact technical support.
         * </MAPR_ERROR>
         */
        out.addError(new OutputError(Errno.EOPFAILED, "Volume Upgradeformat: " +
              " Operation failed"));
        /**
         * <MAPR_ERROR>
         * Message:Exception during volume upgradeformat <error>
         * Function:VolumeCommands.volumeUpgradeformat()
         * Meaning:An error occurred.
         * Resolution:Contact technical support.
         * </MAPR_ERROR>
         */
        LOG.error("Exception during volume upgradeformat " + e);
        continue;
      }
    } //for loop

    return output;
  }
  
  CommandOutput removeFilteredVolumes() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);
    
    boolean forceRemove = false;
    if (isParamPresent(RW_VOLUME_PARAM_FORCE)) {
      forceRemove = getParamBooleanValue(RW_VOLUME_PARAM_FORCE, 0);
    }
    String cluster = null;
    if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
      cluster = getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM, 0);
    }
    
    this.list(new OutputHierarchy()); // the output of list command is temporarily cached in this.volumes

    if (this.listedVolumes.size() > 0) {
      List<Task> tasks = Lists.newArrayList();
      for (VolumeInfo volume : this.listedVolumes) {
        VolumeProperties volProps = volume.getVolProperties();
        VolumeRemoveTask removeTask = new VolumeRemoveTask(volProps, forceRemove, getUserCredentials(), cluster);
        if (volProps.getMounted()) {
          removeTask.setDependencies(new VolumeUnMountTask(volProps, cluster, getUserLoginId()));
        }
        tasks.add(removeTask);
      }
      TaskCompletionService service = TaskCompletionService.getInstance();
      service.submitTasks(tasks);
      service.fetchResults(); // block until all results are fetched.
      this.listedVolumes.clear(); // clear out the cache
    }
    
    output.setOutput(out);
    return output;
  }
    
  CommandOutput volumeRemove() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);
    String rwVolumeName = getRwVolumeName();

    List<String> volumeNames = new ArrayList<String>();
    if (rwVolumeName.contains(MULTI_ARG_SEP)) {
      volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
    } else {
      volumeNames.add(rwVolumeName);
    }
    
    boolean forceRemove = false;
    if (isParamPresent(RW_VOLUME_PARAM_FORCE)) {
      forceRemove = getParamBooleanValue(RW_VOLUME_PARAM_FORCE, 0);
    }
    
    MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
    String cluster = null;
    if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
      cluster = getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM, 0);
    }

    boolean unmountedOne = false;

    for (String volumeName : volumeNames) {
      if (LOG.isDebugEnabled())
        LOG.debug("Trying to remove volume " + volumeName);
      // Lookup volume
      
      VolumeRemoveRequest volumeRemove = 
                      VolumeRemoveRequest.newBuilder().setVolumeName(volumeName)
                      .setCreds(getUserCredentials())
                      .setForceRemove(forceRemove)
                      .build();
      VolumeProperties volProps = this.volumePropetiesLookup(volumeName, false);
      if (volProps == null) {
        /**
        * <MAPR_ERROR>
        * Message:Volume Remove: <error>
        * Function:VolumeCommands.volumeRemove()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.ENOENT, "Volume Remove: " + 
            Errno.toString(Errno.ENOENT)));
        /**
        * <MAPR_ERROR>
        * Message:VolumeRemove : Could not find volume properties for <volume name>
        * Function:VolumeCommands.volumeRemove()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        LOG.error("VolumeRemove : Could not find volume properties for " + 
                    volumeName);
        continue;
      }
      if ((volProps.getNumSnapshots()) > 0 &&(!forceRemove)) {
        /**
        * <MAPR_ERROR>
        * Message:Volume Remove: <error> Volume has <number> Snapshots. Please use -force option to remove Volume and Snapshots
        * Function:VolumeCommands.volumeRemove()
        * Meaning:You cannot remove a volume that has snapshots unless you use the {{-force}} option.
        * Resolution:Check the command syntax and try again..
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.ENOTEMPTY, "Volume Remove: " +
            Errno.toString(Errno.ENOTEMPTY) + " Volume has " + 
                volProps.getNumSnapshots() + " Snapshots. " +
                		"Please use -force option to remove Volume and Snapshots"));
        /**
        * <MAPR_ERROR>
        * Message:VolumeRemove: Volume has <number> snapshot(s)" + " Use -force option to remove snapshots and volume
        * Function:VolumeCommands.volumeRemove()
        * Meaning:You cannot remove a volume that has snapshots unless you use the {{-force}} option.
        * Resolution:Check the command syntax and try again.
        * </MAPR_ERROR>
        */
        LOG.error("VolumeRemove: Volume has " + volProps.getNumSnapshots() +
            "snapshot(s)" + " Use -force option to remove snapshots and volume");
        continue;
      }
      if (volProps.getMounted()) {
        if (LOG.isInfoEnabled())
          LOG.info("Volume " + volumeName + " is mounted at " +
                   volProps.getMountDir() + 
                   ". Trying to unmount before removing");
        
        String volumeMountDir = volProps.getMountDir();
        FidMsg parentFid = volProps.getParentFid();
        
        int status = fs.unmountVolume(
                cluster,
                volumeName,
                volumeMountDir,
                getUserLoginId(),
                parentFid.getCid(),
                parentFid.getCinum(),
                parentFid.getUniq());

        if (status != 0) {
          /**
          * <MAPR_ERROR>
          * Message:Volume UnMount: <error>
          * Function:VolumeCommands.volumeRemove()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(status, "Volume UnMount: " + 
              Errno.toString(status)));
          /**
          * <MAPR_ERROR>
          * Message:Volume unmount <volume name> before remove failed, <error>
          * Function:VolumeCommands.volumeRemove()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          LOG.error("Volume unmount "+ volumeName + " before remove" +
              " failed, " + Errno.toString(status));
          continue;
        } else {
          unmountedOne = true;
          if (LOG.isInfoEnabled())
            LOG.info("Volume unmount " + volumeName + " successful before remove");
        }
      }
      if (LOG.isDebugEnabled())
        LOG.debug("Removing volume " + volumeName);
      byte[] data = null;
      try {
          if ( isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
        	  data = CLDBRpcCommonUtils.getInstance().sendRequest(getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0),
        			  Common.MapRProgramId.CldbProgramId.getNumber(),
        			  CLDBProto.CLDBProg
                      .VolumeRemoveProc.getNumber(), 
                    volumeRemove, VolumeRemoveResponse.class);
          } else {
        	  data = CLDBRpcCommonUtils.getInstance().sendRequest(
        			  Common.MapRProgramId.CldbProgramId.getNumber(),
        			  CLDBProto.CLDBProg
                      .VolumeRemoveProc.getNumber(), 
                    volumeRemove, VolumeRemoveResponse.class);
          }

        if (data == null) {
          /**
          * <MAPR_ERROR>
          * Message:Exception while processing RPC
          * Function:VolumeCommands.volumeRemove()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
        	out.addError(new OutputError(Errno.ERPCFAILED, "Couldn't connect to the CLDB service"));
        	return output;
        }  
        VolumeRemoveResponse resp = VolumeRemoveResponse.parseFrom(data);
        if (resp.getStatus() == 0) {
          if (LOG.isInfoEnabled())
            LOG.info("Removed volume " + volumeName);
          continue;
        } else {
          /**
          * <MAPR_ERROR>
          * Message:Volume Remove: <error>
          * Function:VolumeCommands.volumeRemove()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(resp.getStatus(), "Volume Remove: " + 
              Errno.toString(resp.getStatus())));
          /**
          * <MAPR_ERROR>
          * Message:Remove volume failed, <error>
          * Function:VolumeCommands.volumeRemove()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          LOG.error("Remove volume failed, " + Errno.toString(resp.getStatus()));
          continue;
        }
      } catch (MaprSecurityException e) {
        throw new CLIProcessingException(
          "MaprSecurityException " + "Exception", e);
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Volume Remove:  Operation failed
        * Function:VolumeCommands.volumeRemove()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EOPFAILED, "Volume Remove: " +
            " Operation failed"));
        /**
        * <MAPR_ERROR>
        * Message:Exception during volume remove <error>
        * Function:VolumeCommands.volumeRemove()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        LOG.error("Exception during volume remove " + e);
        continue;
      }
    }
    
    if (unmountedOne && !getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0)) {
      try {
        Thread.sleep(VOLUME_OP_DELAY * 1000);
      } catch (InterruptedException e) {
      }
    }
    
    output.setOutput(out);
    return output;
  }
  
  CommandOutput volumeMove() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);
    String volumeName =
      getRwVolumeName();
    
    String topology = getParamTextValue(VolumeCommands
                            .RW_VOLUME_PARAM_TOPOLOGY, 0);
    if (LOG.isDebugEnabled())
      LOG.debug("Trying to move volume " + volumeName);
    
    VolumeTopology topo = VolumeTopology.newBuilder()
                            .setTopologyRestricted(topology)
                            .build();
    VolumeMoveRequest volumeMove = VolumeMoveRequest.newBuilder()
                                      .setVolumeName(volumeName)
                                      .setCreds(getUserCredentials())
                                      .setNewTopology(topo)
                                      .build();
    
    if (topology.equals("") || !topology.startsWith("/")) {
      /**
      * <MAPR_ERROR>
      * Message:Volume Move: <error> Invalid topology specified
      * Function:VolumeCommands.volumeMove()
      * Meaning:An involuntary topology was specified. Topology must start with a forward slash.
      * Resolution:Check the topology and the command syntas, and try again.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EINVAL, "Volume Move: " +
          Errno.toString(Errno.EINVAL) + " Invalid topology specified"));
      /**
      * <MAPR_ERROR>
      * Message:VolumeMove: VolumeName: <volume name> Invalid topology <topology> specified
      * Function:VolumeCommands.volumeMove()
      * Meaning:An involuntary topology was specified. Topology must start with a forward slash.
      * Resolution:Check the topology and the command syntas, and try again.
      * </MAPR_ERROR>
      */
      LOG.error("VolumeMove: VolumeName: " + volumeName + 
          " Invalid topology " + topology + " specified");      
      return output;
    }
    byte[] data = null;
    try {
        if ( isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
      	  data = CLDBRpcCommonUtils.getInstance().sendRequest(getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0),
      			  Common.MapRProgramId.CldbProgramId.getNumber(),
      			CLDBProto.CLDBProg
                .VolumeMoveProc.getNumber(), 
              volumeMove, VolumeMoveResponse.class);
        } else {
      	  data = CLDBRpcCommonUtils.getInstance().sendRequest(
      			  Common.MapRProgramId.CldbProgramId.getNumber(),
      			CLDBProto.CLDBProg
                .VolumeMoveProc.getNumber(), 
              volumeMove, VolumeMoveResponse.class);
        }

      if (data == null) {
        /**
        * <MAPR_ERROR>
        * Message:Exception while processing RPC
        * Function:VolumeCommands.volumeMove()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
    	  out.addError(new OutputError(Errno.ERPCFAILED, "Couldn't connect to the CLDB service"));
    	  return output;
      }  
      VolumeMoveResponse resp = VolumeMoveResponse.parseFrom(data);
      if (resp.getStatus() == 0) {
        if (LOG.isInfoEnabled())
          LOG.info("VolumeMove: Volumenaem: " + volumeName +
              " Updated topology");
        
      } else {
        /**
        * <MAPR_ERROR>
        * Message:Volume Move: <error>
        * Function:VolumeCommands.volumeMove()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(resp.getStatus(), "Volume Move: " + 
            Errno.toString(resp.getStatus())));
        /**
        * <MAPR_ERROR>
        * Message:Volume move failed, <error>
        * Function:VolumeCommands.volumeMove()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        LOG.error("Volume move failed, " + Errno.toString(resp.getStatus()));        
        return output;
      }
    } catch (MaprSecurityException e) {
      throw new CLIProcessingException(
        "MaprSecurityException " + "Exception", e);
    } catch (Exception e) {
      /**
      * <MAPR_ERROR>
      * Message:Volume Move:  Operation failed
      * Function:VolumeCommands.volumeMove()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EOPFAILED, "Volume Move: " +
          " Operation failed"));
      /**
      * <MAPR_ERROR>
      * Message:Exception during volume move <error>
      * Function:VolumeCommands.volumeMove()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      LOG.error("Exception during volume move " + e);      
      return output;
    }
        
    return output;
  }
  
  public static VolumeLookupResponse volumeLookup (String cluster, CredentialsMsg creds, 
                                                   String name, String path, boolean isServerCall) 
         throws CLIProcessingException {
    
    byte[] data = null;
    VolumeLookupRequest volumeInfo = null;
    
    if (name != null)
      volumeInfo = VolumeLookupRequest.newBuilder()
                                      .setVolumeName(name)
                                      .setCreds(creds)
                                      .build();
    else
      volumeInfo = VolumeLookupRequest.newBuilder()
                                      .setMountDir(path)
                                      .setCreds(creds)
                                      .build();
    
    try {
      if (cluster != null) {
        data = CLDBRpcCommonUtils.getInstance().sendRequest(
            cluster,
            Common.MapRProgramId.CldbProgramId.getNumber(),
            CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), 
            volumeInfo, 
            VolumeLookupResponse.class, getKeyType(cluster, isServerCall));
      } else {
        data = CLDBRpcCommonUtils.getInstance().sendRequest(
            Common.MapRProgramId.CldbProgramId.getNumber(),
            CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), 
            volumeInfo, 
            VolumeLookupResponse.class);
      }

      if (data == null) {
        /**
         * <MAPR_ERROR>
         * Message:Exception while processing RPC
         * Function:VolumeCommands.volumeLookup()
         * Meaning:An error occurred.
         * Resolution:Contact technical support.
         * </MAPR_ERROR>
         */
        throw new CLIProcessingException("Exception while processing RPC");
      }  
      return VolumeLookupResponse.parseFrom(data);
    } catch (MaprSecurityException e) {
      throw new CLIProcessingException(
        "MaprSecurityException " + "Exception", e);
    } catch (Exception e) {
      /**
      * <MAPR_ERROR>
      * Message:Exception doing volume Lookup to CLDB <error>
      * Function:VolumeCommands.volumeLookup()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      throw new CLIProcessingException("Exception doing volume Lookup to CLDB, " + 
      		e.getLocalizedMessage());
    }
  }
  
  /**
   * Called in response to the command 'maprcli volume info'
   * 
   * @return
   * @throws CLIProcessingException
   */
  CommandOutput volumeInfo() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);
    String rwVolumeName = null;
    String rwMountDir = null;
    
    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_NAME))
      rwVolumeName =
        getRwVolumeName();
    if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MOUNTDIR))
      rwMountDir = 
        getParamTextValue(VolumeCommands.RW_VOLUME_PARAM_MOUNTDIR, 0);
    
    if ((rwVolumeName == null) && (rwMountDir == null)) {
      /**
      * <MAPR_ERROR>
      * Message:Volume info arguments missing. Pass either volumename or mountdir
      * Function:VolumeCommands.volumeInfo()
      * Meaning:You must specify either a volume name or a mount directory.
      * Resolution:Check the command syntax and try again.
      * </MAPR_ERROR>
      */
      out.addMessage(getCommandUsage());
      out.addError(new OutputError(Errno.EMISSING, "Volume info arguments missing. " +
                      "Pass either volumename or mountdir"));      
      return output;
    }
    if ((rwVolumeName != null) && (rwMountDir != null)) {
      /**
      * <MAPR_ERROR>
      * Message:Volume info has both volumename and mountdir. Pass only one
      * Function:VolumeCommands.volumeInfo()
      * Meaning:You cannot specify both a volume name and a mount directory.
      * Resolution:Check the command syntax and try again.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EMISSING, "Volume info has both volumename " +
                      "and mountdir. Pass only one"));      
      return output;
    }
    
    String cluster = null;
    if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM))
      cluster = getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM, 0);
    
    VolumeLookupResponse resp = volumeLookup(cluster, getUserCredentials(), 
                                             rwVolumeName, rwMountDir,isServerCall);
    if (resp.getStatus() == 0) {
      String opParam = getOutputParamValue();
      boolean terse = opParam.equals("terse");
      BitSet columns = getColumns();
      addVolumeInfo(resp.getVolInfo(), terse, columns, out);
    } else {
      /**
      * <MAPR_ERROR>
      * Message:Volume lookup of <volume name> failed, <error>
      * Function:VolumeCommands.volumeInfo()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(resp.getStatus(), "Volume lookup of " + 
      		      (rwVolumeName != null ? rwVolumeName : rwMountDir) +
                      " failed, " +
      		      ((resp.getStatus() == Errno.ENOENT) ? 
            		"No such volume" : Errno.toString(resp.getStatus())))
          .setPropagateErrorSupport(true)
         .setField(RW_VOLUME_PARAM_NAME).setFieldValue(rwVolumeName));
    }
    return output;    
  }
  
  @Override
  public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
    VolumeListRequest.Builder newReqBuilder = null;
    if (prevReq != null) {
      newReqBuilder = VolumeListRequest.newBuilder((VolumeListRequest) prevReq);
    } else {
      newReqBuilder = getVolumeListRequestBuilder();
    }
    
    if (prevResp != null) {
      int prevStart = newReqBuilder.getLimiter().getStart();
      int prevCount = ((VolumeListResponse) prevResp).getVolumesCount();
      int origStart = getStartParamValue();
      int origLimit = getLimitParamValue();
      newReqBuilder.setLimiter(getNextLimiter(prevStart, prevCount, 
          origStart, origLimit, NUM_VOLUMES_PER_RPC));
    }
    
    return newReqBuilder.build();
  }

  @Override
  public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
    return hasMore(getStartParamValue(), 
        getLimitParamValue(), 
        ((VolumeListRequest) prevReq).getLimiter().getStart(), 
        ((VolumeListResponse) prevResp).getVolumesCount());
  }

  @Override
  public void processResponse(OutputHierarchy out, MessageLite response) throws CLIProcessingException {
    VolumeListResponse resp = (VolumeListResponse) response;
    boolean terse = getOutputParamValue().equals("terse");
    BitSet columns = getColumns();
    for (VolumeInfo v : resp.getVolumesList()) {
      addVolumeInfo(v, terse, columns, out);
    }
    if (resp.hasTotal()) {
      out.setTotal(resp.getTotal());
    }
    this.listedVolumes.addAll(resp.getVolumesList());
  }

  @Override
  public MessageLite sendRequest(MessageLite req) throws CLIProcessingException {
    byte[] data;
    try {
      if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
        data = CLDBRpcCommonUtils.getInstance().sendRequest(
            getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM, 0),
            Common.MapRProgramId.CldbProgramId.getNumber(),
            CLDBProto.CLDBProg.VolumeListProc.getNumber(), req, VolumeListResponse.class);
      } else {
        data = CLDBRpcCommonUtils.getInstance().sendRequest(
            Common.MapRProgramId.CldbProgramId.getNumber(),
            CLDBProto.CLDBProg.VolumeListProc.getNumber(), req, VolumeListResponse.class);
      }
    } catch (Exception e) {
      throw new CLIProcessingException(e);
    }

    if (data != null) {
      return getVolumeListResponse(data);
    } else {
      /**
      * <MAPR_ERROR>
      * Message:RPC Request to list volumes failed. No data returned
      * Function:VolumeCommands.sendRequest()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      LOG.error("RPC Request to list volumes failed. No data returned");
      return null;
    }
  }

  private VolumeListRequest.Builder getVolumeListRequestBuilder() throws CLIProcessingException {
    List<Filter> filters = getFilters(fieldTable, FILTER_PARAM_NAME);
    BitSet columns = getColumns();
    ByteString bString = ByteString.copyFrom(BitSetBytesHelperUtils.toByteArray(columns));
    // for backward compatibility with CLDB
    // we will still set setColumns (even it is not really correct ones 
    // and everything on columnsAdd bytes array
    long columnsOld = BitSetBytesHelperUtils.convert(columns);
    boolean alarmedVolumes = getAlarmedVolumesParamValue();
    VolumeListRequest.Builder req = VolumeListRequest.newBuilder();
    
    if (isParamPresent(VolumeCommands.RW_VOLUME_NODES)) {
      String nodesString = getParamTextValue(VolumeCommands.RW_VOLUME_NODES, 0);
      List<String> nodes = new ArrayList<String>();
      if (nodesString.contains(MULTI_ARG_SEP)) {
        nodes.addAll(Arrays.asList(nodesString.split(
                                    VolumeCommands.MULTI_ARG_SEP)));
      } else {
        nodes.add(nodesString);
      }
      for (String node : nodes) {
  		List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(node));
		if ( ips.isEmpty() ) {
            /**
	            * <MAPR_ERROR>
	            * Message:Invalid Node specified. Could not resolve IP for node : <node>
	            * Function:VolumeCommands.getVolumeListRequestBuilder()
	            * Meaning:An error occurred.
	            * Resolution:Contact technical support.
	            * </MAPR_ERROR>
	            */
			LOG.error("Can not get valid IP address out of provided name: " + node);
			throw new CLIProcessingException("Invalid Node specified. " +
            		"Could not resolve IP for node : " + node);
		}
        String ipAddress = ips.get(0);
        if (ipAddress != null) {
          try {
            int ip = Util.ipToInt(ipAddress);
            req.addNodeIps(ip);
          } catch (NumberFormatException e) {
            /**
            * <MAPR_ERROR>
            * Message:Invalid Node specified. Could not resolve IP for node : <node>
            * Function:VolumeCommands.getVolumeListRequestBuilder()
            * Meaning:An error occurred.
            * Resolution:Contact technical support.
            * </MAPR_ERROR>
            */
            throw new CLIProcessingException("Invalid Node specified. " +
            		"Could not resolve IP for node : " + node);
          }
        }
      }
    }
    
    Limiter limiter = getNextLimiter(getStartParamValue(), 0, 
        getStartParamValue(), getLimitParamValue(), 
        NUM_VOLUMES_PER_RPC);
    
    return req.setCreds(getUserCredentials())
              .addAllFilter(filters)
              .setColumns(columnsOld)
              .setColumnsAdd(bString)
              .setAlarmedvolumes(alarmedVolumes)
              .setLimiter(limiter);
  }

  private boolean getAlarmedVolumesParamValue() throws CLIProcessingException {
    return isParamPresent(ALARMEDVOLUMES_PARAM_NAME) ? getParamBooleanValue(ALARMEDVOLUMES_PARAM_NAME, 0) : false;
  }

  private BitSet getColumns() throws CLIProcessingException {
    BitSet columns = new BitSet();
    // set all bits to 1 for whole fieldMap
    columns.set(0, MAX_VOLUMEFIELDINFO+1);
    //long columns = 0xffffffff;

    String columnsString = getColumnsParamValue();
    if (columnsString != null && (!columnsString.equals("all"))) {
      columns = FilterUtil.getColumns(fieldTable, columnsString.trim());
    } 
    return columns;
  }

//  private VolumeInfoFields getSortField() throws CLIProcessingException {
//    VolumeInfoFields sortField = null;
//    String sortFieldName = getParamTextValue(SORT_PARAM_NAME, 0);
//    if (sortFieldName != null && (!sortFieldName.equals("none"))) {
//      FieldInfo info = FilterUtil.searchFieldByName(fieldTable, 
//                                            sortFieldName.trim());
//      if (info != null ) {
//        sortField = VolumeInfoFields.valueOf(info.getId());
//      } else {
//        LOG.error("Invalid sort field name: " + sortFieldName);
//      }
//    }
//    return sortField;
//  }
  
  private VolumeListResponse getVolumeListResponse(byte[] replyData)
      throws CLIProcessingException {
    try {
      return VolumeListResponse.parseFrom(replyData);
    } catch (InvalidProtocolBufferException ipbe) {
      /**
      * <MAPR_ERROR>
      * Message:Exception while parsing the RPC response data into VolumeListResponse proto object.
      * Function:VolumeCommands.getVolumeListResponse()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      throw new CLIProcessingException("Exception while parsing the RPC "
          + "response data into VolumeListResponse proto object.", ipbe);
    }
  }

  /**
   * Formats the info received in response to the 'maprcli volume info' command. 
   * 
   * @param volInfo
   * @param terse
   * @param columns
   * @param out
   */
  void addVolumeInfo(VolumeInfo volInfo, boolean terse, BitSet columns, 
    OutputHierarchy out) {
    OutputNode volumeInfo = new OutputNode();
    ArrayList<String> messages = new ArrayList<String>();
    formatVolumeInfo(volInfo, terse, columns, volumeInfo, messages);
    out.addNode(volumeInfo);
    for (String msg : messages ) {
      out.addMessage(msg);
    }
  }

  private static OutputNode formatNoteState(NoteStateInfo nsInfo) {
    OutputNode out = new OutputNode();
    out.addNode(new OutputNode("Uid", nsInfo.getUid()));
    out.addNode(new OutputNode("Date", nsInfo.getDate()));
    out.addNode(new OutputNode("Comment", nsInfo.getComment()));
    return out;
  }

  private static OutputNode formatNote(Note note) {
    OutputNode out = new OutputNode();
    out.addNode(new OutputNode("NoteState", note.getState()));
    if (note.hasAdded()) {
      out.addNode(new OutputNode("NoteAdded", formatNoteState(note.getAdded())));
    }
    if (note.hasResolved()) {
      out.addNode(new OutputNode("NoteResolved", formatNoteState(note.getResolved())));
    }
    return out;
  }

   private static OutputHierarchy formatNoteEntryList(List<NoteEntry> noteEntryList) {
     OutputHierarchy oh = new OutputHierarchy();
     for (NoteEntry ne : noteEntryList) {
       OutputNode out = new OutputNode();

       out.addNode(new OutputNode("Notename", ne.getNoteName()));
       out.addNode(new OutputNode("Note", formatNote(ne.getNote())));

      oh.addNode(out);
     }
     return oh;
   }

   /**
    * Formats the info received in response to the 'maprcli volume info' command.
    * 
    * @param v
    * @param terse
    * @param columns
    * @param volumeInfo
    * @param messages
    */
  void formatVolumeInfo(VolumeInfo volInfo, boolean terse, BitSet columns,
    OutputNode volumeInfo, ArrayList<String> messages) {
	// TODO need to take care of "all" columns
    VolumeProperties props = volInfo.getVolProperties();
    List<PluggableAlarm> pluggableAlarms = null;

    try {
      pluggableAlarms = PluggableAlarmUtil.getVolumeAlarms(getUserCredentials(), 0, 50);
    } catch (CLIProcessingException e) {
      LOG.error("Error getting alarms. Alarm message might be incomplete: " + e.getMessage());
    }
    if (columns.get(VolumeInfoFields.noteEntries.getNumber())) {
      OutputHierarchy oh = formatNoteEntryList(volInfo.getNotesList());
      for (OutputNode a : oh.getOutputNodes()) {
        volumeInfo.addNode(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.noteEntries)).getName(terse), a));
      }
    }

    if (columns.get(VolumeInfoFields.acl.getNumber())) {
      String format = (terse) ? "terse" : "short";
      OutputHierarchy volAcl = AclCommands.formatAcl(props.getAcl(), SecureObjectType.OBJECT_TYPE_VOLUME, format, uInfo, null, null);
      for(OutputError e:volAcl.getOutputErrors()) {
        LOG.info("Error in volume output:" + e.toString());  
      }
      for (OutputNode a : volAcl.getOutputNodes()) {
        LOG.info("Output Node:" + a.toJSONString());
        volumeInfo.addNode(new OutputNode( fieldTable.get(new VolumeField(VolumeInfoFields.acl)).getName(terse), a));
      }
    }

    if (columns.get(VolumeInfoFields.owner.getNumber())) {
      int ownerId = props.getOwnerId();
      String ownerName = null;
      try {
        ownerName = uInfo.getUsername(ownerId);
      } catch (SecurityException se) {
        // could not figure out username for uid
        ownerName = "Uid " + ownerId;
      }
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.owner)).getName(terse), 
                         ownerName));
    }
    if (props.hasVolumeAe()) {
      if ((columns.get(VolumeInfoFields.aeName.getNumber())) ||
          (columns.get(VolumeInfoFields.aeType.getNumber()))) {
         AeKey key = props.getVolumeAe();
         volumeInfo.addChild(new OutputNode(
                                  fieldTable.get(
                                     new VolumeField(VolumeInfoFields.aeName)).getName(terse),
                                     key.getName()));      
         volumeInfo.addChild(new OutputNode(
                                  fieldTable.get(
                                     new VolumeField(VolumeInfoFields.aeType)).getName(terse),
                                     key.getType() ? 1:0));      
      }
    }
    
    if (columns.get(VolumeInfoFields.numReplicas.getNumber())) {
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.numReplicas)).getName(terse), 
          Integer.toString(props.getReplicationPolicy().getNumReplicas())));
    }
    if (columns.get(VolumeInfoFields.minReplicas.getNumber()) ) {
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.minReplicas)).getName(terse), 
          Integer.toString(props.getReplicationPolicy().getGuaranteedMinReplicas())));
    }
    if (props.hasNumNamespaceReplicas()) {
      if (columns.get(VolumeInfoFields.namespaceContainerNumReplicas.getNumber())) {
        volumeInfo.addChild(new OutputNode(
              fieldTable.get(new VolumeField(VolumeInfoFields.namespaceContainerNumReplicas)).getName(terse), 
              Integer.toString(props.getNumNamespaceReplicas())));
      }
    }
    if (props.hasGuaranteedMinNamespaceReplicas()) {
      if (columns.get(VolumeInfoFields.namespaceContainerMinReplicas.getNumber()) ) {
        volumeInfo.addChild(new OutputNode(
              fieldTable.get(new VolumeField(VolumeInfoFields.namespaceContainerMinReplicas)).getName(terse), 
              Integer.toString(props.getGuaranteedMinNamespaceReplicas())));
      }
    }
    if (props.hasAllowGrant()) {
      if (columns.get(VolumeInfoFields.allowGrant.getNumber()) ) {
        volumeInfo.addChild(new OutputNode(
              fieldTable.get(new VolumeField(VolumeInfoFields.allowGrant)).getName(terse), 
              Boolean.toString(props.getAllowGrant())));
      }
    }
    if (columns.get(VolumeInfoFields.reReplicationTimeOutSec.getNumber())) {
      volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.reReplicationTimeOutSec)).getName(terse), 
            props.getReReplicationTimeOutSec()));
    }
    if (columns.get(VolumeInfoFields.criticalReReplicationTimeOutSec.getNumber())) {
      volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.criticalReReplicationTimeOutSec)).getName(terse), 
            props.getCriticalReReplicationTimeOutSec()));
    }
    if (columns.get(VolumeInfoFields.dataContainerRepltype.getNumber()) ) {
      ContainerReplType type = ContainerReplType.CASCADE;
      if (props.getReplicationPolicy().hasDataContainerReplType())
        type = props.getReplicationPolicy().getDataContainerReplType();

      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.dataContainerRepltype)).getName(terse),
          getContainerReplTypeString(type)));
    }
    // For backward compatibility, treat local-volumes with repl=1 special.
    boolean localVolumeReplOne = false;
    String topo = props.getTopology().getTopologyRestricted();
    if (props.getLocalVolume() &&
        (props.getReplicationPolicy().getNumReplicas() == 1)) {
      
      localVolumeReplOne = true;
      if (props.hasLocalTopology())
        topo = props.getLocalTopology().getTopologyRestricted();
    }
    if (columns.get(VolumeInfoFields.rackPath.getNumber())) {
      String rp = (topo.equals("")) ? "/" : topo;
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.rackPath)).getName(terse), 
          rp));
    }
    if (columns.get(VolumeInfoFields.localPath.getNumber()) &&
        props.hasLocalTopology() && !localVolumeReplOne) {
      String rp = (props.getLocalTopology().getTopologyRestricted().equals("")) ? "/" :
        props.getLocalTopology().getTopologyRestricted();
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.localPath)).getName(terse), 
          rp));
    }
    if (columns.get(VolumeInfoFields.mirrorThrottle.getNumber()) &&
        props.hasMirrorThrottle()) {
      Integer ro = (props.getMirrorThrottle()) ? 1 : 0;
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.mirrorThrottle)).getName(terse), 
          Integer.toString(ro)));
    }
    if (columns.get(VolumeInfoFields.volumeAccessTime.getNumber())) {
     DateFormat formatter = DateFormat.getDateInstance(DateFormat.LONG,
                                                       Locale.getDefault());
     String rp = (volInfo.hasAtime() ?  (formatter.format(new Date(volInfo.getAtime()))) : "Missing Atime");

     volumeInfo.addChild(new OutputNode(
       fieldTable.get(new VolumeField(VolumeInfoFields.volumeAccessTime)).getName(terse), rp));
   }
    if (columns.get(VolumeInfoFields.readOnly.getNumber())) {
      Integer ro = (props.getReadOnly()) ? 1 : 0;
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.readOnly)).getName(terse), 
          Integer.toString(ro)));
    }
    if (columns.get(VolumeInfoFields.mountDir.getNumber())) {
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.mountDir)).getName(terse), 
          props.getMountDir()));
    }
    if (columns.get(VolumeInfoFields.volumeName.getNumber())) {
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.volumeName)).getName(terse), 
          props.getVolumeName()));   
    }
    if (columns.get(VolumeInfoFields.mounted.getNumber())) {
      Integer m = (props.getMounted()) ? 1 : 0;
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.mounted)).getName(terse), 
          Integer.valueOf(m)));
    }
    if (columns.get(VolumeInfoFields.quota.getNumber())) {
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.quota)).getName(terse), 
          Long.toString(props.getVolumeQuotaSizeMB())));
    }
    if (columns.get(VolumeInfoFields.advisoryquota.getNumber())) {
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.advisoryquota)).getName(terse), 
          Long.toString(props.getVolumeQuotaAdvisorySizeMB())));
    }
    if (columns.get(VolumeInfoFields.snapshotcount.getNumber()) ) {
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.snapshotcount)).getName(terse), 
          Integer.toString(props.getNumSnapshots())));
    }
    
    if (columns.get(VolumeInfoFields.logicalUsed.getNumber())) {
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.logicalUsed)).getName(terse),
          Long.toString(volInfo.getVolQuota().getVolumeLogicalUsedSizeMB())));
    }
    if (columns.get(VolumeInfoFields.used.getNumber())) {
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.used)).getName(terse), 
          Long.toString(volInfo.getVolQuota().getVolumeUsedSizeMB())));
    }
    
    if (columns.get(VolumeInfoFields.snapshotUsed.getNumber())) {
      long snapSize = volInfo.getVolumeSnapshotsOwnedSizeMB();
   	  snapSize -= volInfo.getVolQuota().getVolumeSharedSizeMB();
   	  if ( snapSize < 0 ) {
   		  // put in place in case of rounding error or other sizing issues that will be fixed later
   		  snapSize = 0;
   	  }
      volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.snapshotUsed)).getName(terse),
          Long.toString(snapSize)));
    }
    
    if (columns.get(VolumeInfoFields.totalUsed.getNumber())) {
      long snapSize = volInfo.getVolumeSnapshotsOwnedSizeMB();
      if (snapSize < volInfo.getVolQuota().getVolumeSharedSizeMB()) {
        // Fix transient behaviour because of snap delete in progress by
        // taking rw shared size which will be <= snapowned
        snapSize = volInfo.getVolQuota().getVolumeSharedSizeMB();
      }
      volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.totalUsed)).getName(terse),
          Long.toString(snapSize + 
              volInfo.getVolQuota().getVolumeOwnedSizeMB())));
    }
    
    if (columns.get(VolumeInfoFields.schedule.getNumber())) {
        volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.schedule)).getName(terse), 
            Integer.valueOf(volInfo.getVolProperties().getSchedulingPolicyId())));
        volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.scheduleName)).getName(terse), 
            volInfo.getVolProperties().getSchedulingPolicyName()));
    }

    if (columns.get(VolumeInfoFields.mirrorSchedule.getNumber())) {
        volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.mirrorSchedule)).getName(terse), 
            Integer.valueOf(volInfo.getVolProperties().getMirrorSchedulingPolicyId())));
    }

    if (columns.get(VolumeInfoFields.volumeType.getNumber())) {
      volumeInfo.addChild(new OutputNode(
         fieldTable.get(new VolumeField(VolumeInfoFields.volumeType))
           .getName(terse), props.getIsMirrorVol() ? 1 : 0));
    }
    
    if (columns.get(VolumeInfoFields.mirrorType.getNumber())) {
      int mtype = props.getIsMirrorVol() ? 1 : 0;
      if (props.hasVolumetype() &&
          props.getVolumetype().getNumber() != 0)
        mtype = props.getVolumetype().getNumber();

      volumeInfo.addChild(new OutputNode(
         fieldTable.get(new VolumeField(VolumeInfoFields.mirrorType))
           .getName(terse), mtype));
    }

    if (columns.get(VolumeInfoFields.CreatorContainerId.getNumber())) {
      volumeInfo.addChild(new OutputNode(
         fieldTable.get(new VolumeField(VolumeInfoFields.CreatorContainerId))
           .getName(terse), props.getCreatorContainerId()));
    }

    if (columns.get(VolumeInfoFields.CreatorVolumeUuid.getNumber())) {
      StringBuilder creatorVolUuid= new StringBuilder();
      if (props.hasCreatorVolumeUuid()) {
        creatorVolUuid.append(props.getCreatorVolumeUuid().getId640());
        creatorVolUuid.append(":");
        creatorVolUuid.append(props.getCreatorVolumeUuid().getId641());
      }
      volumeInfo.addChild(new OutputNode(
         fieldTable.get(new VolumeField(VolumeInfoFields.CreatorVolumeUuid))
           .getName(terse), creatorVolUuid.toString()));
    }
    if (columns.get(VolumeInfoFields.volumeId.getNumber())) {
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.volumeId)).getName(terse), 
          volInfo.getVolumeId()));
    }
    
    if (columns.get(VolumeInfoFields.listReplicas.getNumber())) {   
      if(volInfo.getVolumeReplicationList().size() > 0 ) {
        for (VolumeReplicationInfo vrInfo : volInfo.getVolumeReplicationList()) {
          volumeInfo.addNode(new OutputNode(
              fieldTable.get(new VolumeField(VolumeInfoFields.listReplicas)).getName(terse), 
              Integer.valueOf(vrInfo.getPercent())));
        }
      } else {
        if(props.getVolumeName() != null && props.getVolumeName().length() != 0)
          volumeInfo.addNode(new OutputNode(
              fieldTable.get(new VolumeField(VolumeInfoFields.listReplicas)).getName(terse), 
              "Information is not yet available for volume '" +
                       props.getVolumeName() +
                       "'. Please try again."));
        else 
            volumeInfo.addNode(new OutputNode(
                fieldTable.get(new VolumeField(VolumeInfoFields.listReplicas)).getName(terse), 
                "Information is not yet available for volume. Please try again."));
      }
    }
    
    if (columns.get(VolumeInfoFields.nameContainerSize.getNumber())) {
      if (volInfo.getRootContainerSizeMB() >= 0) {
        volumeInfo.addChild(new OutputNode(
             fieldTable.get(new VolumeField(VolumeInfoFields.nameContainerSize))
               .getName(terse), volInfo.getRootContainerSizeMB()));
      }
    }

    if (columns.get(VolumeInfoFields.nameContainerId.getNumber())) {
      if (volInfo.hasRootContainer()) {
        volumeInfo.addChild(new OutputNode(
             fieldTable.get(new VolumeField(VolumeInfoFields.nameContainerId))
               .getName(terse), volInfo.getRootContainer().getContainerId()));
      }
    }
    
    if (columns.get(VolumeInfoFields.needsGfsck.getNumber())) {
      volumeInfo.addChild(new OutputNode(
        fieldTable.get(new VolumeField(VolumeInfoFields.needsGfsck)).getName(terse),
        props.getNeedsGfsck()));
    }

    if (columns.get(VolumeInfoFields.maxinodesalarmthreshold.getNumber())) {
      volumeInfo.addChild(new OutputNode(
        fieldTable.get(new VolumeField(VolumeInfoFields.maxinodesalarmthreshold)).getName(terse),
        Long.toString(props.getMaxInodesAlarmThreshold())));
    }

    if (columns.get(VolumeInfoFields.dbReplLagSecAlarmThresh.getNumber())) {
      volumeInfo.addChild(new OutputNode(
        fieldTable.get(new VolumeField(VolumeInfoFields.dbReplLagSecAlarmThresh)).getName(terse),
        Integer.toString(props.getDbReplLagSecAlarmThresh())));
    }


    if (columns.get(VolumeInfoFields.limitSpread.getNumber())) {
      volumeInfo.addChild(new OutputNode(
        fieldTable.get(new VolumeField(VolumeInfoFields.limitSpread)).getName(terse),
        Boolean.toString(props.getLimitVolumeSpread())));
    }

    if (volInfo.hasPartlyOutOfTopology() &&
        columns.get(VolumeInfoFields.partlyOutOfTopology.getNumber())) {
      Integer poot = (volInfo.getPartlyOutOfTopology()) ? 1 : 0;
      volumeInfo.addChild(new OutputNode(
        fieldTable.get(new VolumeField(VolumeInfoFields.partlyOutOfTopology)).getName(terse), poot));
    }

    if (columns.get(VolumeInfoFields.isAuditVolume.getNumber())) {
      Integer isAudited = props.getIsAuditVolume() ? 1 : 0;
      volumeInfo.addChild(new OutputNode(
        fieldTable.get(new
                       VolumeField(VolumeInfoFields.isAuditVolume)).getName(terse),
        isAudited));
    }

    if (columns.get(VolumeInfoFields.audited.getNumber())) {
      Integer auditEnabled = props.getAudited() ? 1 : 0;
      volumeInfo.addChild(new OutputNode(
        fieldTable.get(new
                       VolumeField(VolumeInfoFields.audited)).getName(terse),
        auditEnabled));
    }

    if (columns.get(VolumeInfoFields.coalesceInterval.getNumber())) {
      Integer coalesceInterval = props.getCoalesceInterval();
      volumeInfo.addChild(new OutputNode(
        fieldTable.get(new
                       VolumeField(VolumeInfoFields.coalesceInterval)).getName(terse),
        coalesceInterval));
    }

    if (columns.get(VolumeInfoFields.fsAuditEnabledOperations.getNumber())) {
      volumeInfo.addChild(new OutputNode(
        fieldTable.get(
        new VolumeField(VolumeInfoFields.fsAuditEnabledOperations)).getName(terse),
        GetStringsForAuditOps.getEnabledOps(props.getFsAuditDisabledOperations())));
    }

    if (columns.get(VolumeInfoFields.fsAuditDisabledOperations.getNumber())) {
      volumeInfo.addChild(new OutputNode(
        fieldTable.get(
        new VolumeField(VolumeInfoFields.fsAuditDisabledOperations)).getName(terse),
        GetStringsForAuditOps.getDisabledOps(props.getFsAuditDisabledOperations())));
    }

    // Add mirror-related information
    if (props.hasMirrorInfo()) {
      MirrorInfo mirrorInfo = props.getMirrorInfo();
      if (columns.get(VolumeInfoFields.mirrorSrcVolume.getNumber()) ) {
         volumeInfo.addChild(new OutputNode(
             fieldTable.get(new VolumeField(VolumeInfoFields.mirrorSrcVolume)).getName(terse), 
                            mirrorInfo.getSrcVolumeName()));
      }
      if (columns.get(VolumeInfoFields.mirrorSrcVolumeId.getNumber())) {
        volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.mirrorSrcVolumeId))
              .getName(terse), mirrorInfo.getSrcVolumeId()));
      }
      
      if (columns.get(VolumeInfoFields.mirrorSrcClusterName.getNumber())) {
        volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.mirrorSrcClusterName))
              .getName(terse), mirrorInfo.getSrcClusterName()));
      }

      if (columns.get(VolumeInfoFields.mirrorDataGeneratorSrcVolumeName.getNumber())) {
        
        volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.mirrorDataGeneratorSrcVolumeName))
                .getName(terse), mirrorInfo.getDataGeneratorSrcVolumeName()));
      }
      
      if (columns.get(VolumeInfoFields.mirrorDataGeneratorSrcVolumeId.getNumber())) {
        
        volumeInfo.addChild(new OutputNode(
            fieldTable.get(
                new VolumeField(VolumeInfoFields.mirrorDataGeneratorSrcVolumeId))
                .getName(terse), mirrorInfo.getDataGeneratorSrcVolumeId()));
      }

      if (columns.get(VolumeInfoFields.mirrorDataGeneratorSrcClusterName.getNumber())) {
        
        volumeInfo.addChild(new OutputNode(
            fieldTable.get(
                new VolumeField(VolumeInfoFields.mirrorDataGeneratorSrcClusterName))
                .getName(terse), mirrorInfo.getDataGeneratorSrcClusterName()));
      }
      if (columns.get(VolumeInfoFields.lastSuccessfulMirrorTime.getNumber()) ) {
        volumeInfo.addChild(new OutputNode(
           fieldTable.get(new VolumeField(VolumeInfoFields.lastSuccessfulMirrorTime))
             .getName(terse), mirrorInfo.getLastSuccessfulMirrorTime()));
      }

      if (columns.get(VolumeInfoFields.mirrorPercentComplete.getNumber()) ) {
        volumeInfo.addChild(new OutputNode(
           fieldTable.get(new VolumeField(VolumeInfoFields.mirrorPercentComplete))
             .getName(terse), mirrorInfo.getPercentComplete()));
      }

      if (columns.get(VolumeInfoFields.mirrorId.getNumber()) ) {
        volumeInfo.addChild(new OutputNode(
           fieldTable.get(new VolumeField(VolumeInfoFields.mirrorId))
             .getName(terse), mirrorInfo.getMirrorId()));
      }

      if (columns.get(VolumeInfoFields.nextMirrorId.getNumber())) {
        volumeInfo.addChild(new OutputNode(
           fieldTable.get(new VolumeField(VolumeInfoFields.nextMirrorId))
             .getName(terse), mirrorInfo.getNextMirrorId()));
      }


      int mirrorStatus = 0;
      if (mirrorInfo.getMirrorStatus() == MirrorStatus.STATE_MIRROR_COMPLETE ||
          mirrorInfo.getMirrorStatus() == MirrorStatus.STATE_CONVERT_COMPLETE) {
        mirrorStatus = 0;
      } else if (mirrorInfo.getMirrorStatus() == 
                  MirrorStatus.STATE_MIRROR_FAILED) {
        mirrorStatus = 2; // 2 is for mirror in progress
      } else {
        mirrorStatus = 1;
      }

      if (columns.get(VolumeInfoFields.mirrorStatus.getNumber())) {
        volumeInfo.addChild(new OutputNode(
           fieldTable.get(new VolumeField(VolumeInfoFields.mirrorStatus))
             .getName(terse), mirrorStatus));
      }
      
      if (mirrorStatus == 2 &&
          columns.get(VolumeInfoFields.mirrorErrorCode.getNumber())) {
        
        volumeInfo.addChild(new OutputNode(
           fieldTable.get(new VolumeField(VolumeInfoFields.mirrorErrorCode))
             .getName(terse), mirrorInfo.getErrorCode()));
      }
      
    }
    /*  ------------------------------- 
     *  Commented to hide WORM feature
     *  -------------------------------
     *
    if (columns.get(VolumeInfoFields.isWorm.getNumber()) && props.hasIsWorm()) {
      volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.isWorm)).getName(terse),
            Boolean.toString(props.getIsWorm())));
    }

    if (columns.get(VolumeInfoFields.wormConfig.getNumber()) && props.hasWormConfig()) {
      volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.wormConfig)).getName(terse),
            formatWormSetting(props.getWormConfig())));
    }
    
    if (columns.get(VolumeInfoFields.commitMinutes.getNumber()) &&
        props.hasWormConfig() && props.getWormConfig().hasCommitTimeMinutes()) {
      volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.commitMinutes)).getName(terse),
            Integer.toString(props.getWormConfig().getCommitTimeMinutes())));
    }
    
    if (columns.get(VolumeInfoFields.retentionDays.getNumber()) &&
        props.hasWormConfig() && props.getWormConfig().hasRetentionPeriodDays()) {
      volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.retentionDays)).getName(terse),
            Integer.toString(props.getWormConfig().getRetentionPeriodDays())));
    }
    
    if (columns.get(VolumeInfoFields.hasNotes.getNumber())) {
      boolean val = (v.getNotesList().size() > 0) ? true : false;
      volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.hasNotes)).getName(terse),
            Boolean.toString(val)));
    }
    
    if (columns.get(VolumeInfoFields.unresolvedNotes.getNumber()) ) {
      boolean val = false;
      Note note;
      for (NoteEntry ne : v.getNotesList()) {
        note = ne.getNote();
        if (note.getState() == NoteStateEnum.NOTE_STATE_UNRESOLVED) {
          val = true;
          break;
        }
      }
      volumeInfo.addChild(new OutputNode(
            fieldTable.get(new VolumeField(VolumeInfoFields.unresolvedNotes)).getName(terse),
            Boolean.toString(val)));
    }
     *  -------------------------------
     */
    
    if (columns.get(VolumeInfoFields.numContainers.getNumber()) &&
        props.hasNumContainers()) {
        volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.numContainers)).getName(terse),
          Integer.toString(props.getNumContainers())));
    }
    
    if (columns.get(VolumeInfoFields.volumeAces.getNumber()) &&
        (volInfo.hasVolumeAces() == true)) {
      OutputNode volumeAcesNode = new OutputNode("volumeAces");
      try {
        for (VolumeAceEntry aceEntry : volInfo.getVolumeAces().getAcesList()) {
          if (aceEntry.getAccessType() == VolumeActions.VOLUME_READ) {
            volumeAcesNode.addNode(new OutputNode(
                  VOL_READACE_PARAM,
                  AceHelper.toInfix(aceEntry.getExpr().toStringUtf8())));
          } else if (aceEntry.getAccessType() == VolumeActions.VOLUME_WRITE) {
            volumeAcesNode.addNode(new OutputNode(
                  VOL_WRITEACE_PARAM,
                  AceHelper.toInfix(aceEntry.getExpr().toStringUtf8())));
          } else {
            assertNotNull(null);
          }
        } //for
      } //try
      catch(IOException e) {
        LOG.error("Unable to parse volume aces");
      }
      volumeInfo.addChild(volumeAcesNode);
    }

    if (columns.get(VolumeInfoFields.fixCreatorId.getNumber())) {
      volumeInfo.addChild(new OutputNode(
        fieldTable.get(new VolumeField(VolumeInfoFields.fixCreatorId)).getName(terse),
        Boolean.toString(props.getUseActualCreatorId())));
    }

    if (columns.get(VolumeInfoFields.replTypeConversionInProgress.getNumber())) {
      Integer inProgress = (props.getReplTypeConversionInProgress()) ? 1 : 0;
      volumeInfo.addChild(new OutputNode(
          fieldTable.get(new VolumeField(VolumeInfoFields.replTypeConversionInProgress)).getName(terse), 
          Integer.toString(inProgress)));
    }

    // Add alarms information
    for (AlarmMsg vAlarm : volInfo.getVolumeAlarmsList()) {
      if (vAlarm.getAlarmId() == AlarmId.VOLUME_ALARM_SNAPSHOT_FAILURE) {
        if (columns.get(VolumeInfoFields.SnapshotFailureAlarm.getNumber())) {
          volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.SnapshotFailureAlarm)).getName(
              terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
        }
      } else if (vAlarm.getAlarmId() == AlarmId.VOLUME_ALARM_MIRROR_FAILURE) {
        if (columns.get(VolumeInfoFields.MirrorFailureAlarm.getNumber())) {
          volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.MirrorFailureAlarm)).getName(
              terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
        }
      } else if (vAlarm.getAlarmId() == AlarmId.VOLUME_ALARM_DATA_UNAVAILABLE) {
        if (columns.get(VolumeInfoFields.DataUnavailableAlarm.getNumber())) {
          volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.DataUnavailableAlarm)).getName(
              terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
        }
      } else if (vAlarm.getAlarmId() == AlarmId.VOLUME_ALARM_DATA_UNDER_REPLICATED) {
        if (columns.get(VolumeInfoFields.DataUnderReplicatedAlarm.getNumber())) {
          volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.DataUnderReplicatedAlarm)).getName(
              terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
        }
      } else if (vAlarm.getAlarmId() == AlarmId.VOLUME_ALARM_ADVISORY_QUOTA_EXCEEDED) {
        if (columns.get(VolumeInfoFields.AdvisoryQuotaExceededAlarm.getNumber())) {
          volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.AdvisoryQuotaExceededAlarm)).getName(
              terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
        }
      } else if (vAlarm.getAlarmId() == AlarmId.VOLUME_ALARM_QUOTA_EXCEEDED) {
        if (columns.get(VolumeInfoFields.QuotaExceededAlarm.getNumber())) {
          volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.QuotaExceededAlarm)).getName(
              terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
        }
      } else if (vAlarm.getAlarmId() == AlarmId.VOLUME_ALARM_NO_NODES_IN_TOPOLOGY) {
        if (columns.get(VolumeInfoFields.NoNodesInTopologyAlarm.getNumber())) {
          volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.NoNodesInTopologyAlarm)).getName(
              terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
        }
      } else if (vAlarm.getAlarmId() == AlarmId.VOLUME_ALARM_TOPOLOGY_ALMOST_FULL) {
        if (columns.get(VolumeInfoFields.AlmostFullTopologyAlarm.getNumber())) {
          volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.AlmostFullTopologyAlarm)).getName(
              terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
        }
      } else if (vAlarm.getAlarmId() == AlarmId.VOLUME_ALARM_TOPOLOGY_FULL) {
        if (columns.get(VolumeInfoFields.FullTopologyAlarm.getNumber())) {
          volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.FullTopologyAlarm)).getName(
              terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
        }
      } else if (vAlarm.getAlarmId() == AlarmId.VOLUME_ALARM_INODES_EXCEEDED) {
        if (columns.get(VolumeInfoFields.InodesExceededAlarm.getNumber())) {
          volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.InodesExceededAlarm)).getName(
              terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
        }
      } else if (vAlarm.getAlarmId() == AlarmId.VOLUME_ALARM_DATA_CONTAINERS_NONLOCAL) {
        if (columns.get(VolumeInfoFields.ContainersNonLocalAlarm.getNumber())) {
          volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.ContainersNonLocalAlarm)).getName(
              terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
        }
      } else if (vAlarm.getAlarmId() == AlarmId.VOLUME_ALARM_CANNOT_MIRROR) {
        if (columns.get(VolumeInfoFields.CannotMirrorAlarm.getNumber())) {
          volumeInfo.addChild(new OutputNode(fieldTable.get(new VolumeField(VolumeInfoFields.CannotMirrorAlarm)).getName(
              terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
        }
      } else {
        // Pluggable alarm
        for (PluggableAlarm pluggableAlarm : pluggableAlarms) {
          if (vAlarm.getAlarmName().equals(pluggableAlarm.getName())) {
            volumeInfo.addChild(new OutputNode(terse ? pluggableAlarm.getTerse() : pluggableAlarm.getDisplayName(),
                vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0));
            break;
          }
        }
      }
    }
  }

  String GetVolumeNameFromVolAndClusterName(String fullName) {
    int index = fullName.indexOf('@');

    if ((index == -1) || (index == 0)) {
      return null;
    }
    return fullName.substring(0, index);
  }
  String GetClusterNameFromVolAndClusterName(String fullName) {
    int index = fullName.indexOf('@');

    if ((index == -1) || (index == 0)) {
      return null;
    }
    return fullName.substring(index + 1, fullName.length());
  }
  
  String CldbIPFromClusterName(String ClusterName) {
    int index = ClusterName.indexOf(':');
    
    if ((index == -1) || (index == 0)) {
      return null;
    }
    return ClusterName.substring(0, index);
  }

  int CldbPortFromClusterName(String ClusterName) {
    int index = ClusterName.indexOf(':');
    
    if ((index == -1) || (index == 0)) {
      return 0;
    }
    try {
      int cldbPort = Integer.parseInt(ClusterName.substring(index + 1, 
                                     ClusterName.length()));
      return cldbPort;
    } catch (NumberFormatException e) {
      return 0;
    }
  }
  
  boolean IsItConvertibleVolume(VolumeType type) {
    if ((type == VolumeType.VTRW) || (type == VolumeType.VTMirror)) {
      return false;
    }
    return true;
  }

  int UpdateMirrorSourceVolumeName(
    String destVolumeName,  
    VolumeProperties.Builder volProps,
    OutputHierarchy out) throws CLIProcessingException {

    String srcVolumeFullName = getParamTextValue(
        		VolumeCommands.MIRROR_VOLUME_SRC_VOLUMENAME, 0);

    String srcVolumeName = 
      GetVolumeNameFromVolAndClusterName(srcVolumeFullName);
    
    String srcClusterName = 
      GetClusterNameFromVolAndClusterName(srcVolumeFullName); 
  
    if ((srcVolumeName == null) || (srcClusterName == null)) {
      /**
      * <MAPR_ERROR>
      * Message:Source volume name <volume name> is not specified in format srcvolume\@srccluster
      * Function:VolumeCommands.UpdateMirrorSourceVolumeName()
      * Meaning:You must specify the source volume name in the format {{<volume>\@<cluster>}}.
      * Resolution: Check the volume name, the cluster name, and the command syntax, then try again.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EINVAL, 
          "Source volume name " + srcVolumeName + " is " +
          "not specified in format srcvolume@srccluster")
          .setField(MIRROR_VOLUME_SRC_VOLUMENAME));
      return Errno.EINVAL;
    }

    // validate the srcClusterName
    if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(srcClusterName)) {
      /**
      * <MAPR_ERROR>
      * Message:Invalid cluster name <cluster name>
      * Function:VolumeCommands.UpdateMirrorSourceVolumeName()
      * Meaning:The specified cluster name is invalid.
      * Resolution:Check the cluster name and the command syntax, and try again.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EINVAL, "Invalid cluster name "
             + srcClusterName) .setField(MIRROR_VOLUME_SRC_VOLUMENAME));
      return Errno.EINVAL;
    }

    String destClusterName = null;

    if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
      destClusterName = getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM, 0);
    }
    else {
      destClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
    }
    
    if (destVolumeName.equalsIgnoreCase(srcVolumeName) &&
        destClusterName.equalsIgnoreCase(srcClusterName)) {
      /**
      * <MAPR_ERROR>
      * Message:Invalid cluster name <cluster name>
      * Function:VolumeCommands.UpdateMirrorSourceVolumeName()
      * Meaning:Volume attaching itself as source.
      * Resolution:Check the src volume and cluster name and the command syntax, and try again.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EINVAL, "Specified source "
             + srcVolumeFullName + " is same as destination")
                   .setField(MIRROR_VOLUME_SRC_VOLUMENAME));
      return Errno.EINVAL;
    }

    if (destClusterName.equalsIgnoreCase(srcClusterName) == false) {
      boolean isSourceClusterSecure = JNISecurity.IsSecurityEnabled(srcClusterName);
      boolean isDestClusterSecure = JNISecurity.IsSecurityEnabled(destClusterName);
      if (isSourceClusterSecure ^ isDestClusterSecure) {
        out.addError(new OutputError(Errno.EOPNOTSUPP,
            "In cross cluster mirroring, both clusters must be either " +
            "secure or unsecure. Other combination is not allowed."));
        return Errno.EINVAL;
      }
    }

    VolumeLookupRequest.Builder srcVolumeLookupReq = 
        						VolumeLookupRequest.newBuilder();
    VolumeLookupResponse srcVolumeLookupResp = null;
    srcVolumeLookupReq.setVolumeName(srcVolumeName);
    srcVolumeLookupReq.setCreds(getUserCredentials());
    byte [] data = null;

    try {
      data = CLDBRpcCommonUtils.getInstance().sendRequest(srcClusterName,
          Common.MapRProgramId.CldbProgramId.getNumber(),
          CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), 
          srcVolumeLookupReq.build(), VolumeLookupResponse.class);

      if (data == null) {
        throw new CLIProcessingException("Exception while processing RPC");
      }
      srcVolumeLookupResp = VolumeLookupResponse.parseFrom(data);
    } catch (MaprSecurityException e) {
      throw new CLIProcessingException(
        "MaprSecurityException " + "Exception", e);
    } catch (Exception e) {
      /**
      * <MAPR_ERROR>
      * Message:Exception while sending RPC to cluster
      * Function:VolumeCommands.UpdateMirrorSourceVolumeName()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      throw new CLIProcessingException("Exception while sending RPC to cluster"
          + srcClusterName, e);
    }

    if (!srcVolumeLookupResp.hasStatus() || 
        (srcVolumeLookupResp.getStatus() != 0)) {
        /**
        * <MAPR_ERROR>
        * Message:Source volume <volume name> doesn't exist in cluster <cluster name>
        * Function:VolumeCommands.UpdateMirrorSourceVolumeName()
        * Meaning:The specified volume could not be located in the specified cluster.
        * Resolution:Try again, checking the volume name, cluster name, and command syntax.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EOPFAILED, 
      	  "Source volume " + srcVolumeName + 
      		" doesn't exist in cluster " + srcClusterName)
      		.setField(MIRROR_VOLUME_SRC_VOLUMENAME));
        return Errno.EOPFAILED;
    }
    
    // Now get the destination volume information
    VolumeLookupRequest.Builder destVolumeLookupReq = 
                    VolumeLookupRequest.newBuilder();
    VolumeLookupResponse destVolumeLookupResp = null;
    
    destVolumeLookupReq.setVolumeName(destVolumeName);
    destVolumeLookupReq.setCreds(getUserCredentials());
    
    data = null;
    try {
      if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
        data = CLDBRpcCommonUtils.getInstance().sendRequest(
            getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0),
            Common.MapRProgramId.CldbProgramId.getNumber(),
            CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), 
            destVolumeLookupReq.build(), VolumeLookupResponse.class);
      } else {
        data = CLDBRpcCommonUtils.getInstance().sendRequest(
            Common.MapRProgramId.CldbProgramId.getNumber(),
            CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), 
            destVolumeLookupReq.build(), VolumeLookupResponse.class);
      }
      if (data == null) {
        /**
        * <MAPR_ERROR>
        * Message:Exception while communicating with CLDB for volume <volume name>
        * Function:VolumeCommands.UpdateMirrorSourceVolumeName()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.ECOMM, 
              "Exception while communicating with CLDB"
              + " for volume " + destVolumeName));
        return Errno.ECOMM;
      }  
      destVolumeLookupResp = VolumeLookupResponse.parseFrom(data);
      if (!destVolumeLookupResp.hasStatus() || 
          (destVolumeLookupResp.getStatus() != 0)) {
          /**
          * <MAPR_ERROR>
          * Message:volume <volume name> doesn't exist 
          * Function:VolumeCommands.UpdateMirrorSourceVolumeName()
          * Meaning:The specified volume name could not be found.
          * Resolution:Check the volume name and the command syntax, and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(destVolumeLookupResp.getStatus(), 
            "volume " + destVolumeName + " doesn't exist "));
          return destVolumeLookupResp.getStatus();
      }
    } catch (MaprSecurityException e) {
      throw new CLIProcessingException(
        "MaprSecurityException " + "Exception", e);
    } catch (Exception e) {
      /**
      * <MAPR_ERROR>
      * Message:Exception while communicating with CLDB for volume <volume>
      * Function:VolumeCommands.UpdateMirrorSourceVolumeName()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.ECOMM, 
          "Exception while communicating with CLDB"
          + " for volume " + destVolumeName));
      return Errno.ECOMM;
    }
    
    boolean isDestMirrorVol = destVolumeLookupResp.getVolInfo()
     .getVolProperties().getIsMirrorVol(); 
    // Don't allow to change source field for a non mirror volume
    if (!isParamPresent(VolumeCommands.MIRROR_VOLUME) &&
          !isDestMirrorVol) {
      /**
      * <MAPR_ERROR>
      * Message:Cannot update the 'source' property of Volume '<volume name>'
      * because it is not a mirror volume
      * Function:VolumeCommands.UpdateMirrorSourceVolumeName()
      * Meaning:Only mirror volumes have a {{source}} property.
      * Resolution:Check the command syntax and the volume name, and try again.
      * </MAPR_ERROR>
      */
      out.addError(new OutputError(Errno.EINVAL, 
          "Cannot update the 'source' property of Volume '" 
          + destVolumeName + "' because it is not a mirror volume"));
      return Errno.EINVAL;      
    }
    
    MirrorInfo destVolMirrorInfo = null; 
    if(isDestMirrorVol) {
      destVolMirrorInfo = 
      destVolumeLookupResp.getVolInfo().getVolProperties().getMirrorInfo();
    
      // Don't allow to change source field if mirroring is in progress
      MirrorStatus mStatus = destVolMirrorInfo.getMirrorStatus();
      if ((mStatus != MirrorStatus.STATE_MIRROR_COMPLETE) &&
          (mStatus != MirrorStatus.STATE_CONVERT_COMPLETE) &&
    	  (mStatus != MirrorStatus.STATE_MIRROR_FAILED)) { 
        /**
        * <MAPR_ERROR>
        * Message:Cannot update the 'source' property of Volume '<volume name>' 
        * because mirroring is in progress on the volume
        * Function:VolumeCommands.UpdateMirrorSourceVolumeName()
        * Meaning:You cannot modify a volume during a mirroring operation.
        * Resolution:Wait until mirroring completes, then try again.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EINPROGRESS, 
            "Cannot update the 'source' property of Volume '" 
            + destVolumeName 
            + "' because mirroring is in progress on the volume"));
        return Errno.EINPROGRESS;
      }
    }

    VolumeProperties srcVolProp = srcVolumeLookupResp.getVolInfo().getVolProperties();
    VolumeProperties destVolProp = destVolumeLookupResp.getVolInfo().getVolProperties();
    
    if (!canPerformVolumeAction(srcClusterName, srcVolumeName, srcVolProp, 
        SecurityCommandHelper.VOLUME_DUMP_MASK, getUserCredentials(), out) &&
        !canPerformVolumeAction(destClusterName, destVolumeName, destVolProp,
            SecurityCommandHelper.VOLUME_RESTORE_MASK, getUserCredentials(), out)) {
      out.addError(new OutputError(Errno.EPERM,
          "User doesn't have permissions to update source mirror of " + destVolumeName +
          " to " + srcVolumeFullName));
        return Errno.EPERM;
    }
    
    // Don't allow the update of source if the dataGenerator volume
    // information of new source doesn't match with the dataGenerator 
    // on new source volume
    if (srcVolProp.hasCreatorVolumeUuid() && destVolProp.hasCreatorVolumeUuid()) {
      GuidMsg srcVolGuid = srcVolProp.getCreatorVolumeUuid();
      GuidMsg destVolGuid = destVolProp.getCreatorVolumeUuid();
      if (srcVolGuid.getId640() != destVolGuid.getId640() ||
          srcVolGuid.getId641() != destVolGuid.getId641() ) {
        out.addError(new OutputError(Errno.EINVAL, 
            "Can not update the 'source' property of Volume '" 
            + destVolumeName 
            + "' because new source volume creator volumeuuid didn't match'"));
        return Errno.EINVAL;
      }
    } else {
      int srcDataGeneratorVolumeId = 0;
      boolean hasVolumeUUID = false;
      long srcDataGeneratorVolumeUUID = 0;
      long destDataGeneratorVolumeUUID = 0;
      String srcDataGeneratorVolumeName = null;
      String srcDataGeneratorClusterName = null;
      if (srcVolProp.getIsMirrorVol()) {
        srcDataGeneratorVolumeId = 
          srcVolProp.getMirrorInfo().getDataGeneratorSrcVolumeId();
        srcDataGeneratorClusterName = 
          srcVolProp.getMirrorInfo().getDataGeneratorSrcClusterName();
        srcDataGeneratorVolumeName = 
          srcVolProp.getMirrorInfo().getDataGeneratorSrcVolumeName();

        if (srcVolProp.getMirrorInfo().hasDataGeneratorSrcVolumeUUID()) {
          hasVolumeUUID = true;
          srcDataGeneratorVolumeUUID = 
            srcVolProp.getMirrorInfo().getDataGeneratorSrcVolumeUUID();
        }
      } else {
        srcDataGeneratorVolumeId = srcVolProp.getVolumeId();
        srcDataGeneratorClusterName = srcClusterName; 
        srcDataGeneratorVolumeName = srcVolumeName;
        if (srcVolProp.hasVolumeUUID()) {
          hasVolumeUUID = true;
          srcDataGeneratorVolumeUUID = 
            srcVolProp.getVolumeUUID();
        }
      }

      boolean volumeUUIDMatched = true;
        if (hasVolumeUUID && isDestMirrorVol &&
            destVolMirrorInfo.hasDataGeneratorSrcVolumeUUID()) {

        destDataGeneratorVolumeUUID =
            destVolMirrorInfo.getDataGeneratorSrcVolumeUUID();

        if (srcDataGeneratorVolumeUUID != destDataGeneratorVolumeUUID) {
          volumeUUIDMatched = false;
        }
      }
    
  
      if (isDestMirrorVol && ((destVolMirrorInfo.getDataGeneratorSrcVolumeId() 
           != srcDataGeneratorVolumeId) ||
          (destVolMirrorInfo.getDataGeneratorSrcClusterName()
              .compareTo(srcDataGeneratorClusterName) != 0) ||
          (volumeUUIDMatched == false))) {
        /**
        * <MAPR_ERROR>
        * Message:Can not update the 'source' property of Volume '<volume name>' 
        * because new source volume '<volume name>' containes data originated  
        * on volume <volume name>(<volume ID>)@<cluster name> and the volume 
        * '<volume name>' contains data originated from <volume name>(<volume ID>)@<cluster name>
        * Function:VolumeCommands.UpdateMirrorSourceVolumeName()
        * Meaning:The mirror volume's source volume cannot be changed 
        * because it already contains information from an existing source volume.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EINVAL, 
            "Can not update the 'source' property of Volume '" 
            + destVolumeName 
            + "' because new source volume '"
            + srcVolumeName + "' contains data originated "
            + " on volume " + srcDataGeneratorVolumeName 
            + "(" + srcDataGeneratorVolumeId + ")@" 
            + srcDataGeneratorClusterName
            + " volumeUUID " + srcDataGeneratorVolumeUUID
            + " and the volume '" + destVolumeName 
            + "' contains data originated from " 
            + destVolMirrorInfo.getDataGeneratorSrcVolumeName() 
            + "(" + destVolMirrorInfo.getDataGeneratorSrcVolumeId()+ ")@" 
            + destVolMirrorInfo.getDataGeneratorSrcClusterName()
            + " volumeUUID " + destDataGeneratorVolumeUUID));
        return Errno.EINVAL;
      }
    }
    
    if (srcVolProp.hasVolumetype() && destVolProp.hasVolumetype()) {
      if (IsItConvertibleVolume(srcVolProp.getVolumetype()) != 
          IsItConvertibleVolume(destVolProp.getVolumetype())) {
        out.addError(new OutputError(Errno.EINVAL, 
            "Can not update the 'source' property of Volume '" 
            + destVolumeName 
            + "' because new source volume type is not compatible."));
        return Errno.EINVAL;
      }
    }

    
    // TODO : Check for the condition where the new source volume 
    // is having less data than destination volume
        
    // Add the mirror info in the destination volume create request
    MirrorInfo.Builder mirror = MirrorInfo.newBuilder();
    mirror.setSrcVolumeId(srcVolumeLookupResp.getVolInfo().getVolumeId())
        	.setSrcVolumeName(srcVolumeName)
        	.setSrcClusterName(srcClusterName);
    volProps.setMirrorInfo(mirror.build());
    return 0;
  }
  
  private boolean canPerformVolumeAction(String clusterName, String volumeName,
      VolumeProperties volProps, int actionMask, CredentialsMsg creds, 
      OutputHierarchy out) throws CLIProcessingException
  {
    if (clusterName == null) {
      clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
    }
    return authManager.canPerformVolumeAction(clusterName, 
        volumeName, volProps, actionMask, creds, out);
  }
  
  // TODO: Handle ACEs in the following (FACE)
  CommandOutput volumeModify() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);
    
    String name =
      getRwVolumeName();
    List<String> rwVolumeNames = new ArrayList<String>();
    if (name.contains(MULTI_ARG_SEP)) {
      rwVolumeNames.addAll(Arrays.asList(name.split(
                                  VolumeCommands.MULTI_ARG_SEP)));
    } else {
      rwVolumeNames.add(name);
    }
    
    for (String rwVolumeName : rwVolumeNames) {
      VolumeUpdateRequest.Builder volumeUpdate = VolumeUpdateRequest.newBuilder();
      VolumeProperties.Builder volProps = VolumeProperties.newBuilder()
                                              .setVolumeName(rwVolumeName);
      
      VolumeProperties savedVolProps = volumePropetiesLookup(rwVolumeName);
      if (savedVolProps == null) {
        /**
        * <MAPR_ERROR>
        * Message:Volume Modify:  VolumeName: <volume name> <error> Volume not found
        * Function:VolumeCommands.volumeModify()
        * Meaning:The specified volume could not be found.
        * Resolution:Check the volume name and the command syntax, and try again.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EINVAL, "Volume Modify: " + 
            " VolumeName: " + rwVolumeName + Errno.toString(Errno.ENOENT) +
            " Volume not found"));
        /**
        * <MAPR_ERROR>
        * Message:Volume  <volume name> Volume not found
        * Function:VolumeCommands.volumeModify()
        * Meaning:The specified volume could not be found.
        * Resolution:Check the volume name and the command syntax, and try again.
        * </MAPR_ERROR>
        */
        LOG.error("Volume  " + rwVolumeName + " Volume not found");
        continue;
      }
      
      if ( isParamPresent(VolumeCommands.VOLUME_SCHEDULE)) {
      	int scheduleId = getParamIntValue(VOLUME_SCHEDULE, 0);
      	volProps.setSchedulingPolicyId(scheduleId);
      }

      if ( isParamPresent(VolumeCommands.VOLUME_MIRROR_SCHEDULE)) {
    	  int scheduleId = getParamIntValue(VOLUME_MIRROR_SCHEDULE, 0);
      	volProps.setMirrorSchedulingPolicyId(scheduleId);
      }

      if (isParamPresent(VOLUME_LIMIT_SPREAD)) {
        boolean limitSpread = getParamBooleanValue(VOLUME_LIMIT_SPREAD, 0);
        volProps.setLimitVolumeSpread(limitSpread);
      }

      if (isParamPresent(ALLOW_GRANT)) {
        boolean grant = getParamBooleanValue(ALLOW_GRANT, 0);
        volProps.setAllowGrant(grant);
      }

      if (isParamPresent(VolumeCommands.RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC)) {
        int timeout = getParamIntValue(VolumeCommands
            .RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, 0);
        volProps.setReReplicationTimeOutSec(timeout);
      }

      if (isParamPresent(VolumeCommands.RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC)) {
        int timeout = getParamIntValue(VolumeCommands
            .RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC, 0);
        volProps.setCriticalReReplicationTimeOutSec(timeout);
      }

      if (isParamPresent(RW_FIX_CREATOR_ID)) {
        boolean val = getParamBooleanValue(RW_FIX_CREATOR_ID,
                                           0);
        if (!val) {
          out.addError(new OutputError(Errno.EINVAL, "Volume Modify: " + 
              " VolumeName: " + rwVolumeName +
              " Invalid value for " + RW_FIX_CREATOR_ID));
          continue;
        }
        volProps.setUseActualCreatorId(true);
      }

      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_REPLICATION) ||
          isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MIN_REPLICATION) ||
          isParamPresent(VolumeCommands.RW_VOLUME_PARAM_DCREPLTYPE)) {
        ReplicationPolicy.Builder replPolicy = ReplicationPolicy.newBuilder();

        int repl = savedVolProps.getReplicationPolicy().getNumReplicas();
        if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_REPLICATION)) {
          repl = getParamIntValue(VolumeCommands.RW_VOLUME_PARAM_REPLICATION, 0);
          if (repl > 0) {
            replPolicy.setNumReplicas(repl);
            if (repl > maxVolumeReplicationFactor) {
              /**
              * <MAPR_ERROR>
              * Message:Volume modify of <volume name> failed. The maximum value allowed for the replication factor is <replication factor> while the requested value is <value>
              * Function:VolumeCommands.volumeModify()
              * Meaning:The specified replication factor is too high.
              * Resolution:Try again, specifying a replication factor below the maximum allowed value.
              * </MAPR_ERROR>
              */
              out.addError(new OutputError(Errno.EINVAL,
                  "Volume modify of "
                  + rwVolumeName
                  + " failed. The maximum value allowed for the replication factor is " 
                  + maxVolumeReplicationFactor
                  + " while the requested value is "
                  + repl));
              /**
              * <MAPR_ERROR>
              * Message:Requested replication factor too large for volume modify <replication factor>
              * Function:VolumeCommands.volumeModify()
              * Meaning:The specified replication factor is too high.
              * Resolution:Try again, specifying a replication factor below the maximum allowed value.ort.
              * </MAPR_ERROR>
              */
              LOG.error("Requested replication factor too large for volume modify " + repl);
              return output;
            }
          } else {
            /**
            * <MAPR_ERROR>
            * Message:Volume Modify:  VolumeName: <volume name> <error> Invalid replication
            * Function:VolumeCommands.volumeModify()
            * Meaning:An invalid replication factor was specified.
            * Resolution:Check the replication factor and the command syntax, and try again.
            * </MAPR_ERROR>
            */
            out.addError(new OutputError(Errno.EINVAL, "Volume Modify: " + 
                " VolumeName: " + rwVolumeName + Errno.toString(Errno.EINVAL) +
                " Invalid replication"));
            /**
            * <MAPR_ERROR>
            * Message:
            * Function:VolumeCommands.volumeModify()
            * Meaning:An invalid replication factor was specified.
            * Resolution:Check the replication factor and the command syntax, and try again.
            * </MAPR_ERROR>
            */
            LOG.error("Invalid replication for Volume modify " + repl);
            continue;
          }
        }
        
        if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MIN_REPLICATION)) {
          int minRepl = getParamIntValue(VolumeCommands
              .RW_VOLUME_PARAM_MIN_REPLICATION, 0);
          if (minRepl > 0) {
            if (repl > 0 && minRepl > repl) {
              /**
              * <MAPR_ERROR>
              * Message:Volume Modify:  VolumeName: <volume name> <error> Min replication greater than replication
              * Function:VolumeCommands.volumeModify()
              * Meaning:The minimum replication factor specified is greater than the volume's current replication.
              * Resolution:Try again, choosing a minimum replication factor lower than the volume's replication.
              * </MAPR_ERROR>
              */
              out.addError(new OutputError(Errno.EINVAL, "Volume Modify: " + 
                  " VolumeName: " + rwVolumeName + Errno.toString(Errno.EINVAL) +
                  " Min replication greater than replication"));
              /**
              * <MAPR_ERROR>
              * Message:Volume modify with minreplication <replication> greater than replicaton
              * Function:VolumeCommands.volumeModify()
              * Meaning:The minimum replication factor specified is greater than the volume's current replication.
              * Resolution:Try again, choosing a minimum replication factor lower than the volume's replication.
              * </MAPR_ERROR>
              */
              LOG.error("Volume modify with minreplication " + repl +
                        "greater than replicaton");
              continue;
            }
            replPolicy.setGuaranteedMinReplicas(minRepl);
          } else {
            /**
            * <MAPR_ERROR>
            * Message:Volume Modify:  VolumeName: <volume name> <error> Invalid min replication
            * Function:VolumeCommands.volumeModify()
            * Meaning:The specified minimum replication factor is invalid.
            * Resolution:Check the minimum replication factor and the command syntax, and try again.
            * </MAPR_ERROR>
            */
            out.addError(new OutputError(Errno.EINVAL, "Volume Modify: " + 
                " VolumeName: " + rwVolumeName + Errno.toString(Errno.EINVAL) +
                " Invalid min replication"));
            /**
            * <MAPR_ERROR>
            * Message:Volume modify with invalid minreplication <replication>
            * Function:VolumeCommands.volumeModify()
            * Meaning:The specified minimum replication factor is invalid.
            * Resolution:Check the minimum replication factor and the command syntax, and try again.
            * </MAPR_ERROR>
            */
            LOG.error("Volume modify with invalid minreplication " + repl);
            continue;
          }
        } else {
          if (savedVolProps.getReplicationPolicy().getGuaranteedMinReplicas() > repl) {
            out.addError(new OutputError(Errno.EINVAL, "VolumeModify: VolumeName: " +
                rwVolumeName + ". Replication is less than min replication of " +
                savedVolProps.getReplicationPolicy().getGuaranteedMinReplicas() +
                ". Please specify both replication and minreplication"));
            continue;
          }
        }

        if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_DCREPLTYPE)) {
          String stype = getParamTextValue(VolumeCommands.RW_VOLUME_PARAM_DCREPLTYPE, 0);
          ContainerReplType rtype = getContainerReplType(stype);
          if (rtype == ContainerReplType.INVALID) {
            out.addError(new OutputError(Errno.EOPFAILED, "Volume modification of " + 
                rwVolumeName + " failed, due to invalid replicationtype " +
                stype));
            continue;
          }
          replPolicy.setDataContainerReplType(rtype);
        }
        
        volProps.setReplicationPolicy(replPolicy.build());
      }

      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_REPLICATION) ||
          isParamPresent(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION)) {

        int repl = 0;
        if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_REPLICATION)) {
          repl = getParamIntValue(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_REPLICATION, 0);    
          if (repl <= 0) {
            /**
            * <MAPR_ERROR>
            * Message:Volume Modify:  VolumeName: <volume name> <error> Invalid namespace replication
            * Function:VolumeCommands.volumeModify()
            * Meaning:An invalid namespace replication factor was specified.
            * Resolution:Check the replication factor and the command syntax, and try again.
            * </MAPR_ERROR>
            */
            out.addError(new OutputError(Errno.EINVAL, "Volume Modify: " + 
                " VolumeName: " + rwVolumeName + ", " + Errno.toString(Errno.EINVAL) +
                " Invalid namespace replication"));
            /**
            * <MAPR_ERROR>
            * Message:
            * Function:VolumeCommands.volumeModify()
            * Meaning:An invalid namespace replication factor was specified.
            * Resolution:Check the namespace replication factor and the command syntax, and try again.
            * </MAPR_ERROR>
            */
            LOG.error("Invalid namespace replication for Volume modify " + repl);
            continue;
          }
          if (repl > maxVolumeReplicationFactor) {
            /**
             * <MAPR_ERROR>
             * Message:Volume modify of <volume name> failed. The maximum value allowed for the
             * namespace replication factor is <replication factor> while the requested value is <value>
             * Function:VolumeCommands.volumeModify()
             * Meaning:The specified namespace replication factor is too high.
             * Resolution:Try again, specifying a namespace replication factor below the maximum allowed value.
             * </MAPR_ERROR>
             */
            out.addError(new OutputError(Errno.EINVAL,
                  "Volume modify of "
                  + rwVolumeName
                  + " failed. The maximum value allowed for the namespace replication factor is " 
                  + maxVolumeReplicationFactor
                  + " while the requested value is "
                  + repl));
            /**
             * <MAPR_ERROR>
             * Message:Requested replication factor too large for volume modify <replication factor>
             * Function:VolumeCommands.volumeModify()
             * Meaning:The specified namespace replication factor is too high.
             * Resolution:Try again, specifying a namespace replication factor below the maximum allowed value.ort.
             * </MAPR_ERROR>
             */
            LOG.error("Requested namespace replication factor too large for volume modify " + repl);
            return output;
          }
          volProps.setNumNamespaceReplicas(repl);
        } else {
          repl = savedVolProps.getNumNamespaceReplicas();
        }

        if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION)) {
          int minRepl = getParamIntValue(VolumeCommands
                                        .RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, 0);
          if (minRepl <= 0) {
            /**
            * <MAPR_ERROR>
            * Message:Volume Modify:  VolumeName: <volume name> <error> Invalid namespace min replication
            * Function:VolumeCommands.volumeModify()
            * Meaning:The specified namespace minimum replication factor is invalid.
            * Resolution:Check the namespace minimum replication factor and the command syntax, and try again.
            * </MAPR_ERROR>
            */
            out.addError(new OutputError(Errno.EINVAL, "Volume Modify: " + 
                " VolumeName: " + rwVolumeName + ", " + Errno.toString(Errno.EINVAL) +
                " Invalid namespace min replication"));
            /**
            * <MAPR_ERROR>
            * Message:Volume modify with invalid namespace minreplication <replication>
            * Function:VolumeCommands.volumeModify()
            * Meaning:The specified namespace minimum replication factor is invalid.
            * Resolution:Check the namespace minimum replication factor and the command syntax, and try again.
            * </MAPR_ERROR>
            */
            LOG.error("Volume modify with invalid namespace minreplication " + repl);
            return output;
          }
          if (minRepl > repl) {
            /**
             * <MAPR_ERROR>
             * Message:Volume Modify:  VolumeName: <volume name> <error> Min namespace replication greater than namespace replication
             * Function:VolumeCommands.volumeModify()
             * Meaning:The minimum namespace replication factor specified is greater than the volume's current replication.
             * Resolution:Try again, choosing a minimum namespace replication factor lower than the volume's replication.
             * </MAPR_ERROR>
             */
            out.addError(new OutputError(Errno.EINVAL, "Volume Modify: " + 
                  " VolumeName: " + rwVolumeName + ", " + Errno.toString(Errno.EINVAL) +
                  " Min namespace replication greater than replication"));
            /**
             * <MAPR_ERROR>
             * Message:Volume modify with minreplication <replication> greater than replicaton
             * Function:VolumeCommands.volumeModify()
             * Meaning:The minimum replication factor specified is greater than the volume's current replication.
             * Resolution:Try again, choosing a minimum replication factor lower than the volume's replication.
             * </MAPR_ERROR>
             */
            LOG.error("Volume modify with namespace minreplication " + repl +
                "greater than replicaton");
            continue;
          }
          volProps.setGuaranteedMinNamespaceReplicas(minRepl);
        } else {
          if (savedVolProps.getGuaranteedMinNamespaceReplicas() > repl) {
            out.addError(new OutputError(Errno.EINVAL, "VolumeModify: VolumeName: " +
                rwVolumeName + ". namespace Replication is less than namespace min replication of " +
                savedVolProps.getGuaranteedMinNamespaceReplicas() +
                ". Please specify both namespace replication and namespace minreplication"));
            continue;
          }
        }
      }
          
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_READONLY)) {
        boolean readOnly = 
        	getParamBooleanValue(VolumeCommands.RW_VOLUME_PARAM_READONLY, 0);
        volProps.setReadOnly(readOnly);
      }
      
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MIRRORTHROTTLE)) {
        boolean mirrorThrottle = 
        	getParamBooleanValue(VolumeCommands.RW_VOLUME_PARAM_MIRRORTHROTTLE, 0);
        volProps.setMirrorThrottle(mirrorThrottle);
      }
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_AE) ||
          isParamPresent(VolumeCommands.RW_VOLUME_PARAM_AETYPE)) {
        if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_AETYPE) &&
            (!isParamPresent(VolumeCommands.RW_VOLUME_PARAM_AE))) {
          /**
          * <MAPR_ERROR>
          * Message:Please specify both <parameter> and <parameter> while modifying AE for volume <volume name>
          * Function:VolumeCommands.volumeModify()
          * Meaning:One or more required parameters is missing.
          * Resolution:Check the command syntax and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EINVAL, 
              "Please specify both " + VolumeCommands.RW_VOLUME_PARAM_AETYPE +
              " and " + VolumeCommands.RW_VOLUME_PARAM_AE + 
              " while modifying AE for volume " + rwVolumeName));
          continue;
        }
        String aename = getParamTextValue(VolumeCommands.RW_VOLUME_PARAM_AE, 0);
        boolean aetype = isParamPresent(VolumeCommands.RW_VOLUME_PARAM_AETYPE) ?
            getParamBooleanValue(VolumeCommands.RW_VOLUME_PARAM_AETYPE, 0) : false;
        if (!checkEntityExists(aetype, aename)) {
          /**
          * <MAPR_ERROR>
          * Message:Invalid AE specified while trying to modify Volume <volume name>
          * Function:VolumeCommands.volumeModify()
          * Meaning:The user or group specified does not exist.
          * Resolution:Check the user or group name and the command syntax, and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EINVAL, 
              "Invalid AE specified while trying to modify Volume " + rwVolumeName));
          /**
          * <MAPR_ERROR>
          * Message:Volume modify with invalid AE 
          * Function:VolumeCommands.volumeModify()
          * Meaning:The user or group specified does not exist.
          * Resolution:Check the user or group name and the command syntax, and try again.
          * </MAPR_ERROR>
          */
          LOG.error("Volume modify with invalid AE ");
          continue;
        }
        AeKey.Builder keyBuilder = AeKey.newBuilder();
        keyBuilder.setName(aename);
        keyBuilder.setType(aetype);
        volProps.setVolumeAe(keyBuilder);
      }

      long quotaMB = savedVolProps.getVolumeQuotaSizeMB();
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_QUOTA)) {
        String quotaString = getParamTextValue(
                          VolumeCommands.RW_VOLUME_PARAM_QUOTA, 0);
        quotaMB = MapRCliUtil.quotaStringToMB(quotaString);
        if (quotaMB < 0) {
          /**
          * <MAPR_ERROR>
          * Message:Volume Modify:  VolumeName: <volume name> <error> Invalid quota size. Should be either an Integer, or a decimal value followed by one of (M,MB,G,GB,T,TB,P,PB)
          * Function:VolumeCommands.volumeModify()
          * Meaning:The quota size must be specified as a number and letter specifying a number of units. Example: 500GB specifies a quota size of 500 gigabytes.
          * Resolution:Check the command syntax and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EINVAL, "Volume Modify: " + 
              " VolumeName: " + rwVolumeName + Errno.toString(Errno.EINVAL) +
              " Invalid quota size. Should be either an Integer, or a decimal value" +
              " followed by one of (M,MB,G,GB,T,TB,P,PB)"));
          /**
          * <MAPR_ERROR>
          * Message:Invalid quota during Volume modify <quota>
          * Function:VolumeCommands.volumeModify()
          * Meaning:The quota size must be specified as a number and letter specifying a number of units. Example: 500GB specifies a quota size of 500 gigabytes.
          * Resolution:Check the command syntax and try again.
          * </MAPR_ERROR>
          */
          LOG.error("Invalid quota during Volume modify " + quotaString);
          continue;
        }
        volProps.setVolumeQuotaSizeMB(quotaMB);
      }
      
      long advisoryQuotaMB = savedVolProps.getVolumeQuotaAdvisorySizeMB();
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_ADVISORY_QUOTA)) {
        String quotaString = getParamTextValue(
                   VolumeCommands.RW_VOLUME_PARAM_ADVISORY_QUOTA, 0);
        advisoryQuotaMB = MapRCliUtil.quotaStringToMB(quotaString);
        if (advisoryQuotaMB == -1) {     
          /**
          * <MAPR_ERROR>
          * Message:Volume Modify:  VolumeName: <volume name> <error> Invalid advisory quota size. Should be either an Integer, or a decimal value followed by one of (M,MB,G,GB,T,TB,P,PB)
          * Function:VolumeCommands.volumeModify()
          * Meaning:The advisory quota size must be specified as a number and letter specifying a number of units. Example: 500GB specifies an advisory quota size of 500 gigabytes.
          * Resolution:Check the command syntax and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EINVAL, "Volume Modify: " + 
              " VolumeName: " + rwVolumeName + Errno.toString(Errno.EINVAL) +
              " Invalid advisory quota size. Should be either an Integer, or a decimal value" +
              " followed by one of (M,MB,G,GB,T,TB,P,PB)"));
          /**
          * <MAPR_ERROR>
          * Message:Invalid advisory quota during Volume modify <quota>
          * Function:VolumeCommands.volumeModify()
          * Meaning:The advisory quota size must be specified as a number and letter specifying a number of units. Example: 500GB specifies an advisory quota size of 500 gigabytes.
          * Resolution:Check the command syntax and try again.
          * </MAPR_ERROR>
          */
          LOG.error("Invalid advisory quota during Volume modify " + quotaString);
          continue;
        }
        volProps.setVolumeQuotaAdvisorySizeMB(advisoryQuotaMB);
      }
      
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_ADVISORY_QUOTA) ||
          isParamPresent(VolumeCommands.RW_VOLUME_PARAM_QUOTA)) {
        if ((quotaMB > 0) && (advisoryQuotaMB > quotaMB)) {
          /**
          * <MAPR_ERROR>
          * Message:Volume modify of <volume> with advisory quota greater than volume quota <advisory quota>
          * Function:VolumeCommands.volumeModify()
          * Meaning:The advisory quota must be lower than the quota.
          * Resolution:Check the command syntax and the advisory quota, and try again.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED, 
              "Volume modify of " + rwVolumeName + 
              " with advisory quota greater than volume quota")
              .setField(RW_VOLUME_PARAM_ADVISORY_QUOTA));        
          return output;
        }
      }

      if (isParamPresent(VolumeCommands.ADD_VOLUME_NOTE) &&
          isParamPresent(VolumeCommands.RESOLVE_VOLUME_NOTE)) {
        out.addError(new OutputError(Errno.EOPFAILED, 
              "Volume modify: Volumename " + rwVolumeName + 
              " failed. Only one of addNotes or resolveNote can be specified at a time."));
          return output;
      }

      if (isParamPresent(VolumeCommands.ADD_VOLUME_NOTE) ||
          isParamPresent(VolumeCommands.RESOLVE_VOLUME_NOTE)) {
        StringBuilder msg = new StringBuilder();
        NoteOperation noteOper = getNoteOperation(msg);
        if (noteOper == null) {
          out.addError(new OutputError(Errno.EOPFAILED, 
                "Volume modify: Volumename " + rwVolumeName + 
                " failed. " + msg.toString()));
          return output;
        }
        volumeUpdate.setNoteOp(noteOper);
      }

      if (isParamPresent(VolumeCommands.PRESERVE_VOLUME)) {
        if (savedVolProps.hasIsWorm() && savedVolProps.getIsWorm()) {
          out.addError(new OutputError(Errno.EOPFAILED, 
                "Volume modify: Volumename " + rwVolumeName + 
                " already a worm volume."));
          return output;
        }
        boolean preserve = getParamBooleanValue(VolumeCommands.PRESERVE_VOLUME, 0);
        WormSettings.Builder wsb = WormSettings.newBuilder();

        if (preserve) {
          if (isParamPresent(VolumeCommands.CHECKIN_TIME_MIN)) {
            int checkin = getParamIntValue(VolumeCommands.CHECKIN_TIME_MIN, 0);
            wsb.setCommitTimeMinutes(checkin);
          }
          if (isParamPresent(VolumeCommands.RETENTION_PERIOD_DAYS)) {
            int retain = getParamIntValue(VolumeCommands.RETENTION_PERIOD_DAYS, 0);
            wsb.setRetentionPeriodDays(retain);
          }
        }
        volProps.setIsWorm(true);        
        volProps.setWormConfig(wsb.build());        
      }

      // Update the mirror source information for the volume
      if (isParamPresent(VolumeCommands.MIRROR_VOLUME_SRC_VOLUMENAME)) {
        int err = UpdateMirrorSourceVolumeName(rwVolumeName, volProps, out);
        if (err != 0) {
          /**
          * <MAPR_ERROR>
          * Message:Failed to update the mirror source volume inforation  for volume <volume name> input source volume name <source volume name>
          * Function:VolumeCommands.volumeModify()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          LOG.error("Failed to update the mirror source volume inforation "
              + " for volume " + rwVolumeName 
              + " input source volume name " + 
              getParamTextValue(VolumeCommands.MIRROR_VOLUME_SRC_VOLUMENAME, 0));
          continue;
        } else {
          volumeUpdate.setMirrorOp(
              VolumeUpdateRequest.MirrorOp.MIRROR_SRC_UPDATE);
        }
      }
      
      // audit volume parameters
      if (cliCommand.getCommandName().equalsIgnoreCase("audit")) {
        if (isParamPresent(VolumeCommands.VOLUME_AUDIT_ENABLED)) {
          boolean audited = getParamBooleanValue(VOLUME_AUDIT_ENABLED, 0);
          volProps.setAudited(audited);
        }
      } else {
        if (isParamPresent(VolumeCommands.AUDIT_ENABLED)) {
          boolean audited = getParamBooleanValue(AUDIT_ENABLED, 0);
          volProps.setAudited(audited);
        }
      }
    
      if (isParamPresent(VolumeCommands.AUDIT_COALESCE_INTERVAL)) {
        int coalesceInterval = getParamIntValue(AUDIT_COALESCE_INTERVAL, 0);
        if (coalesceInterval < 0) {
          out.addError(new OutputError(Errno.EINVAL,
                        "Coalesce interval cannot be negative"));
          return output;
        }
        volProps.setCoalesceInterval(coalesceInterval);
      }
  
      List<FSAuditOperations> fsAuditEnableOperations =
        new ArrayList<FSAuditOperations>(); 
      List<FSAuditOperations> fsAuditDisableOperations =
        new ArrayList<FSAuditOperations>(); 
      if (isParamPresent(VolumeCommands.FSAUDIT_OPS)) {
        String fsOperations = getParamTextValue(FSAUDIT_OPS, 0);
        if (!validateAndAddFsOperations(fsAuditEnableOperations,
               fsAuditDisableOperations, fsOperations)) {
          out.addError(new OutputError(Errno.EINVAL,
                      "Invalid dataauditops text specified, text = " +
                      fsOperations));
          return output;
        }
      }

      // validate for "all" option
      if (fsAuditEnableOperations.contains(FSAuditOperations.AuditAll) &&
          (fsAuditEnableOperations.size() > 1)) {
        out.addError(new OutputError(Errno.EINVAL, "When specifying +all, " +
          " cannot enable any other operation"));
        return output;
      }
      if (fsAuditDisableOperations.contains(FSAuditOperations.AuditAll) &&
          (fsAuditDisableOperations.size() > 1)) {
        out.addError(new OutputError(Errno.EINVAL, "When specifying -all, " +
          " cannot disable any other operation"));
        return output;
      }

      // Validate that any audit op is not specified both in enable and disable
      for (int i = 0; i < fsAuditEnableOperations.size();i++) {
        if (fsAuditDisableOperations.contains(fsAuditEnableOperations.get(i))) {
          out.addError(new OutputError(Errno.EINVAL, "Cannot specify an audit " + 
            "operation both for enable and disable"));
          return output;
        }
      }

      for (FSAuditOperations op: fsAuditEnableOperations)
        LOG.info("Enable Op = " + op.toString());
      for (FSAuditOperations op: fsAuditDisableOperations)
        LOG.info("Disable Op = " + op.toString());

      volumeUpdate.addAllFsAuditEnableOperations(fsAuditEnableOperations);
      volumeUpdate.addAllFsAuditDisableOperations(fsAuditDisableOperations);

      boolean permsPresent = false;
      AccessControlList.Builder aclBuilder = AccessControlList.newBuilder();
      if (isParamPresent(USERPERM_PARAM_NAME)) {
        permsPresent = true;
        List<String> perms = input.getParameterByName (USERPERM_PARAM_NAME).getParamValues();
        List<String> userNames = getUserGroupsNames(perms);
        boolean failed = false;
        for (String userName : userNames) {
          if (!checkEntityExists(false, userName)) {
            /**
            * <MAPR_ERROR>
            * Message:Volume modify for volume <volume name> failed - user <user name> not found
            * Function:VolumeCommands.volumeModify()
            * Meaning:The user running the {{volume modify}} command does not appear to exist.
            * Resolution:Check the user name and the command syntax, and try again.
            * </MAPR_ERROR>
            */
            out.addError(new OutputError(Errno.EOPFAILED,
                "Volume modify for volume "+  rwVolumeName + 
                " failed - user " + userName + " not found")
                .setField(USERPERM_PARAM_NAME));
            failed = true;
          }
        }
        if (failed)
          continue;
        List<AclEntry> elements = AclCommands.actionsToAcls(perms, uInfo, 
            SecureObjectType.OBJECT_TYPE_VOLUME, true, out); 
        if (elements == null) {
          /**
          * <MAPR_ERROR>
          * Message:Volume modify failed - invalid list of user permissions - <permissions>
          * Function:VolumeCommands.volumeModify()
          * Meaning:Cannot determine if the user has sufficient permissions to modify the volume, because the permissions list is invalid.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED,
              "Volume modify failed - invalid list of user permissions - " + perms)
              .setField(USERPERM_PARAM_NAME));
          continue;
        }
        aclBuilder.addAllAcl(elements);
      }

      if (isParamPresent(GROUPPERM_PARAM_NAME)) {
        permsPresent = true;
        List<String> perms = input.getParameterByName (GROUPPERM_PARAM_NAME).getParamValues();
        List<String> groupNames = getUserGroupsNames(perms);
        boolean failed = false;
        for (String groupname : groupNames) {
          if (!checkEntityExists(true, groupname)) {
            /**
            * <MAPR_ERROR>
            * Message:Volume modify for volume <volume name> failed - group <group> not found
            * Function:VolumeCommands.volumeModify()
            * Meaning:The specified group was not found.
            * Resolution:Check the command syntax and the group, and try again.
            * </MAPR_ERROR>
            */
            out.addError(new OutputError(Errno.EOPFAILED,
                "Volume modify for volume "+  rwVolumeName + 
                " failed - group " + groupname + " not found")
                .setField(USERPERM_PARAM_NAME));
            failed = true;
          }
        }
        if (failed) {
          continue;
        }
        List<AclEntry> elements = AclCommands.actionsToAcls(perms, uInfo, 
            SecureObjectType.OBJECT_TYPE_VOLUME, false, out); 
        if (elements == null) {
          /**
          * <MAPR_ERROR>
          * Message:Volume modify failed - invalid list of group permissions - <permissions>
          * Function:VolumeCommands.volumeModify()
          * Meaning:Cannot determine if the user has sufficient permissions to modify the volume, because the permissions list is invalid.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
          out.addError(new OutputError(Errno.EOPFAILED,
              "Volume create failed - invalid list of group permissions - " + perms)
              .setField(GROUPPERM_PARAM_NAME));
          continue;
        }
        aclBuilder.addAllAcl(elements);
      }

      if (permsPresent) {
        volProps.setAcl(aclBuilder);
      }
      
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD)) {
        long maxInodes = getParamLongValue(VolumeCommands
            .RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, 0);
        volProps.setMaxInodesAlarmThreshold(maxInodes);
      }
      if (isParamPresent(VolumeCommands.RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH)) {
        int thresh = getParamIntValue(VolumeCommands
            .RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, 0);
        volProps.setDbReplLagSecAlarmThresh(thresh);
      }

      volumeUpdate.setVolProperties(volProps.build());
      volumeUpdate.setCreds(getUserCredentials());
                                                          
      boolean failed = volumeChangeMirrorMode(rwVolumeName, savedVolProps, out);
      if (failed) {
        continue;
      }

      VolumeAces volumeAces = null;
      try {
        volumeAces = buildVolumeAcesProtobuf(volumeAceParameterMap);
      }
      catch (IOException e) {
        LOG.error("Unable to parse volume ace arguments");
        out.addError(new OutputError(Errno.EINVAL,
            "Error Parsing Volume Aces: " + e.getMessage()));
        /*
         * The error is in parsing the Access Control Expressions. No reason
         * to continue with other volumes, just return the error.
         */
        return output;
      }
      if (volumeAces != null) {
        volumeUpdate.setVolumeAces(volumeAces);
      }

      byte[] data = null;
      /* send the RPC request to the CLDB master */
      try {
        if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
          data = CLDBRpcCommonUtils.getInstance()
              .sendRequest(getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0),
              Common.MapRProgramId.CldbProgramId.getNumber(),
              CLDBProto.CLDBProg.VolumeUpdateProc.getNumber(), 
              volumeUpdate.build(), VolumeUpdateResponse.class);
        } else {
          data = CLDBRpcCommonUtils.getInstance()
              .sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(),
              CLDBProto.CLDBProg.VolumeUpdateProc.getNumber(), 
              volumeUpdate.build(), VolumeUpdateResponse.class);
        }

         if (data == null) {
          /**
          * <MAPR_ERROR>
          * Message:Exception while processing RPC
          * Function:VolumeCommands.volumeModify()
          * Meaning:An error occurred.
          * Resolution:Contact technical support.
          * </MAPR_ERROR>
          */
        	 out.addError(new OutputError(Errno.ERPCFAILED, "Couldn't connect to the CLDB service"));
        	 return output;
        }
        VolumeUpdateResponse resp = VolumeUpdateResponse.parseFrom(data);
        if (LOG.isInfoEnabled()) {
          LOG.info(resp.getErrMsg());
        }
        if (resp.getStatus() != 0) {
          out.addError(new OutputError(resp.getStatus(),resp.getErrMsg()));
        }
        continue;

      } catch (MaprSecurityException e) {
        throw new CLIProcessingException(
          "MaprSecurityException " + "Exception", e);
      } catch (Exception e) {
        /**
        * <MAPR_ERROR>
        * Message:Volume Modify:  VolumeName: <volume name> <error> Volume modify failed
        * Function:VolumeCommands.volumeModify()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        out.addError(new OutputError(Errno.EOPFAILED, "Volume Modify: " + 
            " VolumeName: " + rwVolumeName + Errno.toString(Errno.EOPFAILED) +
            " Volume modify failed"));
        /**
        * <MAPR_ERROR>
        * Message:Exception during Volume modify <error>
        * Function:VolumeCommands.volumeModify()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        LOG.error("Exception during Volume modify ", e);
        continue;
      }
    }
    return output;
  }
  
  private NoteOperation getNoteOperation(StringBuilder msg) throws CLIProcessingException {
    NoteOperation.Builder noBuilder = NoteOperation.newBuilder();

    if (isParamPresent(VolumeCommands.ADD_VOLUME_NOTE)) {
       noBuilder.setOper(NoteOperationEnum.NOTE_OP_ADD)
                .setNoteName(getParamTextValue(VolumeCommands.ADD_VOLUME_NOTE, 0));
    } else if (isParamPresent(VolumeCommands.RESOLVE_VOLUME_NOTE)) {
       noBuilder.setOper(NoteOperationEnum.NOTE_OP_RESOLVE)
                .setNoteName(getParamTextValue(VolumeCommands.RESOLVE_VOLUME_NOTE, 0));
    } else {
      msg.append("invalid operation for volumenote.");
      return null;
    }

    if (!isParamPresent(VolumeCommands.NOTE_COMMENT)) {
      msg.append("Volumenote cannot be modified without comments.");
      return null;
    }

    return noBuilder.setComment(getParamTextValue(VolumeCommands.NOTE_COMMENT, 0))
                    .build();
  }

  private VolumeProperties volumePropetiesLookup(String volumeName) throws CLIProcessingException {
    return volumePropetiesLookup(volumeName, true);
  }

  private VolumeProperties volumePropetiesLookup(String volumeName, boolean needsRootCid) throws CLIProcessingException {
    VolumeLookupResponse resp = null;
    byte[] data = null;
    
    VolumeLookupRequest req = VolumeLookupRequest.newBuilder()
                                      .setVolumeName(volumeName)
                                      .setNeedsRootCid(needsRootCid)
                                      .setCreds(getUserCredentials())
                                      .build();
    try {
        if ( isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
      	  data = CLDBRpcCommonUtils.getInstance().sendRequest(getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0),
      			  Common.MapRProgramId.CldbProgramId.getNumber(),
      			CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), 
                req, VolumeLookupResponse.class);
        } else {
      	  data = CLDBRpcCommonUtils.getInstance().sendRequest(
      			  Common.MapRProgramId.CldbProgramId.getNumber(),
      			CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), 
                req, VolumeLookupResponse.class);
        }

      if (data == null) {
        /**
        * <MAPR_ERROR>
        * Message:volumePropetiesLookup RPC to CLDB failed for volume <volume name>
        * Function:VolumeCommands.volumePropetiesLookup()
        * Meaning:An error occurred.
        * Resolution:Contact technical support.
        * </MAPR_ERROR>
        */
        LOG.error("volumePropetiesLookup RPC to CLDB failed for volume " + volumeName);
        return null;
      }
      resp = VolumeLookupResponse.parseFrom(data);
      if (resp.getStatus() == 0) {
        return resp.getVolInfo().getVolProperties(); 
      }
    } catch (MaprSecurityException e) {
      throw new CLIProcessingException(
        "MaprSecurityException " + "Exception", e);
    } catch (Exception e) {
      /**
      * <MAPR_ERROR>
      * Message:Exception during volumePropetiesLookup RPC to CLDB <error>
      * Function:VolumeCommands.volumePropetiesLookup()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      LOG.error("Exception during volumePropetiesLookup RPC to CLDB " + 
          e.getLocalizedMessage());
      return null;
    }
    return null;
  }

  CommandOutput volumeFixMountPath() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);

    List<String> volumeNames = new ArrayList<String>();

    String rwVolumeName = getRwVolumeName();
    if (!rwVolumeName.contains(MULTI_ARG_SEP)) {
      volumeNames.add(rwVolumeName);
    } else {
      volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
    }

    MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
    String cluster = null;
    if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
      cluster = getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM, 0);
    }

    final MapRClusterDefaults mapRClusterDefaults =
                MapRClusterDefaults.getDefaultInstance();

    for (String volName : volumeNames) {
      VolumeProperties volProps = this.volumePropetiesLookup(volName);
      if (volProps == null) {
        /**
         * <MAPR_ERROR>
         *  Failed to fix volume mount path
         * </MAPR_ERROR>
         */
        String msg = "could not find volume properties for " + volName;
        out.addError(new OutputError(Errno.ENOENT, msg));
        LOG.error(msg);
        continue;
      }

      if (! volProps.getMounted()) {
        String msg = String.format ("volume: %s not mounted", volName);
        LOG.warn(msg);
        out.addError(new OutputError(Errno.EINVAL, msg));
        continue;
      }

      String rwVolumeMountDir = volProps.getMountDir();
      FidMsg parentFid = volProps.getParentFid();

      if (mapRClusterDefaults.getClusterRootName().equals(volName)) {
        // dont mess with mapr.cluster.root
        String msg = String.format (
            "volume %s found mounted at: %s (no change required)",
                rwVolumeName, rwVolumeMountDir);
        out.addMessage(msg);
        LOG.info(msg);
        continue;
      }

      int index = rwVolumeMountDir.lastIndexOf('/');
      if (index == -1) {
        String msg = "Could not determine mount filename in dir: " +
                rwVolumeMountDir;
        out.addError(new OutputError(Errno.EINVAL, msg));
        LOG.error(msg);
      }

      final String mntName = rwVolumeMountDir.substring(index); // keep the '/'

      // status
      //  null: failed
      String newPath = fs.getMountPath (
              cluster,
              getUserLoginId(),
              parentFid.getCid(),
              parentFid.getCinum(),
              parentFid.getUniq());

      if (newPath == null) {
        // failed.
        String msg = String.format (
          "could not find mountPath for volume %s (fs.getMountPath() returned null)",
                volName);

        LOG.error (msg);
        out.addError(new OutputError(Errno.EOPFAILED, msg));
        continue;
      }

      LOG.debug("Volume fixmountpath: getNewMountPath returned: " + newPath);

      // the getMountPath() only gives us the parent directory.
      newPath += mntName;

      if (newPath.equals(rwVolumeMountDir)) {
        String msg = String.format (
            "volume %s found mounted at: %s (no change required)",
                rwVolumeName, rwVolumeMountDir);
        out.addMessage(msg);
        LOG.info(msg);
        continue;
      }

      // changed: Send to CLDB
      if (LOG.isDebugEnabled())
        LOG.debug("volume fixmountpath" + volName);

      byte[] data = null;
      VolumeProperties newVolProps = VolumeProperties.newBuilder()
                          .setVolumeName(volName)
                          .setMountDir(newPath)
                          .build();

      VolumeUpdateRequest volReq = VolumeUpdateRequest.newBuilder()
              .setCreds(getUserCredentials())
              .setVolProperties(newVolProps)
              .build();

      try {
          if (isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
            data = CLDBRpcCommonUtils.getInstance()
              .sendRequest(getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM, 0),
                      Common.MapRProgramId.CldbProgramId.getNumber(),
                      CLDBProto.CLDBProg.VolumeUpdateProc.getNumber(),
                      volReq,
                      VolumeUpdateResponse.class);
          } else {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(
                Common.MapRProgramId.CldbProgramId.getNumber(),
                CLDBProto.CLDBProg.VolumeUpdateProc.getNumber(),
                volReq,
                VolumeUpdateResponse.class);
          }

        if (data == null) {
          String msg = "volume fixmountpath response null for volume " + volName;
          out.addError(new OutputError(Errno.EOPFAILED,msg));
          LOG.error(msg);
          continue;
        }

        VolumeUnMountResponse resp = VolumeUnMountResponse.parseFrom(data);
        if (resp.getStatus() == 0) {
          String msg = String.format(
            "volume: %s, corrected mountpath to: %s (old=%s)",
                volName, newPath, rwVolumeMountDir);

          out.addMessage(msg);
          LOG.info(msg);
        } else {
          String msg = "Volume fixmountpath: " + Errno.toString(resp.getStatus());
          out.addError(new OutputError(resp.getStatus(), msg));
          LOG.error(msg);
        }
      } catch (MaprSecurityException e) {
        throw new CLIProcessingException(
          "MaprSecurityException " + "Exception", e);
      } catch (Exception e) {
        String msg = "Volume fixmountpath: Operation failed: " + e;
        out.addError(new OutputError(Errno.EOPFAILED, msg));
        LOG.error(msg);
      }
    }

    return output;
  }

  boolean checkEntityExists(boolean type, String name) {
    String cmd = null;
    if (name.equals("allusers"))
      return true;
    
    if (type == false) {
      cmd = "getent passwd " + name;
    } else {
      cmd = "getent group " + name;
    }
    
    try {
       String result = (new TextCommandOutput(executeSimpleSHHCommand(6000L, cmd))).toString();
       if (result == null || result.isEmpty()) {
           return false;
       }
       return true;
    } catch (Exception e) {
       return false;
    }
  }
  
  private String getIPAddress(String host) {
    String ipAddress = null;
    try {
      InetAddress addr = InetAddress.getByName(host);
      ipAddress = addr.getHostAddress();
      
      if (ipAddress.equalsIgnoreCase("127.0.0.1") ||
          ipAddress.equalsIgnoreCase("127.0.1.1")) {
        return null;
      }
    } catch (UnknownHostException e) {
      /**
      * <MAPR_ERROR>
      * Message:Unknown host exception <error>
      * Function:VolumeCommands.getIPAddress()
      * Meaning:An error occurred.
      * Resolution:Contact technical support.
      * </MAPR_ERROR>
      */
      LOG.error("Unknown host exception " + e);
    }
    return ipAddress;
  }

  private String getRwVolumeName() throws CLIProcessingException {
    return isParamPresent(RW_VOLUME_PARAM_NAME) ? getParamTextValue(VolumeCommands.RW_VOLUME_PARAM_NAME, 0) : null;
  }

  private String getOutputParamValue() throws CLIProcessingException {
    return isParamPresent(OUTPUT_PARAM_NAME) ? getParamTextValue(OUTPUT_PARAM_NAME, 0) : "";
  }

  private String getColumnsParamValue() throws CLIProcessingException {
    return isParamPresent(COLUMNS_PARAM_NAME) ? getParamTextValue(COLUMNS_PARAM_NAME, 0) : null;
  }

  private int getLimitParamValue() throws CLIProcessingException {
    return isParamPresent(LIMIT_PARAM_NAME) ? getParamIntValue(LIMIT_PARAM_NAME, 0) : Integer.MAX_VALUE;
  }

  private int getStartParamValue() throws CLIProcessingException {
    return isParamPresent(START_PARAM_NAME) ? getParamIntValue(START_PARAM_NAME, 0) : 0;
  }

  private boolean volumeChangeMirrorMode(String rwVolumeName, 
    VolumeProperties oldVolProps, OutputHierarchy out) throws CLIProcessingException {
    boolean failed = false;
    if ( isParamPresent(VolumeCommands.MIRROR_VOLUME)) {
      int volTargettype = 3;
      String mirrorType = getParamTextValue(MIRROR_VOLUME, 0);
      if (!mirrorType.equalsIgnoreCase("rw") &&
        !mirrorType.equalsIgnoreCase("mirror") &&
        !mirrorType.equalsIgnoreCase("0") &&
          !mirrorType.equalsIgnoreCase("1")) {
          out.addError(new OutputError(Errno.EINVAL, 
        		           "Invalid type " + mirrorType +
                       " specified. Please specify rw/mirror")
                           .setField(MIRROR_VOLUME_SRC_VOLUMENAME));          
          return true;
      }

      boolean isVolumeMirror = oldVolProps.getIsMirrorVol();
      int oldVolType = 0;
      if (oldVolProps.hasVolumetype())
        oldVolType = oldVolProps.getVolumetype().getNumber();

      if (oldVolType == 0 || oldVolType == 1) {
        out.addError(new OutputError(Errno.EINVAL,
                     rwVolumeName + " is a standard volume"));
        return true;
      }

      boolean convertToMirror = mirrorType.equalsIgnoreCase("mirror") ||
                             mirrorType.equalsIgnoreCase("1");
      if (isVolumeMirror && convertToMirror) {
        out.addError(new OutputError(Errno.EINVAL,
                     rwVolumeName + " is already a mirror volume"));
        return true;
      }

      if (!isVolumeMirror && !convertToMirror) { 
        out.addError(new OutputError(Errno.EINVAL,
                     rwVolumeName + " is already a rw volume"));
        return true;
      }

      if (convertToMirror &&
          (oldVolProps.getMirrorInfo().getSrcVolumeId() == 0) &&
          !isParamPresent(MIRROR_VOLUME_SRC_VOLUMENAME)) {
        out.addError(new OutputError(Errno.EINVAL,
                     rwVolumeName + " does not have source volume." +
                     " Please specify the source volume"));
        return true;
      }

      // Audit volumes cannot be converted to mirror
      if (convertToMirror && oldVolProps.getIsAuditVolume()) {
        out.addError(new OutputError(Errno.EINVAL,
                      rwVolumeName + " is an audit volume." +
                      " Cannot convert to mirror volume"));
        return true;
      }

      if (convertToMirror)
        volTargettype = 2;
      boolean ismirror = (volTargettype == 1 || volTargettype == 2);
      
      VolumeChangeMirrorModeRequest.Builder volumeCmmr = VolumeChangeMirrorModeRequest.newBuilder();
      volumeCmmr.setVolumeName( rwVolumeName ); 
      volumeCmmr.setMirrorMode( ismirror ); 
      volumeCmmr.setCreds(getUserCredentials());
      byte[] data = null;
      try {
          if ( isParamPresent(MapRCliUtil.CLUSTER_NAME_PARAM)) {
        	  data = CLDBRpcCommonUtils.getInstance().sendRequest(getParamTextValue(MapRCliUtil.CLUSTER_NAME_PARAM,0),
        			  Common.MapRProgramId.CldbProgramId.getNumber(),
        			  CLDBProto.CLDBProg
                      .VolumeChangeMirrorModeProc.getNumber(), 
                      volumeCmmr.build(), VolumeChangeMirrorModeResponse.class);
          } else {
        	  data = CLDBRpcCommonUtils.getInstance().sendRequest(
        			  Common.MapRProgramId.CldbProgramId.getNumber(),
        			  CLDBProto.CLDBProg
                      .VolumeChangeMirrorModeProc.getNumber(), 
                      volumeCmmr.build(), VolumeChangeMirrorModeResponse.class);
          }

         if (data == null) {
           out.addError(new OutputError(Errno.ERPCFAILED, "Volume mode change: Couldn't connect to the CLDB service"));
           failed = true;
         }  
        VolumeChangeMirrorModeResponse resp = VolumeChangeMirrorModeResponse.parseFrom(data);
        if (resp.getStatus() == 0) {
          if (LOG.isInfoEnabled())
            LOG.info("Volume mode changed for " + rwVolumeName);
        } else if (resp.getStatus() == Errno.EINPROGRESS) {
          out.addError(new OutputError(resp.getStatus(),
                         "Cannot convert volume " + rwVolumeName +
                         " as mirror op is in progress"));
          LOG.error("Cannot convert volume " + rwVolumeName +
                    " as mirror op is in progress");
          failed = true;
        } else {
          out.addError(new OutputError(resp.getStatus(), "Volume mode change: " + 
              " VolumeName: " + rwVolumeName + " " + Errno.toString(resp.getStatus())));
          LOG.error("Volume mode change failed, " + Errno.toString(resp.getStatus()));
          failed = true;
        }
      } catch (Exception e) {
        out.addError(new OutputError(Errno.EOPFAILED, "Volume mode change: " + 
            " VolumeName: " + rwVolumeName + Errno.toString(Errno.EOPFAILED) +
            " Volume mode change failed"));
        LOG.error("Exception during Volume mode change ", e);
        failed = true;
      }
    }
    return failed;
  }

  /**
   * 
   * @param volumeAceParameterMap
   * @return
   * @throws IOException If any of the volume aces argument is incorrectly specified
   */
  private VolumeAces buildVolumeAcesProtobuf(
      Map<String, VolumeActions> volumeAceParameterMap) 
      throws IOException, CLIProcessingException {
    VolumeAces.Builder acesBuilder = VolumeAces.newBuilder();
    for (String param : volumeAceParameterMap.keySet()) {
      if (isParamPresent(param)) {
        String arg = getParamTextValue(param, 0);
        acesBuilder.addAces(VolumeAceEntry.newBuilder()
            .setAccessType(volumeAceParameterMap.get(param))
            .setExpr(ByteString.copyFromUtf8(AceHelper.toPostfix(arg)))
            .build());
      }
    }
    return ((acesBuilder.getAcesCount() > 0) ? acesBuilder.build() : null);
  }
}
