/* Copyright (c) 2012 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.Errno;

import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.CLICommand.ExecutionTypeEnum;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy.OutputError;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy.OutputNode;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import com.mapr.cliframework.base.ProcessedInput;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.Log;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRedSlotUtil;

public final class TasksMemory extends CLIBaseClass implements CLIInterface {
  
  private static final Log LOG = LogFactory.getLog(TasksMemory.class);
  private final Configuration conf = new JobConf();
  private static final String TASKS_MEMORY_PARAM = "memorymb";

  static final CLICommand tasksMemCommand =
    new CLICommand (
        "tasksmemory", 
        "tasksmemory",
        TasksMemory.class, ExecutionTypeEnum.NATIVE,
        new ImmutableMap.Builder<String, BaseInputParameter>()
        .put(
            TasksMemory.TASKS_MEMORY_PARAM,
            new LongInputParameter(
                TasksMemory.TASKS_MEMORY_PARAM, "memorymb",
                CLIBaseClass.REQUIRED, null))
                .build(), 
                null)
    .setUsageInVisible(true);

  public TasksMemory(ProcessedInput input, CLICommand cliCommand) {
    super(input, cliCommand);
  }
  
  @Override
  public CommandOutput executeRealCommand() throws CLIProcessingException {
    final OutputHierarchy out = new OutputHierarchy();
    CommandOutput output = new CommandOutput();
    output.setOutput(out);

    final long memoryForTasks = getParamLongValue(TasksMemory.TASKS_MEMORY_PARAM, 0);
    final long memoryForTasksNew = MapRedSlotUtil.adjustSlots(conf, memoryForTasks);
    out.addNode(new OutputNode("memorymb", memoryForTasksNew));
    return output;
  }
}
