/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;

import com.mapr.cli.common.CopyTableCallable;
import com.mapr.cliframework.base.*;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy.OutputError;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy.OutputNode;
import com.mapr.cliframework.base.inputparams.*;
import com.mapr.fs.AceHelper;

import java.io.IOException;

import org.apache.log4j.Logger;

public class TargetCommands extends CLIBaseClass implements CLIInterface, AceHelper.DBPermission {
  private static final Logger LOG = Logger.getLogger(TargetCommands.class);

  private static final String TARGET_CMD_NAME = "target";
  private static final String ELASTICSEARCH_CMD_NAME = "elasticsearch";

  public static final CLICommand targetCommands =
      new CLICommand(
          TARGET_CMD_NAME,
          TARGET_CMD_NAME,
          CLIUsageOnlyCommand.class,
          CLICommand.ExecutionTypeEnum.NATIVE,
          new CLICommand[] {
             ElasticsearchCommands.esTargetCommands
          }
      ).setUsageInVisible(true)
      .setShortUsage(String.format("%s [%s]", TARGET_CMD_NAME, ELASTICSEARCH_CMD_NAME));

  public TargetCommands(ProcessedInput input, CLICommand cliCommand) {
    super(input, cliCommand);
  }

  @Override
  public CommandOutput executeRealCommand() throws CLIProcessingException {
    OutputHierarchy out = new OutputHierarchy();
    CommandOutput output = new CommandOutput();
    output.setOutput(out);

    if (!super.validateInput()) {
      return output;
    }

    return output;
  }

  @Override
  public String getCliParam(String key) throws IOException {
    String ret = null;

    // If permissions map val is a passed as parameter, then add to ace list
    try {
      if (isParamPresent(key)) {
        ret = getParamTextValue(key, 0);
        if (ret != null) {
          ret = ret.trim();
        }
      }
    } catch (CLIProcessingException e) {
      throw new IOException(e);
    }
    return ret;
  }
}
