/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.cli;

import java.util.ArrayList;
import java.util.List;

import com.mapr.cli.schedulepolicy.commands.SchedulePolicyCreateCommand;
import com.mapr.cli.schedulepolicy.commands.SchedulePolicyListCommand;
import com.mapr.cli.schedulepolicy.commands.SchedulePolicyModifyCommand;
import com.mapr.cli.schedulepolicy.commands.SchedulePolicyRemoveCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLICommandRegistry;
import com.mapr.cliframework.base.CLIRegistryInterface;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CLICommand.ExecutionTypeEnum;
import com.mapr.cli.marlin.StreamsCommands;

public class MapRCLIRegistry implements CLIRegistryInterface {
  private static MapRCLIRegistry s_instance = new MapRCLIRegistry();

  private MapRCLIRegistry() {
  }

  public static MapRCLIRegistry getInstance() {
    return s_instance;
  }

  @Override
  public void register() {
  	registerLogin();
    registerVolume();
    registerNode();
    registerTrace();
    registerDump();
    registerDisk();
    registerConfig();
    registerEntity();
    registerPolicyCommands();
    registerDashboard();
    registerAlarms();
    registerVirtualIp();
    registerAclCommands();
    registerNagios();
    registerLogLevelCommands();
    registerLicenseCmds();
    registerNfsMgmtCmds();
    CLICommandRegistry.getInstance().register(ServiceLinkCommand.serviceLinkCommand);
    registerServiceCmds();
    registerMetrics();
    registerUpgradeCmds();
    registerJobCmds();
    registerRlimitCommands();
    registerDebugDb();
    registerDbCommands();
    registerTargetCommands();
    registerBlacklistCommands();
    registerSecurity();
    registerTasksMemory();
    registerMcsCommands();
    registerClusterCommands();
    registerAuditCommands();
    registerStreamsCommands();
    registerFidCommands();
    registerTedCommands();
  }

  void registerServiceCmds() {
    CLICommandRegistry.getInstance().register(ServiceCommands.serviceCommands);
  }

  void registerUpgradeCmds() {
    CLICommandRegistry.getInstance().register(UpgradeCommands.UpgradeCommands);
  }

  void registerJobCmds() {
    CLICommandRegistry.getInstance().register(JobCommands.jobCmds);
    CLICommandRegistry.getInstance().register(JobCommands.taskCmds);
  }

  void registerLicenseCmds() {
    CLICommandRegistry.getInstance().register (LicenseCommands.licenseCommands);
    CLICommandRegistry.getInstance().register (EulaCommands.eulaCommands);
  }

  void registerNfsMgmtCmds() {
    CLICommandRegistry.getInstance().register (NFSMgmtCommands.nfsMgmtCmds);
  }

  void registerVirtualIp() {
    CLICommandRegistry.getInstance().register (
          VirtualIPCommands.virtualIpsCommand
        );
  }

  void registerNode() {
    CLICommandRegistry.getInstance().register(ServerCommands.serverCommands);

  }

  void registerLogin() {
    CLICommandRegistry.getInstance().register(LoginCommand.loginCommand);
  }

  void registerTrace() {
    CLICommandRegistry.getInstance().register(TraceCommands.traceCommands);
  }

  void registerDbCommands() {
  	CLICommandRegistry.getInstance().register(DbCommands.tableCommands);
  }

  void registerTargetCommands() {
    CLICommandRegistry.getInstance().register(TargetCommands.targetCommands);
  }

  void registerBlacklistCommands() {
  	CLICommandRegistry.getInstance().register(BlacklistCommands
                                                   .blacklistCommands);
  }

  void registerAuditCommands() {
  	CLICommandRegistry.getInstance().register(AuditCommands
                                                .auditCommands);
  }

  void registerVolume() {
    List<CLICommand> subCommands = new ArrayList<CLICommand>();
    subCommands.add(VolumeCommands.volumeAuditCommand);
    subCommands.add(VolumeCommands.volumeCreateCommand);
    subCommands.add(VolumeCommands.volumeUnMountCommand);
    subCommands.add(VolumeCommands.volumeMountCommand);
    subCommands.add(VolumeCommands.volumeShowMountsCommand);
    for (CLICommand c : VolumeCommands.volumeCommands)
      subCommands.add(c);
    CLICommand[] subCommandArray = (CLICommand[]) (subCommands
        .toArray(new CLICommand[subCommands.size()]));
    CLICommand volumeCommands =
      new CLICommand("volume",
                     "volume",
                     CLIUsageOnlyCommand.class,
                     ExecutionTypeEnum.NATIVE,
                     subCommandArray)
        .setShortUsage("volume [create|modify|remove|" +
                       "mount|unmount|list|snapshot|mirror|dump|" +
                       "rename|upgradeformat|move|link|info|showmounts|" +
                       "fixmountpath]");
    CLICommandRegistry.getInstance().register(volumeCommands);
  }

  void registerDump() {
    CLICommand dumpCommands = new CLICommand("dump", /* name of command */
    "internal dump", /* usage/description */
    CLIUsageOnlyCommand.class, /*
                                * Since dump is not a command by itself it has
                                * commands under it, it extends usage-only class
                                */
    ExecutionTypeEnum.NATIVE, new CLICommand[] { /* array of subcommands */
        //DumpCommands.changeLogCommand,
        DumpCommands.dumpContainerInfo,
        DumpCommands.dumpVolumeInfo,
        DumpCommands.dumpVolumeNodes,
        DumpCommands.dumpFileServerWorkInfo,
        DumpCommands.dumpReplicationManagerInfo,
        DumpCommands.dumpReplicationManagerQueueInfo,
        DumpCommands.dumpRereplicationInfo,
        DumpCommands.dumpRereplicationMetrics,
        DumpCommands.dumpBalancerInfo,
        DumpCommands.dumpBalancerMetrics,
        DumpCommands.dumpRoleBalancerInfo,
        DumpCommands.dumpRoleBalancerMetrics,
        DumpCommands.dumpZKInfo,
        DumpCommands.supportDumpTrigger,
        DumpCommands.cldbNodesCommand,
        DumpCommands.dumpContainersCommand,
        DumpCommands.dumpAssignVouchers,
        DumpCommands.dumpActiveWriters,
        DumpCommands.dumpCLDBMemoryInfo,
        }
    ).setShortUsage("dump [containerinfo|" +
        "containers|" +
        "volumeinfo|volumenodes|replicationmanagerinfo|" +
        "replicationmanagerqueueinfo|rereplicationinfo|rereplicationmetrics|" +
        "balancerinfo|balancermetrics|" +
        "rolebalancerinfo|rolebalancermetrics|" +
        "assignvouchers|" +
        "fileserverworkinfo|" +
        "zkinfo|supportdump|cldbnodes]");

    CLICommandRegistry.getInstance().register(dumpCommands);
  }

  void registerFidCommands() {
    CLICommand fidCommands = new CLICommand("fid" /* name of command */,
                                            "mapr-db support tools" /* usage description */,
                                            CLIUsageOnlyCommand.class,
                                            ExecutionTypeEnum.NATIVE, new CLICommand[] {
                                                FidCommands.dump,
                                                FidCommands.stat,
                                            }
                                           ).setShortUsage("fid [dump|" +
                                                               "stat]");
    CLICommandRegistry.getInstance().register(fidCommands);
  }

  void registerDebugDb() {
    CLICommand debugDbCommands = new CLICommand("debugdb", /* name of command */
    "mapr-db internal debug", /* usage/description */
    CLIUsageOnlyCommand.class, /*
                                * Since debugdb is not a command by itself it
                                * has commands under it, it extends usage-only
                                * class
                                */
    ExecutionTypeEnum.NATIVE, new CLICommand[] { /* array of subcommands */
        DebugDbCommands.dumpTable,
        DebugDbCommands.dump,
        DebugDbCommands.cdscan,
        DebugDbCommands.bmap,
        DebugDbCommands.stat,
        DebugDbCommands.checkTablet,
        DebugDbCommands.statTablet,
        DebugDbCommands.partitionSplits,
        DebugDbCommands.switchMaster,
        DebugDbCommands.rawScan,
        DebugDbCommands.multiOp,
        DebugDbCommands.getHostNames,
        }
    ).setShortUsage("debugdb " +
                        "cdscan|" +
                        "bmap|" +
                        "checkTablet|" +
                        "rawScan|" +
                        "multiOp");

    CLICommandRegistry.getInstance().register(debugDbCommands);
  }

  void registerDisk() {
    CLICommandRegistry.getInstance().register(DiskCommands.diskCommands);
    CLICommandRegistry.getInstance().register(CheckContainerRepl.checkContainerReplCmd);
  }

  void registerConfig() {
    CLICommandRegistry.getInstance().register(ConfigCommands.configCmds);
    CLICommandRegistry.getInstance()
        .register(UserConfigCommands.userconfigCmds);
  }

  void registerEntity() {
    CLICommandRegistry.getInstance().register(EntityCommands.entityCmds);
  }

  /**
   * Register schedule policies commands
   */
  void registerPolicyCommands() {
    CLICommand[] subCommandArray = new CLICommand[] {
        SchedulePolicyCreateCommand.schedulePolicyCreateCommand,
        SchedulePolicyListCommand.schedulePolicyListCommand,
        SchedulePolicyModifyCommand.schedulePolicyModifyCommand,
        SchedulePolicyRemoveCommand.schedulePolicyRemoveCommand };

    CLICommand schedulePoliciesCommands = new CLICommand("schedule",
        "schedule", CLIUsageOnlyCommand.class, ExecutionTypeEnum.NATIVE,
        subCommandArray).setShortUsage("schedule [create|modify|list|remove]");

    CLICommandRegistry.getInstance().register(schedulePoliciesCommands);
  }

  void registerDashboard() {
    CLICommandRegistry.getInstance().register(Dashboard.dashboardCmds);
  }

  void registerAlarms() {
    CLICommandRegistry.getInstance().register(AlarmCommands.alarmCmds);
  }

  void registerAclCommands() {
    CLICommandRegistry.getInstance().register(AclCommands.aclCommands);
  }

  void registerTedCommands() {
    CLICommandRegistry.getInstance().register(TedCommands.commands);
  }

  void registerRlimitCommands() {
	CLICommandRegistry.getInstance().register(RlimitCommands.rlimitCommands);
  }

  void registerNagios() {
    CLICommandRegistry.getInstance().register(NagiosCommands.nagiosCmds);
  }

 void  registerLogLevelCommands() {
	 CLICommand[] subCommandArray = new CLICommand[] {
			 LogLevelChangesCommand.cldbChangeLogLevelCommand,
			 LogLevelChangesCommand.hbMasterChangeLogLevelCommand,
			 LogLevelChangesCommand.hbRegionChangeLogLevelCommand,
			 LogLevelChangesCommand.jtChangeLogLevelCommand,
			 LogLevelChangesCommand.mfsChangeLogLevelCommand,
			 LogLevelChangesCommand.nfsChangeLogLevelCommand,
			 LogLevelChangesCommand.ttChangeLogLevelCommand };
	 CLICommand setloglevelcommands = new CLICommand("setloglevel",
		        "setloglevel", CLIUsageOnlyCommand.class, ExecutionTypeEnum.NATIVE,
		        subCommandArray).setShortUsage("setloglevel [cldb|fileserver|nfs|jobtracker|tasktracker|hbmaster|hbregionserver]");

	 CLICommandRegistry.getInstance().register(setloglevelcommands);
  }

 void registerMetrics() {
   CLICommandRegistry.getInstance().register(DialHomeCommands.dialhomeCmds);
 }

 void registerSecurity() {
   CLICommandRegistry.getInstance().register(SecurityCommands.securityCommands);
 }


 void registerTasksMemory() {
   CLICommandRegistry.getInstance().register(TasksMemory.tasksMemCommand);
 }

 void registerMcsCommands() {
	 CLICommandRegistry.getInstance().register(McsCommands.mcsCommands);
 }


 void registerClusterCommands() {
     CLICommandRegistry.getInstance().register(ClusterCommands.clusterCommands);
 }

 void registerStreamsCommands() {
   CLICommandRegistry.getInstance().register(StreamsCommands.streamCommands);
 }

}
