package com.mapr.cli;

import java.util.Map;

import org.apache.log4j.Logger;

import com.mapr.baseutils.Errno;
import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.cli.common.AuthManager;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy;
import com.mapr.cliframework.base.CommandOutput.OutputHierarchy.OutputError;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.ProcessedInput.Parameter;

public class LoginCommand extends CLIBaseClass {

  @SuppressWarnings("unused")
  private static final Logger LOG = Logger.getLogger(LoginCommand.class);

  public static final String USER_PARAM_NAME = "user";
  private AuthManager authManager;

  public static final CLICommand loginCommand =
      new CLICommand (
          "login",
          "login -user",
          LoginCommand.class,
          CLICommand.ExecutionTypeEnum.NATIVE)
      .setShortUsage("login -user")
      .setUsageInVisible(true);

  public LoginCommand(ProcessedInput input, CLICommand cliCommand) {
    super(input, cliCommand);
    authManager = AuthManager.getInstance();
  }

  private CommandOutput login() throws CLIProcessingException {

    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    output.setOutput(out);

    /* Step 1: Validate User Input */
    Map<String, Parameter> parameters = input.getAllParameters();
    if (parameters.containsKey("user") == false) {
      out.addError(new OutputError(Errno.EINVAL, "User Name Required"));
      return output;
    }

    Parameter param = parameters.get(USER_PARAM_NAME);
    String user = param.getParamValues().get(0);
    if ((user == null) || user.trim().isEmpty()) {
      out.addError(new OutputError(Errno.EINVAL,
          "Invalid user  " + Errno.toString(Errno.EINVAL)));
      return output;
    }
    
    authManager.canPerformClusterActions(SecurityCommandHelper.CLUSTER_READ_MASK, 
        getUserCredentials(), out);

    return output;
  }

  @Override
  public CommandOutput executeRealCommand() throws CLIProcessingException {
    CommandOutput output = new CommandOutput();
    OutputHierarchy out = new OutputHierarchy();
    if (!super.validateInput()) {
      out.addError(new OutputError(Errno.EINVAL, "Invalid Input"));
      output.setOutput(out);
      return output;
    }

    String command = cliCommand.getCommandName();
    if (command.equalsIgnoreCase("login")) {
      return login();
    } else {
      out.addError(new OutputError(Errno.EINVAL, "Unknown command"));
      output.setOutput(out);
      return output;
    }
  }
}
