/**
 *  Common code to extract disabled and enabled audit Ops in string format
 */
package com.mapr.baseutils.utils;

import com.mapr.fs.cldb.proto.CLDBProto.VolumeProperties;
import com.mapr.fs.proto.Common.FSAuditOperations;

public class GetStringsForAuditOps {
  
  public static String getDisabledOps(long disabledOpsVec)
  {
    return getOps(disabledOpsVec, true);
  }

  public static String getEnabledOps(long disabledOpsVec)
  {
    return getOps(disabledOpsVec, false);
  }

  private static String getOps(long disabledOpsVec, boolean disabled)
  {
    StringBuilder disabledOps = new StringBuilder();

    for (int i = 1; i < 64; i++) {
      disabledOpsVec = disabledOpsVec >> 1;
      if (disabled && ((disabledOpsVec & 1) == 0)) continue;
      if (!disabled && ((disabledOpsVec & 1) == 1)) continue;

      if (i == FSAuditOperations.AuditGetattr.getNumber()) disabledOps.append("getattr,");
      else if  (i == FSAuditOperations.AuditSetattr.getNumber()) disabledOps.append("setattr,");
      else if (i == FSAuditOperations.AuditChown.getNumber()) disabledOps.append("chown,");
      else if (i == FSAuditOperations.AuditChperm.getNumber()) disabledOps.append("chperm,");
      else if (i == FSAuditOperations.AuditChgrp.getNumber()) disabledOps.append("chgrp,");
      else if (i == FSAuditOperations.AuditGetxattr.getNumber()) disabledOps.append("getxattr,");
      else if (i == FSAuditOperations.AuditListxattr.getNumber()) disabledOps.append("listxattr,");
      else if (i == FSAuditOperations.AuditSetxattr.getNumber()) disabledOps.append("setxattr,");
      else if (i == FSAuditOperations.AuditRemovexattr.getNumber()) disabledOps.append("removexattr,");
      else if (i == FSAuditOperations.AuditGetperm.getNumber()) disabledOps.append("getperm,");
      else if (i == FSAuditOperations.AuditRead.getNumber()) disabledOps.append("read,");
      else if (i == FSAuditOperations.AuditWrite.getNumber()) disabledOps.append("write,");
      else if (i == FSAuditOperations.AuditCreate.getNumber()) disabledOps.append("create,");
      else if (i == FSAuditOperations.AuditDelete.getNumber()) disabledOps.append("delete,");
      else if (i == FSAuditOperations.AuditMkdir.getNumber()) disabledOps.append("mkdir,");
      else if (i == FSAuditOperations.AuditReaddir.getNumber()) disabledOps.append("readdir,");
      else if (i == FSAuditOperations.AuditRmdir.getNumber()) disabledOps.append("rmdir,");
      else if (i == FSAuditOperations.AuditCreatesym.getNumber()) disabledOps.append("createsym,");
      else if (i == FSAuditOperations.AuditLookup.getNumber()) disabledOps.append("lookup,");
      else if (i == FSAuditOperations.AuditRename.getNumber()) disabledOps.append("rename,");
      else if (i == FSAuditOperations.AuditCreatedev.getNumber()) disabledOps.append("createdev,");
      else if (i == FSAuditOperations.AuditTruncate.getNumber()) disabledOps.append("truncate,");
      else if (i == FSAuditOperations.AuditDbCfcreate.getNumber()) disabledOps.append("tablecfcreate,");
      else if (i == FSAuditOperations.AuditDbCfdelete.getNumber()) disabledOps.append("tablecfdelete,");
      else if (i == FSAuditOperations.AuditDbCfmodify.getNumber()) disabledOps.append("tablecfmodify,");
      else if (i == FSAuditOperations.AuditDbCfscan.getNumber()) disabledOps.append("tablecfScan,");
      else if (i == FSAuditOperations.AuditDbGet.getNumber()) disabledOps.append("tableget,");
      else if (i == FSAuditOperations.AuditDbPut.getNumber()) disabledOps.append("tableput,");
      else if (i == FSAuditOperations.AuditDbScan.getNumber()) disabledOps.append("tablescan,");
      else if (i == FSAuditOperations.AuditDbTablecreate.getNumber()) disabledOps.append("tablecreate,");
      else if (i == FSAuditOperations.AuditDbTableinfo.getNumber()) disabledOps.append("tableinfo,");
      else if (i == FSAuditOperations.AuditDbTablemodify.getNumber()) disabledOps.append("tablemodify,");
      else if (i == FSAuditOperations.AuditGetpathforfid.getNumber()) disabledOps.append("getpathforfid,");
      else if (i == FSAuditOperations.AuditHardLink.getNumber()) disabledOps.append("hardlink,");
       // else must be the op not exposed to user
    }
    if (disabledOps.length() > 0)
      disabledOps.setLength(disabledOps.length() - 1);
    return disabledOps.toString();
  }
}
