package com.mapr.baseutils.threadpool;

// defines how to increase the size of a thread pool
public class ThreadPoolGrowth {
  /*
   * Defines how to grow a thread pool size.
   * Normally specified as an array - with the last index containing all max values.
   */
  
  /*
   * current size of the thread pool
   */
  int curSize;
  
  /*
   * Time to wait before growing the size of the pool in milli seconds. 
   */
  int incrementWaitTime;

  /*
   * the size by which the thread pool is increased. new size = curSize + increment.
   */
  int increment;
  
  /*
   * Time to wait before shrinking the size of the pool in milli seconds.
   */
  int decrementWaitTime;
  
  /*
   * the size by which the thread pool is decreased. new size = curSize - decrement.
   */
  int decrement;
  
  public ThreadPoolGrowth(int curSize, int incrementWaitTime, int increment, int decrementWaitTime, int decrement) {
    this.curSize = curSize;
    this.incrementWaitTime = incrementWaitTime;
    this.increment = increment;
    this.decrementWaitTime = decrementWaitTime;
    this.decrement = decrement;
  }

  public int getCurSize() {
    return curSize;
  }

  public int getIncrementWaitTime() {
    return incrementWaitTime;
  }

  public int getIncrement() {
    return increment;
  }

  public int getDecrementWaitTime() {
    return decrementWaitTime;
  }

  public int getDecrement() {
    return decrement;
  }  
}
