package com.mapr.baseutils.threadpool;

import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;
import java.util.Collections;
import java.util.ConcurrentModificationException;

public class HealthCheckMonitor extends Thread
{
  private List<HealthCheck> elements;

  /* the frequency at which the elements are monitored (default, set to 100 ms) */
  static int MONITOR_PERIOD = 100;

  public HealthCheckMonitor(String name) {
    elements = Collections.synchronizedList(new ArrayList<HealthCheck>());
    setName(name);
  }

  public void monitorHealth(HealthCheck elt) {
    elements.add(elt);
  }

  @Override
  public void run()
  {
    boolean doMonitor = true;
    while (doMonitor) {
      try {
        /*
         * sleep for some time and iterate over all elements and ask them to 
         * do healthCheck()
         */
        Thread.sleep(MONITOR_PERIOD);
        Iterator<HealthCheck> iter = elements.iterator();
        while (iter.hasNext()) {
          HealthCheck elt = (HealthCheck)iter.next();
          elt.healthCheck();
        }
      }
      catch (ConcurrentModificationException cme) {
        /* 
         * element added/removed while we are iterating no problem, 
         * call the healthCheck method in the next iteration
         */
      }
      catch (InterruptedException ie) {
        doMonitor = false;
      }
      catch (Exception e) {
      }
    }
  }
}
