package com.mapr.baseutils.metric;

import java.util.ArrayList;
import java.util.List;

import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.Metric;

/**
 * Factory to create concrete MetricRepo objects
 * @author yufeldman
 *
 */
public class MetricRepoFactory {

  private static MetricRepoFactory s_instance = new MetricRepoFactory();
  
  private MetricRepoFactory() {
  }
  
  public static MetricRepoFactory getInstance() {
    return s_instance;
  }
  public List<MetricRepo> getMetricRepo(Metric metric) {
    List<MetricRepo> retValue = new ArrayList<MetricRepo>();
     if ( metric.hasJobMetric() ) {
       retValue.add(new JobMetricRepo(metric.getJobMetric()));
     }
     if ( metric.hasNodeMetric() ) {
       retValue.add(new NodeMetricRepo(metric.getNodeMetric()));
     }
     if ( metric.hasTaskMetric() ) {
       retValue.add(new TaskMetricRepo(metric.getTaskMetric()));
     }
     if ( metric.hasTAttemptMetric() ) {
       retValue.add(new TaskAttemptMetricRepo(metric.getTAttemptMetric()));
     }
     return retValue;
  }
}
