package com.mapr.baseutils.metric;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Types;

import com.mapr.baseutils.BaseUtilsHelper;

import org.apache.log4j.Logger;

import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.MetricAttributes;
/**
 * Base DB insertion class to consolidate common to all different metrics operations
 * @author yufeldman
 *
 */
public abstract class MetricRepoBase implements MetricRepo {

  public static String clusterId =  null;
  private static final Logger LOG = Logger.getLogger(MetricRepoBase.class);
  
  public boolean prepareMetricAttrs(PreparedStatement insertStmt, long time) throws SQLException {
    boolean isAtleastOnePresent = false;
    MetricAttributes metricAttrs = getMetricAttributes();
    if ( metricAttrs == null ) {
      return isAtleastOnePresent;
    }
    insertStmt.setLong(1, time);
    if ( metricAttrs.hasTaskAttemptId()) {
      insertStmt.setString(4, metricAttrs.getTaskAttemptId());
      isAtleastOnePresent = true;
    } else {
      insertStmt.setNull(4, Types.VARCHAR);
    }
    if ( metricAttrs.hasTaskId() ) {
      insertStmt.setString(5, metricAttrs.getTaskId());
      isAtleastOnePresent = true;
    } else {
      insertStmt.setNull(5, Types.VARCHAR);
    }
    if ( metricAttrs.hasJobId() ) {
      insertStmt.setString(6, metricAttrs.getJobId());
      isAtleastOnePresent = true;
    } else {
      insertStmt.setNull(6, Types.VARCHAR);
    }
    if ( metricAttrs.hasNodeId()) {
      insertStmt.setString(7, metricAttrs.getNodeId());
      isAtleastOnePresent = true;
    } else {
      insertStmt.setNull(7, Types.VARCHAR);
    }
    insertStmt.setNull(8, Types.VARCHAR);
    insertStmt.setNull(9, Types.VARCHAR);
    insertStmt.setNull(10, Types.VARCHAR);
    
    return isAtleastOnePresent;
  }

  public String getClusterId() {
    if ( clusterId != null ) {
      return clusterId;
    } else {
      String maprHome = BaseUtilsHelper.getPathToMaprHome();

      if ( maprHome != null ) {
        BufferedReader fis = null;
        try {
          fis = new BufferedReader(new FileReader(maprHome + "/conf/clusterid"));
          String clusterString = fis.readLine();
          String [] clusterNames = clusterString.split("\\s");
          clusterId = clusterNames[0];
          fis.close();
        } catch(FileNotFoundException fne) {
          LOG.error("Exception while trying to get info from clusterid file", fne);
        } catch (IOException ioe) {
          LOG.error("Exception while trying to read file: " + maprHome + "/conf/clusterid", ioe);
        }  
      }
      return clusterId;
    }  
  }
    
}
