package com.mapr.baseutils.metric;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.Counters;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.MetricAttributes;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto.Pair;

/**
 * Interface to perform all DB operations to insert/update data in DB
 * @author yufeldman
 *
 */

public interface MetricRepo {

  public List<Counters> prepareTransactions();
  
  public List<Pair> prepareEvents();
  
  public MetricAttributes getMetricAttributes();
  
  public MetricType getMetricType();
  
  public void executeDBOperations(Connection dbConnection) throws SQLException;
  
  public boolean prepareMetricAttrs(PreparedStatement insertStmt, long time) throws SQLException;
  
  public enum MetricType {
    JOB,
    TASK,
    TASKATTEMPT,
    NODE;
  }
}



