package com.mapr.baseutils.fsrpcutils;

import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Fileserver.SnapVolumeResponse;
import com.mapr.fs.proto.Fileserver.SnapVolumeV2Request;
import com.mapr.fs.proto.Security.CredentialsMsg;
import com.mapr.fs.proto.Security.ServerKeyType;

public class FsRpcUtilsTest {

  public static void main(String[] args) throws Exception {
    CredentialsMsg.Builder creds = CredentialsMsg.newBuilder();
    creds.setUid(0);
    creds.addGids(0);
    CredentialsMsg credMsg = creds.build();
    FSRpcUtils rpcUtils = new FSRpcUtils("default", credMsg, 16, 
      ServerKeyType.ServerKey, 0);
    TestGetMsgStatus getMsgStatus = new TestGetMsgStatus();
    
    SnapVolumeV2Request.Builder req = SnapVolumeV2Request.newBuilder();
    SnapVolumeResponse resp = null;
  
    req.setVolId(11);
    req.setSnapName("TESTSNAP2");
    req.setRwRootCid(2049);
    req.setIsMirrorSnapshot(true);
    req.setCreds(credMsg);
    
    int status = rpcUtils.SendRequestToCid(2049, true,
        Common.MapRProgramId.FileServerProgramId.getNumber(),
        Fileserver.FSProg.SnapVolumeV2Proc.getNumber(),
        req.build(), getMsgStatus);
    
    if (status == 0) {
      resp = getMsgStatus.GetMsg();
      System.out.print(resp);
    }
  }

}
