package com.mapr.baseutils.fsrpcutils;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import com.mapr.fs.cldb.proto.CLDBProto.ContainerInfo;
import com.mapr.fs.proto.Common.Server;


public class CidInfo {

  public enum CidInfoState {
    StateInvalid,
    StateValid,
    StateFilling
  }

  int cid;
  int nextReplicaServer;
  CidInfoState state;
  ContainerInfo cInfo;
  ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
  
  public String toString() {
    String s = "cid " + cid;
    s = s.concat(" state " + state);

    if (cInfo == null) {
      return s;
    }

    s = s.concat(" master server :");
    
    if (cInfo.hasMServer()) {
      s = s.concat(Utils.PrintServerIpAddress(cInfo.getMServer()));
    }
    
    s = s.concat(" replica servers :");
    for (int i = 0; i < cInfo.getAServersCount(); ++i) {
      s = s.concat(Utils.PrintServerIpAddress(cInfo.getAServers(i)));
    }
    return s;
  }

  CidInfo(int cid) {
    this.cid = cid;
    this.state = CidInfoState.StateInvalid;
    this.nextReplicaServer = 0;
    this.cInfo = null;
  }
  
  boolean needUpdate(boolean updateMaster) {
    if (state != CidInfoState.StateValid) return true;
    if (updateMaster) {
      return cInfo.hasMServer() ? false : true; 
    }
    if (cInfo.getAServersCount() <= nextReplicaServer) {
      return true;
    }
    return false;
  }
  
  // This function must be called with the rwlock held
  // in write mode.
  void UpdateContainerInfo(ContainerInfo cInfo) {
    this.cInfo = cInfo;
    this.state = CidInfoState.StateValid;
    this.nextReplicaServer = 0;
  }

  public Server getMasterServer() {
    return cInfo.getMServer();
  }

  public Server getNextReplicaServer() {
    return cInfo.getAServers(nextReplicaServer);
  }

  public void incNextReplicaServer() {
    ++nextReplicaServer;
  }
}

