package com.mapr.baseutils.filemonitor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import org.apache.log4j.Logger;

import com.mapr.baseutils.filemonitor.FileSystemListenerBase.FileTime;

public class FileSystemMonitor {

	private List<FileSystemListener> listeners = new ArrayList<FileSystemListener>();
	public static final long TIMER_DELAY = 30000l; // 30 secs.

    // singleton - need jut one filesystem monitor
    private static FileSystemMonitor s_instance = new FileSystemMonitor();
    private static final Logger LOG = Logger.getLogger(FileSystemMonitor.class);
		
	private FileSystemMonitor() {
		Timer timer = new Timer();
		
		FileSystemMonitorNotifier ttask = new FileSystemMonitorNotifier();
		timer.scheduleAtFixedRate(ttask, new Date(), TIMER_DELAY);
	}
	
	public static FileSystemMonitor getInstance() {
		return s_instance;
	}
	

	public void addListener(FileSystemListener fsListener) {
		if ( fsListener != null ) {
			listeners.add(fsListener);
		}
	}
	
	public void removeListener(FileSystemListener fsListener) {
		if ( fsListener != null ) {
			listeners.remove(fsListener);
		}
	}
	
	/**
	 * Running task to notify subscribed listeners of changes to the files listeners subscribed 
	 * @author yufeldman
	 *
	 */
	private class FileSystemMonitorNotifier extends TimerTask {

		@Override
		public void run() {
		  if (LOG.isDebugEnabled() ) {
		    LOG.debug("Got Into Run. Number of listeners: " + listeners.size());
		  }
		  try {
  			for ( FileSystemListener listener : listeners ) {
  				for ( FileTime fileTime : listener.getFiles().values() ) {
  					File file = fileTime.getFile();
  					long lastUpdatedTime = fileTime.getLastUpdateTime();
  					if ( file != null && file.exists() ) {
  						long currentFileTime = file.lastModified();
  						if ( currentFileTime > lastUpdatedTime ) {
  							fileTime.setLastUpdateTime(currentFileTime);
  							if ( LOG.isDebugEnabled()) {
  								try {
  									LOG.debug("Invoke FileChanged on file: " + file.getCanonicalPath());
  								} catch (IOException e) {
  									e.printStackTrace();
  								}
  							}
  							listener.fileChanged(file);
  						}
  					}
  				}
  			}
		  } catch (Throwable t) {
			  LOG.error("Exception while processing fileListeners", t);
			}
		}
		
	}
	
}
