package com.mapr.baseutils.filemonitor;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FileSystemListenerBase implements FileSystemListener {

	private Map<String, FileTime> files = new HashMap<String,FileTime>();
	
	protected FileSystemListenerBase(List<File> files) {
		if ( files != null ) {
			for ( File file : files ) {
				addFile(file);
			}
		}
	}

	protected FileSystemListenerBase(File file) {
		if ( file != null ) {
			addFile(file);
		}
	}

	protected FileSystemListenerBase() {
		
	}

	@Override
	public void addFile(File file) {
		if ( file != null ) {
			String absName = file.getAbsolutePath();
            long lastModifiedTime = 0;
            if ( file.exists()) {
              lastModifiedTime = file.lastModified();
            }
            files.put(absName, new FileTime(file, lastModifiedTime));
		}
	}


	@Override
	public Map<String, FileTime> getFiles() {
		return files;
	}

	@Override
	public void removeFile(File file) {
		if ( file != null ) {
			String absName = file.getAbsolutePath();
			files.remove(absName);
		}
	}

	
	public static class FileTime {
		
		private final File file;
		private long lastUpdateTime;
		
		FileTime(File file, long lastUpdateTime) {
			this.file = file;
			this.lastUpdateTime = lastUpdateTime;
		}

		public File getFile() {
			return file;
		}

		public long getLastUpdateTime() {
			return lastUpdateTime;
		}

		public void setLastUpdateTime(long lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
		}
		
		
	}
}
