package com.mapr.baseutils.audit;

import static com.mapr.baseutils.audit.AuditConstants.*;
import java.util.List;

public class KeyValue {
  
  private String key;
  private String oldValue;
  private String newValue;

  public KeyValue() {
  }

  public KeyValue(String key) {
    this.key = key;
  }

  public KeyValue(String key, String oldValue, String newValue) {
    this.key = key;
    this.oldValue = oldValue;
    this.newValue = newValue;
  }

  public KeyValue(String key, int oldValue, int newValue) {
    this.key = key;
    this.oldValue = Integer.toString(oldValue);
    this.newValue = Integer.toString(newValue);
  }

  public KeyValue(String key, long oldValue, long newValue) {
    this.key = key;
    this.oldValue = Long.toString(oldValue);
    this.newValue = Long.toString(newValue);
  }

  public KeyValue(String key, boolean oldValue, boolean newValue) {
    this.key = key;
    this.oldValue = Boolean.toString(oldValue);
    this.newValue = Boolean.toString(newValue);
  }

  public String getKey() {
    return key;
  }

  public String getOldValue() {
    return oldValue;
  }

  public String getNewValue() {
    return newValue;
  }

  public boolean hasValues() {
    return (key != null || oldValue != null || newValue != null);
  }

  public void setValues(String key, String oldValue, String newValue) {
    this.key = key;
    this.oldValue = oldValue;
    this.newValue = newValue;
  }

  public void reInit() {
    key = null;
    oldValue = null;
    newValue = null;
  }

  /**
   * Example
   * :.."resource":"vol1","properties":{"property:"quota","oldValue":"32","newValue":"64"}
  */ 
  public String toJsonString() {
    StringBuilder sb = new StringBuilder();
    sb.append(QUOTE);
    sb.append(PROPERTIES);
    sb.append(QUOTE);
    sb.append(COLON);
    sb.append(OPENSQUARE);
    this.toJsonStringInternal(sb);
    sb.append(CLOSEDSQUARE);
    return sb.toString();
  }

  static public String toJsonStringSR(List<KeyValue> keyValues) {
    StringBuilder sb = new StringBuilder();
    sb.append(QUOTE);
    sb.append(PROPERTIES);
    sb.append(QUOTE);
    sb.append(COLON);
    sb.append(OPENSQUARE);

    int i =0;
    for (KeyValue keyValue : keyValues) {
      if (i > 0) sb.append(COMMA);
      keyValue.toJsonStringInternal(sb);
      i++;
    }

    sb.append(CLOSEDSQUARE);
    return sb.toString();
  }

  private void toJsonStringInternal(StringBuilder sb) {
    sb.append(OPENFLOWER);
    sb.append(QUOTE);
    sb.append(PROPERTY);
    sb.append(QUOTE);
    sb.append(COLON);
    sb.append(QUOTE);
    sb.append(key);
    sb.append(QUOTE);
    sb.append(COMMA);
    sb.append(QUOTE);
    sb.append(OLDVALUE);
    sb.append(QUOTE);
    sb.append(COLON);
    sb.append(QUOTE);
    if (oldValue != null)
      sb.append(oldValue);
    sb.append(QUOTE);
    sb.append(COMMA);
    sb.append(QUOTE);
    sb.append(NEWVALUE);
    sb.append(QUOTE);
    sb.append(COLON);
    sb.append(QUOTE);
    if (newValue != null)
      sb.append(newValue);
    sb.append(QUOTE);
    sb.append(CLOSEDFLOWER);
  }
}
