package com.mapr.baseutils.audit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Singleton class for all the audit records.
 */
public class AuditRecordLogger {

  public enum LogFormat {
    Json,
    String;
  }

  private static final Log LOG = LogFactory.getLog("AuditLogger");
  private static final AuditRecordLogger auditLogger = new AuditRecordLogger();

  private LogFormat logFormat;
  private AuditJsonFormatter jsonFormatter;
  
  private AuditRecordLogger() {
    logFormat = LogFormat.Json;
    this.jsonFormatter = AuditJsonFormatter.getInstance();
  }

  public static AuditRecordLogger getInstance() {
    return auditLogger;
  }

  public void setAuditLogFormat(LogFormat logFormat) {
    this.logFormat = logFormat;
  }

  public void logAuditRecord(AuditRecord auditRecord) {
    if (auditRecord == null)
      return;

    String logMsg = null;
    
    switch (logFormat) {
      case Json :
        logMsg = jsonFormatter.formatAuditRecord(auditRecord);
        break;
      default :
        break;
    }

    if (logMsg != null && !logMsg.isEmpty())
      LOG.info(logMsg);
  }
}
